/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.SearchFilterManager;
import com.iplanet.am.util.Debug;
import java.util.HashMap;
import java.util.Map;

class ObjectClassManager {
    static Debug debug = CommonUtils.getDebugInstance();
    private static final String DEFAULT_USER_OBJECT_CLASS = "inetorgperson";
    private static final String DEFAULT_RESOURCE_OBJECT_CLASS = "inetcalresource";
    private static final String DEFAULT_ROLE_OBJECT_CLASS = "nsmanagedroledefinition";
    private static final String DEFAULT_FILTERED_ROLE_OBJECT_CLASS = "nsfilteredroledefinition";
    private static final String DEFAULT_ORGANIZATION_OBJECT_CLASS = "organization";
    private static final String DEFAULT_ORGANIZATIONAL_UNIT_OBJECT_CLASS = "organizationalunit";
    private static final String DEFAULT_GROUP_OBJECT_CLASS = "iplanet-am-managed-group";
    private static final String DEFAULT_DYNAMIC_GROUP_OBJECT_CLASS = "groupofurls";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_OBJECT_CLASS = "iplanet-am-managed-assignable-group";
    private static final String DEFAULT_GROUP_CONTAINER_OBJECT_CLASS = "iplanet-am-managed-group-container";
    private static final String DEFAULT_PEOPLE_CONTAINER_OBJECT_CLASS = "nsManagedPeopleContainer";
    public static Map objectClassMap = new HashMap();
    public static Map objectTypeMap = new HashMap();

    ObjectClassManager() {
    }

    public static String getObjectClass(int n) {
        String string = Integer.toString(n);
        String string2 = (String)objectClassMap.get(string);
        if (string2 == null && (string2 = ObjectClassManager.getObjectClassFromDS(n)).length() != 0) {
            objectClassMap.put(string, string2);
        }
        return string2;
    }

    private static String getObjectClassFromDS(int n) {
        String string = SearchFilterManager.getGlobalSearchFilter(n);
        String string2 = "objectclass=";
        int n2 = string.indexOf(string2);
        String string3 = null;
        if (n2 != -1) {
            int n3 = n2 + string2.length();
            int n4 = string.indexOf(41, n3);
            if (n4 != -1) {
                string3 = string.substring(n3, n4);
            }
        } else {
            string3 = ObjectClassManager.getDefaultObjectClass(n);
        }
        if (debug.messageEnabled()) {
            debug.message("ObjectClassManager.getObjectClassFromDS()- objectType: " + n + " objectclass: " + string3.toLowerCase());
        }
        return string3.toLowerCase();
    }

    public static int getObjectType(String string) {
        String string2 = (String)objectTypeMap.get(string.toLowerCase());
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(1))) {
            return 1;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(6))) {
            return 6;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(8))) {
            return 8;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(2))) {
            return 2;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(9))) {
            return 9;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(12))) {
            return 12;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(11))) {
            return 11;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(5))) {
            return 5;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(4))) {
            return 4;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(3))) {
            return 3;
        }
        if (string.equalsIgnoreCase(ObjectClassManager.getObjectClass(21))) {
            return 21;
        }
        return -1;
    }

    private static String getDefaultObjectClass(int n) {
        switch (n) {
            case 1: {
                return DEFAULT_USER_OBJECT_CLASS;
            }
            case 6: {
                return DEFAULT_ROLE_OBJECT_CLASS;
            }
            case 8: {
                return DEFAULT_FILTERED_ROLE_OBJECT_CLASS;
            }
            case 9: {
                return DEFAULT_GROUP_OBJECT_CLASS;
            }
            case 12: {
                return DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_OBJECT_CLASS;
            }
            case 11: {
                return DEFAULT_DYNAMIC_GROUP_OBJECT_CLASS;
            }
            case 2: {
                return DEFAULT_ORGANIZATION_OBJECT_CLASS;
            }
            case 5: {
                return DEFAULT_PEOPLE_CONTAINER_OBJECT_CLASS;
            }
            case 3: {
                return DEFAULT_ORGANIZATIONAL_UNIT_OBJECT_CLASS;
            }
            case 4: {
                return DEFAULT_GROUP_CONTAINER_OBJECT_CLASS;
            }
            case 21: {
                return DEFAULT_RESOURCE_OBJECT_CLASS;
            }
        }
        return "";
    }
}

