/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import java.util.HashMap;
import java.util.Map;

class NamingAttributeManager {
    private static final String DEFAULT_USER_NAMING_ATTR = "uid";
    private static final String DEFAULT_RESOURCE_NAMING_ATTR = "uid";
    private static final String DEFAULT_ROLE_NAMING_ATTR = "cn";
    private static final String DEFAULT_GROUP_NAMING_ATTR = "cn";
    private static final String DEFAULT_ORG_NAMING_ATTR = "o";
    private static final String DEFAULT_ORG_UNIT_NAMING_ATTR = "ou";
    private static final String DEFAULT_PEOPLE_CONTAINER_NAMING_ATTR = "ou";
    private static final String DEFAULT_GROUP_CONTAINER_NAMING_ATTR = "ou";
    private static final String DEFAULT_DYNAMIC_GROUP_NAMING_ATTR = "cn";
    private static final String DEFAULT_FILTERED_ROLE_NAMING_ATTR = "cn";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_NAMING_ATTR = "cn";
    private static final String USER_CREATION_TEMPLATE = "BasicUser";
    private static final String GROUP_CREATION_TEMPLATE = "BasicGroup";
    private static final String MANAGED_ROLE_CREATION_TEMPLATE = "BasicManagedRole";
    private static final String RESOURCE_CREATION_TEMPLATE = "BasicResource";
    private static final String FILTERED_ROLE_CREATION_TEMPLATE = "BasicFilteredRole";
    private static final String ASSIGANABLE_DYNAMIC_GROUP_CREATION_TEMPLATE = "BasicAssignableDynamicGroup";
    private static final String DYNAMIC_GROUP_CREATION_TEMPLATE = "BasicDynamicGroup";
    private static final String ORGANIZATION_CREATION_TEMPLATE = "BasicOrganization";
    private static final String PEOPLE_CONTAINTER_CREATION_TEMPLATE = "BasicPeopleContainer";
    private static final String ORGANIZATIONAL_UNIT_CREATION_TEMPLATE = "BasicOrganizationalUnit";
    private static final String GROUP_CONTAINER_CREATION_TEMPLATE = "BasicGroupContainer";
    private static TemplateManager templateMgr = null;
    private static Debug debug = CommonUtils.getDebugInstance();
    private static Map namingAttrMap = new HashMap();

    NamingAttributeManager() {
    }

    static String getNamingAttribute(int n) {
        return NamingAttributeManager.getNamingAttribute(n, null);
    }

    static String getNamingAttribute(int n, String string) {
        String string2 = new Integer(n).toString() + ":" + MiscUtils.formatToRFC(string);
        String string3 = (String)namingAttrMap.get(string2);
        if (string3 == null && (string3 = NamingAttributeManager.getNamingAttributeFromTemplate(n, string)) != null) {
            namingAttrMap.put(string2, string3);
        }
        return string3;
    }

    private static String getNamingAttributeFromTemplate(int n, String string) {
        try {
            String string2;
            if (templateMgr == null) {
                templateMgr = TemplateManager.getTemplateManager();
            }
            if ((string2 = NamingAttributeManager.getCreationTemplateName(n)) == null) {
                debug.warning("AMNamingAttrMgr.getNamingAttr(objectType, orgDN): (" + n + "," + string + ") Could not " + "determine creation template name. Returning <empty> " + "value");
                return "";
            }
            Guid guid = string == null ? null : new Guid(string);
            CreationTemplate creationTemplate = templateMgr.getCreationTemplate(string2, guid, 1);
            String string3 = creationTemplate.getNamingAttribute();
            if (string3 == null) {
                debug.error("AMNamingAttrManager.getNamingAttr() Naming attribute for Object Type:" + n + " Org DN: " + string + " is null");
            } else if (debug.messageEnabled()) {
                debug.message("AMNamingAttrManager.getNamingAttr(): Naming attribute for Object type= " + n + ": " + string3);
            }
            return string3;
        }
        catch (UMSException uMSException) {
            String string4 = NamingAttributeManager.getDefaultNamingAttr(n);
            debug.warning("Unable to get the naming attribute for " + n + " Using default " + string4);
            return string4;
        }
    }

    private static String getDefaultNamingAttr(int n) {
        switch (n) {
            case 1: {
                return "uid";
            }
            case 6: {
                return "cn";
            }
            case 8: {
                return "cn";
            }
            case 9: {
                return "cn";
            }
            case 12: {
                return "cn";
            }
            case 11: {
                return "cn";
            }
            case 2: {
                return DEFAULT_ORG_NAMING_ATTR;
            }
            case 5: {
                return "ou";
            }
            case 3: {
                return "ou";
            }
            case 4: {
                return "ou";
            }
            case 21: {
                return "uid";
            }
        }
        debug.warning("AMNamingAttrMgr.getDefaultNamingAttr(): Unknown object type is passed. Returning <empty> value");
        return "";
    }

    static String getCreationTemplateName(int n) {
        String string = (String)CommonUtils.creationtemplateMap.get(Integer.toString(n));
        if (string != null) {
            return string;
        }
        switch (n) {
            case 1: {
                return USER_CREATION_TEMPLATE;
            }
            case 6: {
                return MANAGED_ROLE_CREATION_TEMPLATE;
            }
            case 8: {
                return FILTERED_ROLE_CREATION_TEMPLATE;
            }
            case 9: {
                return GROUP_CREATION_TEMPLATE;
            }
            case 12: {
                return ASSIGANABLE_DYNAMIC_GROUP_CREATION_TEMPLATE;
            }
            case 11: {
                return DYNAMIC_GROUP_CREATION_TEMPLATE;
            }
            case 2: {
                return ORGANIZATION_CREATION_TEMPLATE;
            }
            case 5: {
                return PEOPLE_CONTAINTER_CREATION_TEMPLATE;
            }
            case 3: {
                return ORGANIZATIONAL_UNIT_CREATION_TEMPLATE;
            }
            case 4: {
                return GROUP_CONTAINER_CREATION_TEMPLATE;
            }
            case 21: {
                return RESOURCE_CREATION_TEMPLATE;
            }
        }
        debug.warning("AMNamingAttrMgr.getCreationTemplateName(): Unknown object type is passed. Returning null value");
        return null;
    }
}

