/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.IDSEventListener;
import java.util.Map;

class EventManager {
    protected static final int EVENT_SCOPE = 2;
    protected static String EVENT_BASE_NODE = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
    protected static final String ACI_EVENT_LISTENER_CLASS = "com.iplanet.am.sdk.ldap.ACIEventListener";
    protected static final String ENTRY_EVENT_LISTENER_CLASS = "com.iplanet.am.sdk.ldap.EntryEventListener";
    protected static final String[] PSEARCH_LISTENERS = new String[]{"com.iplanet.am.sdk.ldap.ACIEventListener", "com.iplanet.am.sdk.ldap.EntryEventListener"};
    private static Debug debug = Debug.getInstance((String)"amEventService");

    protected EventManager() throws AMEventManagerException {
    }

    protected static Debug getDebug() {
        return debug;
    }

    protected void addListeners(Map map) throws AMEventManagerException {
        EventService eventService = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("EventManager.start() - Getting EventService instance");
            }
            eventService = EventService.getEventService();
        }
        catch (Exception exception) {
            debug.error("EventManager.start() Unable to get EventService ", (Throwable)exception);
            throw new AMEventManagerException(AMSDKBundle.getString("501"), "501");
        }
        if (eventService != null) {
            int n = PSEARCH_LISTENERS.length;
            int n2 = 0;
            while (n2 < n) {
                IDSEventListener iDSEventListener = eventService.getIDSListeners(PSEARCH_LISTENERS[n2]);
                if (iDSEventListener != null) {
                    iDSEventListener.setListeners(map);
                    debug.message("EventManager.start() - Added listeners to pSearch Listener: " + PSEARCH_LISTENERS[n2]);
                }
                ++n2;
            }
        }
    }
}

