/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.common.ICachedDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.ldap.DirectoryServicesFactory;
import com.iplanet.am.sdk.ldap.EventManager;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class EntryEventListener
implements IDSEventListener {
    protected static final String SEARCH_FILTER = "(&(objectclass=*)(!(|(objectclass=sunService)(objectclass=sunServiceComponent)(aci=*))))";
    protected static final int OPERATIONS = 15;
    private Debug debug = EventManager.getDebug();
    private SSOToken internalToken;
    private Map listeners = new HashMap();

    public EntryEventListener() {
        try {
            this.internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        catch (Exception exception) {
            this.debug.error("EntryEventListener() Exception occurred while getting SSOToken", (Throwable)exception);
        }
    }

    private Set getDynamicAttributeNames(String string) {
        Set set;
        block4: {
            set = Collections.EMPTY_SET;
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.internalToken);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                set = serviceSchema.getAttributeSchemaNames();
            }
            catch (SMSException sMSException) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("EntryEventListener.entryChanged(): caught SMSException: ", (Throwable)sMSException);
                }
            }
            catch (SSOException sSOException) {
                if (!this.debug.warningEnabled()) break block4;
                this.debug.error("EntryEventListener.entryChanged(): caught SSOException: ", (Throwable)sSOException);
            }
        }
        return set;
    }

    public void entryChanged(DSEvent dSEvent) {
        DN dN = new DN(dSEvent.getID());
        String string = dN.toRFCString().toLowerCase();
        if (this.debug.messageEnabled()) {
            this.debug.message("EntryEventListener.entryChanged(): DSEvent generated for: " + dN);
        }
        boolean bl = true;
        String string2 = "";
        Set set = Collections.EMPTY_SET;
        String string3 = null;
        String string4 = dSEvent.getClassName();
        if (string4.indexOf("cosClassicDefinition") != -1) {
            string2 = dN.getParent().toRFCString().toLowerCase();
            string3 = dN.explodeDN(true)[0];
            set = this.getDynamicAttributeNames(string3);
            if (this.debug.messageEnabled()) {
                this.debug.message("EntryEventListener.entryChanged() Cos Definition changed for service: " + string3 + "Dynamic Attributes: " + set);
            }
        } else if (string4.indexOf("costemplate") != -1) {
            string2 = dN.getParent().getParent().toRFCString().toLowerCase();
            string3 = dN.getParent().explodeDN(true)[0];
            set = this.getDynamicAttributeNames(string3);
            if (this.debug.messageEnabled()) {
                this.debug.message("EntryEventListener.entryChanged()Cos template changed for service: " + string3 + "Dynamic Attributes: " + set);
            }
        } else {
            bl = false;
            string2 = string;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("EntryEventListener.entryChanged(): Affected dn: " + string2 + " cosType: " + bl);
        }
        IDirectoryServices iDirectoryServices = DirectoryServicesFactory.getInstance();
        Map map = this.listeners;
        synchronized (map) {
            Set set2 = this.listeners.keySet();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                AMObjectListener aMObjectListener = (AMObjectListener)iterator.next();
                Map map2 = (Map)this.listeners.get(aMObjectListener);
                if (bl) {
                    if (DirectoryServicesFactory.isCachingEnabled()) {
                        ((ICachedDirectoryServices)iDirectoryServices).dirtyCache(string2, dSEvent.getEventType(), true, false, set);
                        ((ICachedDirectoryServices)iDirectoryServices).dirtyCache(string, dSEvent.getEventType(), false, false, Collections.EMPTY_SET);
                    }
                    aMObjectListener.objectsChanged(string2, dSEvent.getEventType(), set, map2);
                    aMObjectListener.objectChanged(string, dSEvent.getEventType(), map2);
                    continue;
                }
                if (DirectoryServicesFactory.isCachingEnabled()) {
                    ((ICachedDirectoryServices)iDirectoryServices).dirtyCache(string2, dSEvent.getEventType(), false, false, Collections.EMPTY_SET);
                }
                aMObjectListener.objectChanged(string2, dSEvent.getEventType(), map2);
            }
        }
    }

    public void eventError(String string) {
        this.debug.error("EntryEventListener.eventError(): " + string);
    }

    public void allEntriesChanged() {
        this.debug.error("EntryEventListener: Received all entries changed eventfrom event service");
        IDirectoryServices iDirectoryServices = DirectoryServicesFactory.getInstance();
        if (DirectoryServicesFactory.isCachingEnabled()) {
            ((ICachedDirectoryServices)iDirectoryServices).clearCache();
        }
        Map map = this.listeners;
        synchronized (map) {
            Set set = this.listeners.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMObjectListener aMObjectListener = (AMObjectListener)iterator.next();
                aMObjectListener.allObjectsChanged();
            }
        }
    }

    public String getBase() {
        return EventManager.EVENT_BASE_NODE;
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 15;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map map) {
        this.listeners = map;
    }
}

