/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.DirectoryServicesFactory;
import com.iplanet.am.util.AMSendMail;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SchemaType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import netscape.ldap.util.DN;

public class EmailNotificationHelper {
    public static final String ADMINISTRATION_SERVICE = "iPlanetAMAdminConsoleService";
    public static final String USER_CREATE_NOTIFICATION_LIST = "iplanet-am-user-create-notification-list";
    public static final String USER_DELETE_NOTIFICATION_LIST = "iplanet-am-user-delete-notification-list";
    public static final String USER_MODIFY_NOTIFICATION_LIST = "iplanet-am-user-modify-notification-list";
    public static final String EMAIL_ATTRIBUTE = "mail";
    private static SSOToken internalToken = CommonUtils.getInternalToken();
    private static Debug debug = CommonUtils.getDebugInstance();
    private AMSendMail mailer = null;
    private String entryDN;
    private String organizationDN;
    private Set createNotifyList = Collections.EMPTY_SET;
    private Set deleteNotifyList = Collections.EMPTY_SET;
    private Set modifyNotifyList = Collections.EMPTY_SET;

    public EmailNotificationHelper(String string) {
        this.entryDN = string;
        this.organizationDN = new DN(string).getParent().toString();
        this.mailer = new AMSendMail();
    }

    private void sendEmail(Set set, Map map, String string, String string2, String string3) throws MessagingException {
        String string4 = AMSDKBundle.getString("504");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            String[] stringArray;
            Object object2;
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), "|");
            String string5 = stringTokenizer.nextToken();
            if (string5.equals(string4)) {
                object2 = (Set)map.get(EMAIL_ATTRIBUTE);
                if (object2 == null || object2.isEmpty()) continue;
                if (debug.messageEnabled()) {
                    debug.message("EmailNotificationHelper.sendMail(): Converting to array for: " + object2);
                }
                stringArray = object2.toArray(new String[object2.size()]);
            } else if (string5.startsWith(string4 + ":")) {
                object2 = string5.substring((string4 + ":").length());
                if (object2 == null || ((String)object2).length() == 0 || (object = (Set)map.get(object2)) == null || object.isEmpty()) continue;
                if (debug.messageEnabled()) {
                    debug.message("EmailNotificationHelper.sendMail(): Converting to array for: " + object);
                }
                stringArray = object.toArray(new String[object.size()]);
            } else {
                stringArray = new String[]{string5};
            }
            object2 = null;
            object = null;
            if (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                }
            }
            String string6 = AMSDKBundle.getString(string, (String)object2);
            String string7 = AMSDKBundle.getString(string2, (String)object2);
            String string8 = AMSDKBundle.getString(string3, (String)object2) + " " + this.entryDN;
            this.mailer.postMail(stringArray, string7, string8, string6, (String)object);
        }
    }

    private Set getNotificationList(String string) {
        Set set = Collections.EMPTY_SET;
        try {
            String string2 = DirectoryServicesFactory.getInstance().getOrganizationDN(internalToken, this.organizationDN);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(internalToken);
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string2);
            set = this.getOrgTypeAttributes(aMOrganization, ADMINISTRATION_SERVICE, string);
        }
        catch (AMException aMException) {
            debug.error("EmailNotificationHelper.getNotificationList() Unable to get notification List for " + string + " for user: " + this.entryDN, (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.error("EmailNotificationHelper.getNotificationList() Unable to get notification List for " + string + " for user: " + this.entryDN, (Throwable)sSOException);
        }
        return set;
    }

    public void setUserCreateNotificationList() {
        this.createNotifyList = this.getNotificationList(USER_CREATE_NOTIFICATION_LIST);
    }

    public void setUserDeleteNotificationList() {
        this.deleteNotifyList = this.getNotificationList(USER_DELETE_NOTIFICATION_LIST);
    }

    public void setUserModifyNotificationList() {
        this.modifyNotifyList = this.getNotificationList(USER_MODIFY_NOTIFICATION_LIST);
    }

    public boolean isPresentUserCreateNotificationList() {
        return this.createNotifyList != null && !this.createNotifyList.isEmpty();
    }

    public boolean isPresentUserDeleteNotificationList() {
        return this.deleteNotifyList != null && !this.deleteNotifyList.isEmpty();
    }

    public boolean isPresentUserModifyNotificationList() {
        return this.modifyNotifyList != null && !this.modifyNotifyList.isEmpty();
    }

    public void sendUserCreateNotification(Map map) {
        block3: {
            try {
                if (this.createNotifyList != null && !this.createNotifyList.isEmpty()) {
                    this.sendEmail(this.createNotifyList, map, "497", "490", "493");
                }
            }
            catch (MessagingException messagingException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("EmailNotificationHelper.sendUserCreateNotification() Unable to send email for user: " + this.entryDN, (Throwable)messagingException);
            }
        }
    }

    public void sendUserDeleteNotification(Map map) {
        block3: {
            try {
                if (this.deleteNotifyList != null && !this.deleteNotifyList.isEmpty()) {
                    this.sendEmail(this.deleteNotifyList, map, "497", "491", "494");
                }
            }
            catch (MessagingException messagingException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("EmailNotificationHelper.sendUserDeleteNotification() Unable to send email for user: " + this.entryDN, (Throwable)messagingException);
            }
        }
    }

    public void sendUserModifyNotification(SSOToken sSOToken, Map map, Map map2) {
        if (this.modifyNotifyList == null || this.modifyNotifyList.isEmpty()) {
            return;
        }
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        AttrSet attrSet2 = CommonUtils.mapToAttrSet(map2);
        try {
            String string = AMSDKBundle.getString("504");
            Iterator iterator = this.modifyNotifyList.iterator();
            while (iterator.hasNext()) {
                String string2;
                int n;
                String[] stringArray;
                String string3 = (String)iterator.next();
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                int n2 = stringTokenizer.countTokens();
                if (n2 <= 0) continue;
                String string4 = stringTokenizer.nextToken().toLowerCase();
                boolean bl = false;
                Attr attr = null;
                Attr attr2 = null;
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                if (attrSet.contains(string4) && (attr = attrSet.getAttribute(string4)) != null) {
                    stringArray = attr.getStringValues();
                    n = 0;
                    while (n < stringArray.length) {
                        stringBuffer.append(stringArray[n]);
                        ++n;
                    }
                }
                if (attrSet2.contains(string4) && (attr2 = attrSet2.getAttribute(string4)) != null) {
                    stringArray = attr2.getStringValues();
                    n = 0;
                    while (n < stringArray.length) {
                        stringBuffer2.append(stringArray[n]);
                        ++n;
                    }
                }
                boolean bl2 = bl = !(stringArray = stringBuffer.toString()).equalsIgnoreCase(string2 = stringBuffer2.toString());
                if (!bl) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    int n3;
                    Object object;
                    Object object2;
                    String[] stringArray2;
                    Object object3;
                    Object object4;
                    Object object5;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "|");
                    String string5 = stringTokenizer2.nextToken();
                    if (string5.equals(string)) {
                        object5 = new HashSet<String>(1);
                        object5.add(EMAIL_ATTRIBUTE);
                        object4 = DirectoryServicesFactory.getInstance().getAttributes(sSOToken, this.entryDN, (Set)object5, 1);
                        object3 = (Set)object4.get(EMAIL_ATTRIBUTE);
                        if (object3 == null || object3.isEmpty()) continue;
                        stringArray2 = object3.toArray(new String[object3.size()]);
                    } else if (string5.startsWith(string + ":")) {
                        object5 = string5.substring((string + ":").length());
                        if (object5 == null || ((String)object5).length() == 0) continue;
                        object4 = new HashSet(1);
                        object4.add(object5);
                        object3 = DirectoryServicesFactory.getInstance().getAttributes(sSOToken, this.entryDN, (Set)object4, 1);
                        object2 = (Set)object3.get(object5);
                        if (object2 == null || object2.isEmpty()) continue;
                        stringArray2 = object2.toArray(new String[object2.size()]);
                    } else {
                        stringArray2 = new String[]{string5};
                    }
                    object5 = null;
                    object4 = null;
                    if (stringTokenizer2.hasMoreTokens()) {
                        object5 = stringTokenizer2.nextToken();
                        if (stringTokenizer2.hasMoreTokens()) {
                            object4 = stringTokenizer2.nextToken();
                        }
                    }
                    object3 = attrSet2.getAttribute(string4);
                    object2 = attrSet.getAttribute(string4);
                    String string6 = AMSDKBundle.getString("492", (String)object5);
                    StringBuffer stringBuffer3 = new StringBuffer();
                    stringBuffer3.append(AMSDKBundle.getString("495", (String)object5)).append(" ").append(this.entryDN).append("\n").append(AMSDKBundle.getString("496", (String)object5)).append(" ").append(string4).append("\n").append(AMSDKBundle.getString("502", (String)object5)).append("\n");
                    if (object3 != null) {
                        object = ((Attr)object3).getStringValues();
                        n3 = 0;
                        while (n3 < ((String[])object).length) {
                            stringBuffer3.append("    ").append(object[n3]).append("\n");
                            ++n3;
                        }
                    }
                    stringBuffer3.append(AMSDKBundle.getString("503", (String)object5)).append("\n");
                    if (object2 != null) {
                        object = ((Attr)object2).getStringValues();
                        n3 = 0;
                        while (n3 < ((String[])object).length) {
                            stringBuffer3.append("    ").append(object[n3]).append("\n");
                            ++n3;
                        }
                    }
                    object = AMSDKBundle.getString("497", (String)object5);
                    this.mailer.postMail(stringArray2, string6, stringBuffer3.toString(), (String)object, (String)object4);
                }
            }
        }
        catch (MessagingException messagingException) {
            if (debug.warningEnabled()) {
                debug.warning("EmailNotificationHelper.sendUserModifyNotification() Unable to send email for user: " + this.entryDN, (Throwable)messagingException);
            }
        }
        catch (SSOException sSOException) {
            debug.error("EmailNotificationHelper.sendUserModifyNotification() Error occured while trying to send email for user: " + this.entryDN, (Throwable)sSOException);
        }
        catch (AMException aMException) {
            debug.error("EmailNotificationHelper.sendUserModifyNotification() Error occured while trying to send email for user: " + this.entryDN, (Throwable)aMException);
        }
    }

    protected Set getOrgTypeAttributes(AMOrganization aMOrganization, String string, String string2) throws SSOException {
        Set set = null;
        try {
            AMTemplate aMTemplate = aMOrganization.getTemplate(string, 302);
            set = aMTemplate.getAttribute(string2);
            if (debug.messageEnabled()) {
                debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org template " + string + " : " + string2 + "\n" + aMOrganization.getDN() + " : " + set);
            }
        }
        catch (AMException aMException) {
            try {
                Map map = AMServiceUtils.getServiceConfig(internalToken, ADMINISTRATION_SERVICE, SchemaType.ORGANIZATION);
                set = (Set)map.get(string2);
                if (debug.messageEnabled()) {
                    debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org defaults " + string + " : " + string2 + "\n" + aMOrganization.getDN() + " : " + set);
                }
            }
            catch (Exception exception) {
                debug.warning("AMOrganizationImpl.getOrgTypeAttributes(): Error encountered in retrieving default org attrs for", (Throwable)exception);
            }
        }
        return set;
    }
}

