/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.DCTreeServicesHelper;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.Organization;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.dctree.DomainComponent;
import com.iplanet.ums.dctree.DomainComponentTree;
import com.iplanet.ums.dctree.InvalidDCRootException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class DCTreeServicesImpl
extends DCTreeServicesHelper
implements AMConstants,
IDCTreeServices {
    private static Map domainMap = new HashMap();
    private static Map canonicalDomainMap = new HashMap();
    private static Debug debug = CommonUtils.debug;

    protected void createDomain(SSOToken sSOToken, Guid guid, AttrSet attrSet) throws AMException, SSOException {
        if (DCTreeServicesHelper.DCTREE_START_DN == null) {
            throw new AMException(AMSDKBundle.getString("355"), "355");
        }
        String string = attrSet.getValue("sunPreferredDomain");
        attrSet.remove("sunPreferredDomain");
        if (string != null && string != "") {
            try {
                AttrSet[] attrSetArray;
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
                domainComponentTree.addDomain(string);
                domainComponentTree.setDomainMapping(string, guid);
                String string2 = attrSet.getValue("inetdomainstatus");
                if (string2 != null) {
                    domainComponentTree.setDomainStatus(string, string2);
                }
                if ((attrSetArray = this.splitAttrSet(guid.getDn(), attrSet))[1] != null) {
                    this.setDomainAttributes(sSOToken, guid.getDn(), attrSetArray[1]);
                }
            }
            catch (InvalidDCRootException invalidDCRootException) {
                debug.error("DCTree.createDomain(): ", (Throwable)invalidDCRootException);
                throw new AMException(AMSDKBundle.getString("343"), "343");
            }
            catch (UMSException uMSException) {
                debug.error("DCTree.createDomain(): ", (Throwable)uMSException);
                throw new AMException(AMSDKBundle.getString("344"), "344");
            }
        }
    }

    protected void createDomain(SSOToken sSOToken, Guid guid, String string, AttrSet attrSet) throws AMException {
        if (DCTreeServicesHelper.DCTREE_START_DN == null) {
            throw new AMException(AMSDKBundle.getString("355"), "355");
        }
        if (string != null && string != "") {
            try {
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
                domainComponentTree.addDomain(string);
                domainComponentTree.setDomainMapping(string, guid);
                String string2 = attrSet.getValue("inetdomainstatus");
                if (string2 != null) {
                    domainComponentTree.setDomainStatus(string, string2);
                }
            }
            catch (InvalidDCRootException invalidDCRootException) {
                debug.error("DCTree.createDomain(): ", (Throwable)invalidDCRootException);
                throw new AMException(AMSDKBundle.getString("343"), "343");
            }
            catch (UMSException uMSException) {
                debug.error("DCTree.createDomain(): ", (Throwable)uMSException);
                throw new AMException(AMSDKBundle.getString("344"), "344");
            }
        }
    }

    protected void removeDomain(SSOToken sSOToken, String string) throws AMException {
        block9: {
            try {
                PersistentObject persistentObject = UMSObject.getObject(sSOToken, new Guid(string));
                if (!(persistentObject instanceof Organization)) {
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.removeDomain-> " + string + " is not an organization");
                    }
                    return;
                }
                String string2 = this.getCanonicalDomain(sSOToken, string);
                if (debug.messageEnabled()) {
                    debug.message("DCTree.removeDomain-> Obtained canon domain " + string2);
                }
                if (string2 != null && string2.length() > 0) {
                    DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.removeDomain: removing domain: " + string2);
                    }
                    domainComponentTree.removeDomain(string2);
                } else if (debug.warningEnabled()) {
                    debug.warning("DCTree.removeDomain():  unable to get domain for " + string);
                }
            }
            catch (UMSException uMSException) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("DCTree.removeDomain(): ", (Throwable)uMSException);
            }
        }
    }

    protected void updateDomainStatus(SSOToken sSOToken, String string, String string2) throws AMException {
        try {
            String string3 = this.getCanonicalDomain(sSOToken, string);
            if (string3 != null && string3.length() > 0) {
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
                domainComponentTree.setDomainStatus(string3, string2);
            } else {
                debug.warning("DCTree.updateDomainStatus(): value for sunPreferredDomain attribute null or empty");
            }
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.removeDomain(): ", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("356"), "356");
        }
    }

    protected void setDomainAttributes(SSOToken sSOToken, String string, AttrSet attrSet) throws AMException {
        String string2 = null;
        try {
            string2 = this.getCanonicalDomain(sSOToken, string);
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
            if (string2 == null) {
                if (debug.messageEnabled()) {
                    debug.message("DCTree.setDomainAttrs: No domain found for org : " + string);
                }
                return;
            }
            DomainComponent domainComponent = domainComponentTree.getDomainComponent(string2);
            if (attrSet != null) {
                Attr attr;
                if (debug.messageEnabled()) {
                    debug.message("DCTree.setDomainAttrs:  setting attributes on domain " + string2 + ": " + attrSet.toString());
                }
                if ((attr = attrSet.getAttribute("objectclass")) != null) {
                    Attr attr2 = domainComponent.getAttribute("objectclass");
                    if (attr2 != null) {
                        attr.addValues(attr2.getStringValues());
                    }
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.setDomainAttrs-> objectclasses to be set " + attr.toString());
                    }
                    if (attr.size() == 0) {
                        domainComponent.modify(attr, 1);
                    } else {
                        domainComponent.modify(attr, 2);
                    }
                    domainComponent.save();
                    attrSet.remove("objectclass");
                }
                int n = attrSet.size();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr3 = attrSet.elementAt(n2);
                    if (attr3.size() == 0) {
                        domainComponent.modify(attr3, 1);
                    } else {
                        domainComponent.modify(attr3, 2);
                    }
                    ++n2;
                }
                domainComponent.save();
            }
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.setDomainAttributes:  error setting  attribute for domain " + string2, (Throwable)uMSException);
        }
    }

    protected String getDCNodeDN(SSOToken sSOToken, String string) throws AMException {
        try {
            String string2 = this.getCanonicalDomain(sSOToken, string);
            if (string2 != null) {
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
                String string3 = domainComponentTree.mapDomainToDN(string2);
                return CommonUtils.formatToRFC(string3);
            }
            return null;
        }
        catch (InvalidDCRootException invalidDCRootException) {
            debug.error("DCTree.getDCNodeDN(): Invalid DC root ", (Throwable)invalidDCRootException);
            throw new AMException(AMSDKBundle.getString("343"), "343");
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.getDCNodeDN(): Unable to get dc node dn for: " + string, (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("344"), "344");
        }
    }

    protected AttrSet getDomainAttributes(SSOToken sSOToken, String string, String[] stringArray) throws AMException, SSOException {
        String string2 = null;
        try {
            string2 = this.getCanonicalDomain(sSOToken, string);
            if (string2 == null) {
                debug.error("DCTree.getDomainAttributes-> Domain not found for:  " + string);
                return null;
            }
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
            DomainComponent domainComponent = domainComponentTree.getDomainComponent(string2);
            AttrSet attrSet = stringArray != null ? domainComponent.getAttributes(stringArray) : domainComponent.getAttributes(domainComponent.getAttributeNames());
            AttrSet[] attrSetArray = this.splitAttrSet(null, attrSet);
            return attrSetArray[1];
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.getDomainAttributes:  error getting attributes for domain " + string2);
            return null;
        }
    }

    public String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        try {
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
            Hashtable hashtable = domainComponentTree.getChildDomainIDs();
            if (debug.messageEnabled()) {
                debug.message("DCTree:getOrgDN-> domain=" + string);
            }
            return (String)hashtable.get(string);
        }
        catch (UMSException uMSException) {
            debug.error("DCTree:getOrganizationDN: UMS Exception: ", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    protected AttrSet[] splitAttrSet(String string, AttrSet attrSet) throws AMException, SSOException {
        AttrSet[] attrSetArray = new AttrSet[]{attrSet != null ? (AttrSet)attrSet.clone() : new AttrSet(), new AttrSet()};
        if (attrSet == null) {
            return attrSetArray;
        }
        Set set = this.dcNodeAttributes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Attr attr;
            String string2 = (String)iterator.next();
            if (string2.indexOf("objectclass=") > -1) {
                attr = attrSet.getAttribute("objectclass");
                Attr attr2 = attr != null ? (Attr)attr.clone() : null;
                String string3 = string2.substring("objectclass=".length());
                Attr attr3 = new Attr("objectclass");
                if (attr2 == null || !attr2.contains(string3)) continue;
                attr2.removeValue(string3);
                attr3.addValue(string3);
                attrSetArray[0].replace(attr2);
                attrSetArray[1].add(attr3);
                continue;
            }
            attr = attrSet.getAttribute(string2);
            if (attr == null) continue;
            attrSetArray[1].add(attr);
            attrSetArray[0].remove(string2);
        }
        if (debug.messageEnabled()) {
            debug.message("DCTreeServicesImpl.splitAttrSet: domain attrset = " + attrSetArray[1].toString());
            debug.message("DCTreeServicesImpl.splitAttrSet: non-domain attrset = " + attrSetArray[0].toString());
        }
        return attrSetArray;
    }

    protected String getCanonicalDomain(SSOToken sSOToken, String string) throws AMException {
        String string2 = new DN(string).toRFCString().toLowerCase();
        return this.updateCacheAndReturnDomain(sSOToken, string2);
    }

    public void cleanDomainMap(String string) {
        Map map = canonicalDomainMap;
        synchronized (map) {
            canonicalDomainMap.remove(string);
        }
        Map map2 = domainMap;
        synchronized (map2) {
            domainMap.remove(string);
        }
    }

    private String updateCacheAndReturnDomain(SSOToken sSOToken, String string) throws AMException {
        try {
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(2);
            PersistentObject persistentObject = UMSObject.getObject(sSOToken, new Guid(DCTreeServicesHelper.DCTREE_START_DN));
            String string2 = "(inetDomainBaseDN=" + string + ")";
            if (debug.messageEnabled()) {
                debug.message("DCTree.updateCache-> searchFilter= " + string2);
            }
            SearchResults searchResults = persistentObject.search(string2, null);
            int n = 0;
            String string3 = null;
            String string4 = null;
            while (searchResults.hasMoreElements()) {
                Attr attr;
                DomainComponent domainComponent = (DomainComponent)searchResults.next();
                ++n;
                string3 = domainComponentTree.mapDCToDomainName(domainComponent);
                if (debug.messageEnabled()) {
                    debug.message("DCTree:updateCache-> domainName= " + string3);
                }
                if ((attr = domainComponent.getAttribute("inetcanonicaldomainname")) == null) continue;
                string4 = string3;
            }
            searchResults.abandon();
            if (n == 1) {
                string4 = string3;
            }
            if (debug.messageEnabled()) {
                debug.message("DCTree.updateCache-> returning domain= " + string4);
            }
            return string4;
        }
        catch (UMSException uMSException) {
            debug.error("DCTree:updateCache: UMSException", (Throwable)uMSException);
            return null;
        }
    }

    public Set dcNodeAttributes() throws AMException, SSOException {
        Map map;
        Set set;
        if (!this.isInitalized()) {
            this.initialize();
        }
        if ((set = (Set)(map = this.getAdminServiceGlobalSchema().getAttributeDefaults()).get("iplanet-am-admin-console-dctree-attr-list")) == null) {
            if (debug.messageEnabled()) {
                debug.message("DCTree.dcNodeAttributes = null");
            }
            return Collections.EMPTY_SET;
        }
        if (debug.messageEnabled()) {
            debug.message("DCTree.dcNodeAttributes = " + set.toString());
        }
        return set;
    }
}

