/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.ldap.ObjectClassManager;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class CommonUtils {
    private static final String LOCALE_PROPERTY = "Locale";
    private static final String AM_SDK_DEBUG_FILE_PROPS = "com.iplanet.am.sdk.ldap.debugFileName";
    private static final String AM_SDK_DEBUG_FILE = "amProfile_ldap";
    private static SSOToken internalToken = null;
    protected static Debug debug;
    protected static Map supportedTypes;
    protected static Map supportedNames;
    protected static Map creationtemplateMap;
    protected static Map statusAttributeMap;
    protected static Map searchtemplateMap;
    private static final String LOCALE_INTEGRATION_PROPERTY = "locale.integration";
    protected static boolean integrateLocale;

    CommonUtils() {
    }

    protected static SSOToken getInternalToken() {
        if (internalToken == null) {
            internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return internalToken;
    }

    protected static Debug getDebugInstance() {
        return debug;
    }

    protected static String getUserLocale(SSOToken sSOToken) {
        try {
            String string = sSOToken.getProperty(LOCALE_PROPERTY);
            if (debug.messageEnabled()) {
                debug.message("CommonUtils.getUserLocale(): locale = " + string);
            }
            return string;
        }
        catch (SSOException sSOException) {
            debug.error("CommonUtils.getUserLocale(): missing locale, setting to null");
            return null;
        }
    }

    protected static AttrSet combineAttrSets(AttrSet attrSet, AttrSet attrSet2) {
        Attr attr;
        int n;
        int n2;
        AttrSet attrSet3 = new AttrSet();
        if (attrSet != null) {
            n2 = attrSet.size();
            n = 0;
            while (n < n2) {
                attr = attrSet.elementAt(n);
                attrSet3.add(attr);
                ++n;
            }
        }
        if (attrSet2 != null) {
            n2 = attrSet2.size();
            n = 0;
            while (n < n2) {
                attr = attrSet2.elementAt(n);
                attrSet3.add(attr);
                ++n;
            }
        }
        return attrSet3;
    }

    protected static Map mergeMaps(Map map, Map map2) {
        if (map == null && map2 == null) {
            return null;
        }
        if (map == null || map.isEmpty()) {
            return map2;
        }
        if (map2 == null || map2.isEmpty()) {
            return map;
        }
        Map map3 = map.size() > map2.size() ? map : map2;
        Map map4 = map.size() <= map2.size() ? map : map2;
        Iterator iterator = map4.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map3.get(string);
            if (set != null) {
                set.addAll((Set)map4.get(string));
                continue;
            }
            map3.put(string, (Set)map4.get(string));
        }
        return map3;
    }

    protected static String mapSetToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map.get(string);
                stringBuffer.append("\n\tName: ").append(string);
                stringBuffer.append(" Values: ").append(set.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        return stringBuffer.toString();
    }

    protected static String mapByteToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])map.get(string);
                stringBuffer.append("\n\tName: ").append(string);
                stringBuffer.append(" Values: ").append(byArray);
            }
        } else {
            stringBuffer.append("<empty>");
        }
        return stringBuffer.toString();
    }

    protected static Set getSetCopy(Set set) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (!set.isEmpty()) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    protected static Set stringArrayToSet(String[] stringArray) {
        int n = stringArray.length;
        HashSet<String> hashSet = n > 0 ? new HashSet<String>(n) : new HashSet();
        int n2 = 0;
        while (n2 < n) {
            hashSet.add(stringArray[n2]);
            ++n2;
        }
        return hashSet;
    }

    protected static Map attrSetToMap(AttrSet attrSet) {
        return CommonUtils.attrSetToMap(attrSet, false);
    }

    protected static Map attrSetToMap(AttrSet attrSet, boolean bl) {
        AMHashMap aMHashMap = new AMHashMap(bl);
        if (attrSet == null) {
            return aMHashMap;
        }
        int n = attrSet.size();
        if (!bl) {
            int n2 = 0;
            while (n2 < n) {
                Attr attr = attrSet.elementAt(n2);
                String[] stringArray = attr.getStringValues();
                aMHashMap.put(attr.getName(), CommonUtils.stringArrayToSet(stringArray));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                Attr attr = attrSet.elementAt(n3);
                aMHashMap.put(attr.getName(), attr.getByteValues());
                ++n3;
            }
        }
        return aMHashMap;
    }

    protected static AttrSet mapToAttrSet(Map map) {
        return CommonUtils.mapToAttrSet(map, false);
    }

    protected static AttrSet mapToAttrSet(Map map, boolean bl) {
        AttrSet attrSet = new AttrSet();
        if (map == null) {
            return attrSet;
        }
        if (!bl) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map.get(string);
                String[] stringArray = set == null ? null : set.toArray(new String[set.size()]);
                attrSet.replace(new Attr(string, stringArray));
            }
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])map.get(string);
                attrSet.replace(new Attr(string, byArray));
            }
        }
        return attrSet;
    }

    protected static Guid[] toGuidArray(Set set) {
        Object[] objectArray = set.toArray();
        Guid[] guidArray = new Guid[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            guidArray[n] = new Guid((String)objectArray[n]);
            ++n;
        }
        return guidArray;
    }

    protected static Guid[] getGuidArray(Set set) {
        return set.toArray(new Guid[set.size()]);
    }

    protected static String formatToRFC(String string) {
        return new DN(string).toRFCString().toLowerCase();
    }

    protected static String getPrincipalDN(SSOToken sSOToken) throws SSOException {
        String string = sSOToken.getPrincipal().getName();
        return CommonUtils.formatToRFC(string);
    }

    protected static Set combineOCs(Set set, Set set2) {
        Object object;
        if (set == null || set.isEmpty()) {
            return set2;
        }
        if (set2 == null || set2.isEmpty()) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            hashSet.add(((String)object).toLowerCase());
        }
        object = set2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashSet.add(string.toLowerCase());
        }
        return hashSet;
    }

    protected static boolean isObjectClassPresent(Set set, String string) {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set updateAndGetRemovableOCs(Set set, Set hashSet) {
        HashSet<String> hashSet2 = hashSet;
        if (hashSet != null && !hashSet.isEmpty()) {
            hashSet2 = new HashSet<String>();
            Iterator iterator = set.iterator();
            block0: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    hashSet2.add(string);
                    continue block0;
                }
            }
            set.removeAll(hashSet2);
        }
        return hashSet2;
    }

    protected static Map removeEmptyValues(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set.isEmpty()) continue;
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    protected static boolean populateManagedObjects() {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager("DAI", CommonUtils.getInternalToken());
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            Set set = serviceConfig.getSubConfigNames("*", "ManagedObjects");
            if (set == null || set.isEmpty()) {
                debug.message("CommonUtils.populateManagedObject managedObjects=null");
                return false;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string = string.toLowerCase());
                if (serviceConfig2 == null) continue;
                Map map = serviceConfig2.getAttributes();
                Set set2 = (Set)map.get("objectclass");
                Set set3 = (Set)map.get("creationtemplatename");
                Set set4 = (Set)map.get("searchtemplatename");
                Set set5 = (Set)map.get("type");
                Set set6 = (Set)map.get("statusattribute");
                String string2 = CommonUtils.getObjectClass(set2, string);
                String string3 = CommonUtils.getCreationTemplateName(set3, string);
                String string4 = CommonUtils.getSearchTemplateName(set4, string);
                String string5 = CommonUtils.getStatusAttributeName(set6);
                String string6 = (String)set5.iterator().next();
                supportedTypes.put(string, string6);
                supportedNames.put(string6, string);
                if (string2 != null) {
                    ObjectClassManager.objectClassMap.put(string6, string2);
                    ObjectClassManager.objectTypeMap.put(string2, string6);
                }
                if (string4 != null) {
                    searchtemplateMap.put(string6, string4);
                }
                if (string3 != null) {
                    creationtemplateMap.put(string6, string3);
                }
                if (string5 == null) continue;
                statusAttributeMap.put(string6, string5);
            }
            if (debug.messageEnabled()) {
                debug.message("CreationTemplate MAP = " + creationtemplateMap.toString());
                debug.message("SearchTemplate Map = " + searchtemplateMap.toString());
                debug.message("ObjectClass-Type Map = " + ObjectClassManager.objectClassMap.toString());
                debug.message("Type-ObjectClass MAP = " + ObjectClassManager.objectTypeMap.toString());
                debug.message("Supported names-type = " + supportedTypes.toString());
                debug.message("Status Attributes= " + statusAttributeMap.toString());
            }
        }
        catch (SMSException sMSException) {
            return false;
        }
        catch (SSOException sSOException) {
            return false;
        }
        return true;
    }

    protected static void populateManagedObjectsWithDefaults() {
    }

    private static String getObjectClass(Set set, String string) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return ((String)set.iterator().next()).toLowerCase();
    }

    private static String getCreationTemplateName(Set set, String string) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return (String)set.iterator().next();
    }

    private static String getSearchTemplateName(Set set, String string) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return (String)set.iterator().next();
    }

    private static String getStatusAttributeName(Set set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return (String)set.iterator().next();
    }

    static {
        supportedTypes = new HashMap();
        supportedNames = new HashMap();
        creationtemplateMap = new HashMap();
        statusAttributeMap = new HashMap();
        searchtemplateMap = new HashMap();
        integrateLocale = true;
        debug = Debug.getInstance((String)SystemProperties.get((String)AM_SDK_DEBUG_FILE_PROPS, (String)AM_SDK_DEBUG_FILE));
        String string = SystemProperties.get((String)LOCALE_INTEGRATION_PROPERTY);
        if (string == null || string.equalsIgnoreCase("true")) {
            integrateLocale = true;
            if (debug.messageEnabled()) {
                debug.message("AM SDK: Locale integration enabled");
            }
        } else {
            integrateLocale = false;
        }
        CommonUtils.populateManagedObjects();
    }
}

