/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Stats;
import com.iplanet.am.util.StatsListener;

public class CacheStats
implements StatsListener {
    String name;
    int intervalCount = 0;
    int cacheSize = 0;
    long totalGetRequests = 0L;
    long totalCacheHits = 0L;
    long totalIntervalHits = 0L;
    Debug debug;
    private static Stats stats = null;
    private static final String CACHE_STATS_FILE_NAME = "amSDKStats";

    public static CacheStats createInstance(String string, Debug debug) {
        CacheStats cacheStats = new CacheStats(string, debug);
        if (stats.isEnabled()) {
            stats.addStatsListener((StatsListener)cacheStats);
        }
        return cacheStats;
    }

    public CacheStats(String string, Debug debug) {
        this.name = string;
        this.debug = debug;
        if (this.debug.messageEnabled()) {
            this.debug.message("CacheStats() Stats : " + stats.isEnabled());
        }
    }

    public String getName() {
        return this.name;
    }

    public void updateHitCount(int n) {
        if (stats.isEnabled()) {
            CacheStats cacheStats = this;
            synchronized (cacheStats) {
                ++this.totalCacheHits;
                ++this.totalIntervalHits;
                this.cacheSize = n;
            }
        }
    }

    public void incrementRequestCount(int n) {
        if (stats.isEnabled()) {
            CacheStats cacheStats = this;
            synchronized (cacheStats) {
                ++this.totalGetRequests;
                ++this.intervalCount;
                this.cacheSize = n;
            }
        }
    }

    protected synchronized int getIntervalCount() {
        return this.intervalCount;
    }

    public synchronized void printStats() {
        stats.record("SDK Cache Statistics\n--------------------\nNumber of requests during this interval: " + this.intervalCount + "\nNumber of Cache Hits during this interval: " + this.totalIntervalHits + "\nHit ratio for this interval: " + (double)this.totalIntervalHits / (double)this.intervalCount + "\nTotal number of requests since server start: " + this.totalGetRequests + "\nTotal number of Cache Hits since server start: " + this.totalCacheHits + "\nOverall Hit ratio: " + (double)this.totalCacheHits / (double)this.totalGetRequests + "\nTotal Cache Size: " + this.cacheSize + "\n");
        this.intervalCount = 0;
        this.totalIntervalHits = 0L;
    }

    static {
        stats = Stats.getInstance((String)CACHE_STATS_FILE_NAME);
    }
}

