/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.common;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.util.Debug;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class CacheBlockBase {
    private AMHashMap cacheEntries;
    private String entryDN;
    private int objectType = -9999;
    private AMHashMap stringAttributes;
    private AMHashMap byteAttributes;
    private long lastModifiedTime = 0L;
    private boolean isExpired = false;
    private String organizationDN = null;
    private boolean isValidEntry = true;

    public abstract Debug getDebug();

    public abstract boolean isEntryExpirationEnabled();

    public abstract long getUserEntryExpirationTime();

    public abstract long getDefaultEntryExpirationTime();

    public CacheBlockBase(String string, boolean bl) {
        if (bl) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        } else {
            this.isValidEntry = false;
        }
        this.setLastModifiedTime();
        this.entryDN = string;
    }

    public CacheBlockBase(String string, String string2, boolean bl) {
        this(string, bl);
        this.organizationDN = string2;
    }

    public synchronized void setExists(boolean bl) {
        if (bl) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        }
        this.isValidEntry = bl;
        this.updateLastModifiedTime();
    }

    private synchronized void setLastModifiedTime() {
        if (this.isEntryExpirationEnabled()) {
            this.lastModifiedTime = System.currentTimeMillis();
        }
    }

    private synchronized void updateLastModifiedTime() {
        if (this.isEntryExpirationEnabled() && this.isExpired) {
            this.lastModifiedTime = System.currentTimeMillis();
            this.isExpired = false;
        }
    }

    public synchronized void setObjectType(int n) {
        this.objectType = n;
        this.updateLastModifiedTime();
    }

    public synchronized void setOrganizationDN(String string) {
        this.organizationDN = string;
        this.updateLastModifiedTime();
    }

    public String getOrganizationDN() {
        this.hasExpiredAndUpdated();
        return this.organizationDN;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public synchronized boolean isExists() {
        return this.isValidEntry;
    }

    public synchronized boolean hasExpiredAndUpdated() {
        if (this.isEntryExpirationEnabled() && !this.isExpired) {
            long l = 0L;
            switch (this.objectType) {
                case 1: {
                    l = this.getUserEntryExpirationTime();
                    break;
                }
                default: {
                    l = this.getDefaultEntryExpirationTime();
                }
            }
            long l2 = System.currentTimeMillis() - this.lastModifiedTime;
            if (l2 >= l) {
                this.isExpired = true;
                int n = this.objectType;
                this.clear();
                if (this.getDebug().messageEnabled()) {
                    this.getDebug().message("CacheBlock.hasExpiredAndUpdated(): Entry with DN " + this.entryDN + " expired.");
                }
            }
        }
        return this.isExpired;
    }

    public synchronized boolean hasCompleteSet(String string) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        boolean bl = false;
        if (cacheEntry != null && !this.hasExpiredAndUpdated()) {
            bl = cacheEntry.isCompleteSet();
        }
        return bl;
    }

    public synchronized Map getAttributes(String string, boolean bl) {
        return this.getAttributes(string, null, bl);
    }

    public synchronized Map getAttributes(String string, Set set, boolean bl) {
        Map map = new AMHashMap(bl);
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        if (cacheEntry != null && !this.hasExpiredAndUpdated()) {
            Iterator iterator;
            Set set2 = null;
            set2 = set == null ? cacheEntry.getReadableAttrNames() : cacheEntry.getReadableAttrNames(set);
            if (!bl) {
                map = this.stringAttributes.getCopy(set2);
                if (cacheEntry.isCompleteSet() && !map.keySet().containsAll(set2) && !this.byteAttributes.isEmpty()) {
                    iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (map.containsKey(e) || !this.byteAttributes.containsKey(e)) continue;
                        byte[][] byArray = (byte[][])this.byteAttributes.get(e);
                        HashSet<String> hashSet = new HashSet<String>(byArray.length * 2);
                        int n = 0;
                        while (n < byArray.length) {
                            try {
                                hashSet.add(new String(byArray[n], "UTF8"));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                hashSet.add(new String(byArray[n]));
                            }
                            ++n;
                        }
                        map.put(e, hashSet);
                    }
                }
            } else {
                map = this.byteAttributes.getCopy(set2);
                if (cacheEntry.isCompleteSet() && !map.keySet().containsAll(set2) && !this.stringAttributes.isEmpty()) {
                    iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (map.containsKey(e) || !this.stringAttributes.containsKey(e)) continue;
                        Set set3 = (Set)this.stringAttributes.get(e);
                        byte[][] byArrayArray = new byte[set3.size()][];
                        int n = 0;
                        Iterator iterator2 = set3.iterator();
                        while (iterator2.hasNext()) {
                            String string2 = (String)iterator2.next();
                            byArrayArray[n] = new byte[string2.length()];
                            byte[] byArray = null;
                            try {
                                byArray = string2.getBytes("UTF8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                byArray = string2.getBytes();
                            }
                            System.arraycopy(byArray, 0, byArrayArray[n], 0, string2.length());
                            ++n;
                        }
                        map.put(e, byArrayArray);
                    }
                }
            }
            iterator = cacheEntry.getInaccessibleAttrNames(set);
            ((AMHashMap)map).addEmptyValues((Set)((Object)iterator));
        }
        return map;
    }

    public synchronized void putAttributes(String string, Map map, Set set, boolean bl, boolean bl2) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cacheEntries.put(string, cacheEntry);
        }
        if (!bl2) {
            Set set2 = this.stringAttributes.copyValuesOnly(map);
            cacheEntry.putAttributes(set2, set, bl);
        } else {
            Set set3 = this.byteAttributes.copyValuesOnly(map);
            cacheEntry.putAttributes(set3, set, bl);
        }
        this.updateLastModifiedTime();
    }

    public synchronized void removeAttributes(String string) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.remove(string);
        if (cacheEntry != null) {
            cacheEntry.clear();
        }
    }

    public synchronized void removeAttributes(Set set) {
        if (set != null && !set.isEmpty()) {
            this.stringAttributes.removeKeys(set);
            this.byteAttributes.removeKeys(set);
            Iterator iterator = this.cacheEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.removeAttributes(string, set);
            }
        }
    }

    private synchronized void removeAttributes(String string, Set set) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        if (cacheEntry != null) {
            cacheEntry.removeAttributeNames(set);
        }
    }

    public synchronized void replaceAttributes(String string, Map map, Map map2) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        Set set = Collections.EMPTY_SET;
        if (map != null && !map.isEmpty()) {
            set = map.keySet();
        } else if (map2 != null && !map2.isEmpty()) {
            set = map2.keySet();
        }
        if (cacheEntry != null && set != null && !set.isEmpty()) {
            cacheEntry.removeAttributeNames(set);
        }
        this.stringAttributes.copy(map);
        this.byteAttributes.copy(map2);
    }

    public synchronized void clear() {
        if (this.isValidEntry) {
            this.stringAttributes.clear();
            this.byteAttributes.clear();
            this.cacheEntries.clear();
        }
        this.lastModifiedTime = 0L;
        this.organizationDN = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n----------- START CACHE BLOCK -----------");
        stringBuffer.append("\nEntry DN: ").append(this.entryDN);
        stringBuffer.append(" Valid Entry: ").append(this.isValidEntry);
        stringBuffer.append("\nOrganization: ").append(this.organizationDN);
        stringBuffer.append("\nString Attributes: ");
        stringBuffer.append(MiscUtils.mapSetToString(this.stringAttributes));
        stringBuffer.append("\nByte Attributes: ");
        stringBuffer.append(MiscUtils.mapSetToString(this.byteAttributes));
        stringBuffer.append("\nByte Negative Attributes: ");
        stringBuffer.append(this.byteAttributes.getNegativeByteAttrClone().toString());
        stringBuffer.append("\nCache Entries: ");
        if (this.cacheEntries != null && !this.cacheEntries.isEmpty()) {
            Iterator iterator = this.cacheEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
                stringBuffer.append("\nPrincipal: ").append(string);
                stringBuffer.append(cacheEntry.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        stringBuffer.append("\n----------- END CACHE BLOCK -----------");
        return stringBuffer.toString();
    }

    class CacheEntry {
        private boolean completeSet = false;
        private Set readableAttrNames = new HashSet();
        private Set inAccessibleAttrNames = new HashSet();

        CacheEntry() {
        }

        protected Set getReadableAttrNames() {
            return this.readableAttrNames;
        }

        protected Set getReadableAttrNames(Set set) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                if (!this.readableAttrNames.contains(string)) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        protected Set getInaccessibleAttrNames(Set set) {
            if (set == null || set.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                if (!this.inAccessibleAttrNames.contains(string)) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        protected void putAttributes(Set set, Set set2, boolean bl) {
            String string;
            Iterator iterator;
            this.completeSet = bl;
            if (set != null && !set.isEmpty()) {
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = ((String)iterator.next()).toLowerCase();
                    this.readableAttrNames.add(string);
                }
            }
            if (set2 != null && !set2.isEmpty()) {
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    string = ((String)iterator.next()).toLowerCase();
                    this.inAccessibleAttrNames.add(string);
                }
            }
        }

        protected void removeAttributeNames(Set set) {
            this.completeSet = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                boolean bl = this.readableAttrNames.remove(string);
                if (bl) continue;
                this.inAccessibleAttrNames.remove(string);
            }
        }

        protected boolean isCompleteSet() {
            return this.completeSet;
        }

        protected void clear() {
            this.completeSet = false;
            this.readableAttrNames.clear();
            this.inAccessibleAttrNames.clear();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Complete Set: ").append(this.completeSet);
            stringBuffer.append(" Attributes: ").append(this.readableAttrNames);
            stringBuffer.append(" In Accessable attributes: ");
            stringBuffer.append(this.inAccessibleAttrNames);
            return stringBuffer.toString();
        }
    }
}

