/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import java.util.HashMap;
import java.util.Map;
import netscape.ldap.util.DN;

public class AMSearchFilterManager {
    private static Debug debug = AMCommonUtils.debug;
    public static Map searchtemplateMap = new HashMap();
    private static Cache searchfilterMap = new Cache(1000);

    private static String modifyFilter(String string, int n) {
        switch (n) {
            case 6: 
            case 8: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(&").append(string);
                stringBuffer.append("(objectClass=ldapsubentry)").append("(!(cn=");
                stringBuffer.append("ContainerDefaultTemplateRole");
                stringBuffer.append(")))");
                return stringBuffer.toString();
            }
        }
        return string;
    }

    public static String getSearchFilter(int n, String string, String string2, boolean bl) {
        String string3;
        String string4;
        String string5 = new DN(string).toRFCString();
        String string6 = AMStoreConnection.rootSuffix;
        if (string != null && string5.equals(string6)) {
            string = null;
        }
        if ((string4 = (String)searchfilterMap.get((Object)(string3 = new Integer(n).toString() + ":" + string2 + ":" + string5))) == null) {
            IDirectoryServices iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
            string4 = iDirectoryServices.getSearchFilterFromTemplate(n, string, string2);
            searchfilterMap.put((Object)string3, (Object)string4);
        }
        string4 = AMSearchFilterManager.modifyFilter(string4, n);
        string4 = AMSearchFilterManager.addAdminGroupFilters(string4, string, n);
        string4 = AMSearchFilterManager.addComplianceModeFilters(string4, n, bl);
        return string4;
    }

    private static String addAdminGroupFilters(String string, String string2, int n) {
        block7: {
            try {
                if (!AMCompliance.isAdminGroupsEnabled(string2)) {
                    String string3 = string;
                    switch (n) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("(&").append(string).append("(!(");
                            stringBuffer.append(AMNamingAttrManager.getNamingAttr(12));
                            stringBuffer.append("=serviceadministrators))").append("(!(");
                            stringBuffer.append(AMNamingAttrManager.getNamingAttr(12));
                            stringBuffer.append("=servicehelpdeskadministrators)))");
                            string3 = stringBuffer.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMSearchFilterManager.addAdminGroupFilters() - objectType = " + n + ", orgDN = " + string2 + ", Original filter: " + string + ", Modified filter = " + string3);
                    }
                    return string3;
                }
            }
            catch (AMException aMException) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("AMSearchFilterManager.addAdminGroupFilters() Unable to determine if \"Admin Groups\" option is enabled or disabled. Exception : ", (Throwable)aMException);
            }
        }
        return string;
    }

    private static String addComplianceModeFilters(String string, int n, boolean bl) {
        block9: {
            try {
                String string2 = string;
                if (!bl && AMCompliance.isComplianceUserDeletionEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    switch (n) {
                        case 1: {
                            stringBuffer.append("(&").append(string);
                            stringBuffer.append("(!(inetuserstatus=deleted)))");
                            string2 = stringBuffer.toString();
                            break;
                        }
                        case 2: {
                            stringBuffer.append("(&").append(string);
                            stringBuffer.append("(!(inetdomainstatus=deleted)))");
                            string2 = stringBuffer.toString();
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            stringBuffer.append("(&").append(string);
                            stringBuffer.append("(!(inetgroupstatus=deleted)))");
                            string2 = stringBuffer.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMSearchFilterManager.addComplainceModeFilters() - objectType = " + n + ", Original Filter = " + string + ", Modified Filter = " + string2);
                    }
                    return string2;
                }
            }
            catch (AMException aMException) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("AMSearchFilterManager.addComplianceModeFilters() Unable to determine if \"User Compliance deletion mode\" is enabled or disabled. Exception : ", (Throwable)aMException);
            }
        }
        return string;
    }

    public static String getSearchFilter(int n, String string) {
        return AMSearchFilterManager.getSearchFilter(n, string, null, true);
    }

    public static String getGlobalSearchFilter(int n) {
        return AMSearchFilterManager.getGlobalSearchFilter(n, null);
    }

    public static String getGlobalSearchFilter(int n, String string) {
        return AMSearchFilterManager.getSearchFilter(n, null, string, true);
    }
}

