/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMSDKRepo
extends IdRepo {
    protected static Set listeners = new HashSet();
    private Map supportedOps = new HashMap();
    private IdRepoListener myListener = null;
    private String orgDN = "";
    private Debug debug;
    private static final String PC_ATTR = "iplanet-am-admin-console-default-pc";
    private static final String AC_ATTR = "iplanet-am-admin-console-default-ac";
    private static final String GC_ATTR = "iplanet-am-admin-console-default-gc";
    private static final String ADMIN_SERVICE = "iPlanetAMAdminConsoleService";
    private static final String CLASS_NAME = "com.iplanet.am.sdk.AMSDKRepo";
    private static SSOToken adminToken = null;
    private static AMStoreConnection sc = null;

    public AMSDKRepo() {
        this.loadSupportedOps();
        this.debug = Debug.getInstance((String)"amsdkRepo");
    }

    public int addListener(SSOToken sSOToken, IdRepoListener idRepoListener) throws IdRepoException, SSOException {
        listeners.add(idRepoListener);
        this.myListener = idRepoListener;
        return 0;
    }

    public void removeListener() {
        listeners.remove(this.myListener);
    }

    public String create(SSOToken sSOToken, IdType idType, String string, Map map) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKIdRepo: Create called on " + idType + ": " + string);
        }
        String string2 = null;
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        try {
            int n = aMStoreConnection.getAMObjectType(this.orgDN);
            if (n != 2) {
                this.debug.error("AMSDKRepo.create(): Incorrectly configured  plugin: Org DN is wrong = " + this.orgDN);
                throw new IdRepoException("amIdRepo", "303", null);
            }
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.create(): An exception occured while  initializing AM SDK ", (Throwable)aMException);
            Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.CREATE.getName()};
            throw new IdRepoException("amIdRepo", "304", objectArray);
        }
        AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.orgDN);
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        hashMap.put(string, map);
        try {
            if (idType.equals(IdType.USER)) {
                Set set = aMOrganization.createEntities(1, hashMap);
                AMEntity aMEntity = (AMEntity)set.iterator().next();
                string2 = aMEntity.getDN();
            } else if (idType.equals(IdType.AGENT)) {
                Set set = aMOrganization.createEntities(100, hashMap);
                AMEntity aMEntity = (AMEntity)set.iterator().next();
                string2 = aMEntity.getDN();
            } else if (idType.equals(IdType.GROUP)) {
                String string3 = AMNamingAttrManager.getNamingAttr(4) + "=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
                AMGroupContainer aMGroupContainer = aMStoreConnection.getGroupContainer(string3);
                Set set = aMGroupContainer.createStaticGroups(hashMap);
                AMStaticGroup aMStaticGroup = (AMStaticGroup)set.iterator().next();
                string2 = aMStaticGroup.getDN();
            } else if (idType.equals(IdType.ROLE)) {
                Set set = aMOrganization.createRoles(hashMap);
                AMRole aMRole = (AMRole)set.iterator().next();
                string2 = aMRole.getDN();
            } else if (idType.equals(IdType.FILTEREDROLE)) {
                Set set = aMOrganization.createFilteredRoles(hashMap);
                AMFilteredRole aMFilteredRole = (AMFilteredRole)set.iterator().next();
                string2 = aMFilteredRole.getDN();
            }
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.create(): Caught AMException..", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
        return string2;
    }

    public void delete(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKIdRepo: Delete called on " + idType + ": " + string);
        }
        AMOrganization aMOrganization = this.checkAndGetOrg(sSOToken);
        HashSet<String> hashSet = new HashSet<String>();
        try {
            String string2 = this.getDN(idType, string);
            hashSet.add(string2);
            if (idType.equals(IdType.USER)) {
                aMOrganization.deleteUsers(hashSet);
            } else if (idType.equals(IdType.AGENT)) {
                aMOrganization.deleteEntities(100, hashSet);
            } else if (idType.equals(IdType.GROUP)) {
                aMOrganization.deleteStaticGroups(hashSet);
            } else if (idType.equals(IdType.ROLE)) {
                aMOrganization.deleteRoles(hashSet);
            } else if (idType.equals(IdType.FILTEREDROLE)) {
                aMOrganization.deleteFilteredRoles(hashSet);
            }
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.delete(): Caught AMException...", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set) throws IdRepoException, SSOException {
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        String string2 = this.getDN(idType, string);
        int n = this.getProfileType(idType);
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKIdRepo: getAttributes called: " + idType + ": " + string + " DN: '" + string2 + "'");
        }
        if (adminToken != null) {
            sSOToken = adminToken;
        }
        try {
            if (aMStoreConnection.isValidEntry(string2)) {
                IDirectoryServices iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
                return iDirectoryServices.getAttributes(sSOToken, string2, set, false, false, n);
            }
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "202", objectArray);
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.getAttributes(): AMException ", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        String string2 = this.getDN(idType, string);
        int n = this.getProfileType(idType);
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKIdRepo: getAttributes called: " + idType + ": " + string + " DN: '" + string2 + "'");
        }
        if (adminToken != null) {
            sSOToken = adminToken;
        }
        try {
            if (aMStoreConnection.isValidEntry(string2)) {
                IDirectoryServices iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
                return iDirectoryServices.getAttributes(sSOToken, string2, false, false, n);
            }
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "202", objectArray);
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.getAttributes(): AMException ", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
    }

    public Map getBinaryAttributes(SSOToken sSOToken, IdType idType, String string, Set set) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKIdRepo: getBinaryAttributes called: " + idType + ": " + string);
        }
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        String string2 = this.getDN(idType, string);
        int n = this.getProfileType(idType);
        if (adminToken != null) {
            sSOToken = adminToken;
        }
        try {
            if (aMStoreConnection.isValidEntry(string2)) {
                IDirectoryServices iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
                return iDirectoryServices.getAttributesByteValues(sSOToken, string2, set, n);
            }
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "202", objectArray);
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.getBinaryAttributes(): AMException ", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
    }

    public Map getConfiguration() {
        return super.getConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set getMembers(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: getMembers called" + idType + ": " + string + ": " + idType2);
        }
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        String string2 = null;
        if (idType.equals(IdType.USER) || idType.equals(IdType.AGENT)) {
            this.debug.error("AMSDKRepo: Membership operation is not supported  for Users or Agents");
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (idType.equals(IdType.GROUP)) {
            string2 = this.getDN(idType, string);
            AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(string2);
            if (idType2.equals(IdType.USER)) {
                try {
                    return aMStaticGroup.getUserDNs();
                }
                catch (AMException aMException) {
                    this.debug.error("AMSDKRepo: Unable to get user memberships for group" + string2, (Throwable)aMException);
                    Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName(), string};
                    throw new IdRepoException("amIdRepo", "205", objectArray);
                }
            }
            this.debug.error("AMSDKRepo: Groups do not supported membership for " + idType2.getName());
            Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        if (idType.equals(IdType.ROLE)) {
            string2 = this.getDN(idType, string);
            AMRole aMRole = aMStoreConnection.getRole(string2);
            if (idType2.equals(IdType.USER)) {
                try {
                    return aMRole.getUserDNs();
                }
                catch (AMException aMException) {
                    this.debug.error("AMSDKRepo: Unable to get user memberships for role " + string2, (Throwable)aMException);
                    throw IdUtils.convertAMException(aMException);
                }
            }
            Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        if (idType.equals(IdType.FILTEREDROLE)) {
            string2 = this.getDN(idType, string);
            AMFilteredRole aMFilteredRole = aMStoreConnection.getFilteredRole(string2);
            if (idType2.equals(IdType.USER)) {
                try {
                    return aMFilteredRole.getUserDNs();
                }
                catch (AMException aMException) {
                    this.debug.error("AMSDKRepo: Unable to get user memberships for role " + string2, (Throwable)aMException);
                    throw IdUtils.convertAMException(aMException);
                }
            }
            Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.READ.getName(), idType.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray);
    }

    public Set getMemberships(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        Set set;
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: getMemberships called" + idType + ": " + string + ": " + idType2);
        }
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        String string2 = null;
        if (!idType.equals(IdType.USER)) {
            this.debug.error("AMSDKRepo: Membership for identities other than  Users is not allowed ");
            Object[] objectArray = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", objectArray);
        }
        string2 = this.getDN(idType, string);
        AMUser aMUser = aMStoreConnection.getUser(string2);
        if (idType2.equals(IdType.GROUP)) {
            try {
                set = aMUser.getStaticGroupDNs();
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo: Unable to get user's group memberships " + string2, (Throwable)aMException);
                Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName(), string};
                throw new IdRepoException("amIdRepo", "207", objectArray);
            }
        } else if (idType2.equals(IdType.ROLE)) {
            try {
                set = aMUser.getRoleDNs();
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo: Unable to get roles of a user " + string2, (Throwable)aMException);
                throw IdUtils.convertAMException(aMException);
            }
        } else if (idType2.equals(IdType.FILTEREDROLE)) {
            try {
                set = aMUser.getFilteredRoleDNs();
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo: Unable to get user memberships for role " + string2, (Throwable)aMException);
                throw IdUtils.convertAMException(aMException);
            }
        } else {
            this.debug.error("AMSDKRepo: Membership for other types of entities  not supported for Users");
            Object[] objectArray = new Object[]{CLASS_NAME, idType.getName(), idType2.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        return set;
    }

    public Set getSupportedOperations(IdType idType) {
        return (Set)this.supportedOps.get(idType);
    }

    public Set getSupportedTypes() {
        return this.supportedOps.keySet();
    }

    public void initialize(Map map) {
        Set set;
        super.initialize(map);
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: Initializing configuration: " + this.configMap.toString());
        }
        this.orgDN = (set = (Set)this.configMap.get("amSDKOrgName")) != null && !set.isEmpty() ? (String)set.iterator().next() : AMStoreConnection.rootSuffix;
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                sc = new AMStoreConnection(adminToken);
            }
            catch (SSOException sSOException) {
                this.debug.error("AMSDKRepo:Initialize..Failed to initialize  AMStoreConnection...", (Throwable)sSOException);
            }
        }
    }

    public boolean isExists(SSOToken sSOToken, IdType idType, String string) {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: isExists called " + idType + ": " + string);
        }
        return true;
    }

    public boolean isActive(SSOToken sSOToken, IdType idType, String string) throws SSOException {
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        try {
            String string2 = this.getDN(idType, string);
            AMEntity aMEntity = aMStoreConnection.getEntity(string2);
            return aMEntity.isActivated();
        }
        catch (AMException aMException) {
            return false;
        }
        catch (IdRepoException idRepoException) {
            return false;
        }
    }

    public void modifyMemberShip(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n) throws IdRepoException, SSOException {
        Object[] objectArray;
        Object object;
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: modifyMemberShip called " + idType + ": " + string + ": " + set + ": " + idType2);
        }
        if (set == null || set.isEmpty()) {
            this.debug.error("AMSDKRepo.modifyMemberShip: Members set is empty");
            throw new IdRepoException("amIdRepo", "201", null);
        }
        if (idType.equals(IdType.USER) || idType.equals(IdType.AGENT)) {
            this.debug.error("AMSDKRepo.modifyMembership: Memberhsip to users and agents is not supported");
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (!idType2.equals(IdType.USER)) {
            this.debug.error("AMSDKRepo.modifyMembership: A non-user type cannot  be made a member of any identity" + idType2.getName());
            Object[] objectArray2 = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", objectArray2);
        }
        HashSet<Object[]> hashSet = new HashSet<Object[]>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            objectArray = this.getDN(idType2, (String)object);
            hashSet.add(objectArray);
        }
        Object object2 = object = sc == null ? new AMStoreConnection(sSOToken) : sc;
        if (idType.equals(IdType.GROUP)) {
            objectArray = this.getDN(idType, string);
            AMStaticGroup aMStaticGroup = ((AMStoreConnection)object).getStaticGroup((String)objectArray);
            try {
                switch (n) {
                    case 1: {
                        aMStaticGroup.addUsers(hashSet);
                        break;
                    }
                    case 2: {
                        aMStaticGroup.removeUsers(hashSet);
                    }
                }
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo.modifyMembership: Caught exception while  adding users to groups", (Throwable)aMException);
                throw IdUtils.convertAMException(aMException);
            }
        } else if (idType.equals(IdType.ROLE)) {
            objectArray = this.getDN(idType, string);
            AMRole aMRole = ((AMStoreConnection)object).getRole((String)objectArray);
            try {
                switch (n) {
                    case 1: {
                        aMRole.addUsers(hashSet);
                        break;
                    }
                    case 2: {
                        aMRole.removeUsers(hashSet);
                    }
                }
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo.modifyMembership: Caught exception while  adding/removing users to roles", (Throwable)aMException);
                throw IdUtils.convertAMException(aMException);
            }
        } else {
            this.debug.error("AMSDKRepo.modifyMembership: Memberships cannot bemodified for type= " + idType.getName());
            objectArray = new Object[]{CLASS_NAME, idType.getName()};
            throw new IdRepoException("amIdRepo", "209", objectArray);
        }
    }

    public void removeAttributes(SSOToken sSOToken, IdType idType, String string, Set set) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: removeAttributes called " + idType + ": " + string + set);
        }
    }

    public RepoSearchResults search(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, int n, int n2, Set set) throws IdRepoException, SSOException {
        AMSearchResults aMSearchResults;
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: search called" + idType + ": " + string + ": " + map);
        }
        String string2 = this.orgDN;
        int n3 = this.getProfileType(idType);
        if (idType.equals(IdType.USER)) {
            string2 = "ou=" + this.getDefaultPeopleContainerName() + "," + this.orgDN;
        } else if (idType.equals(IdType.AGENT)) {
            string2 = "ou=" + this.getDefaultAgentContainerName() + "," + this.orgDN;
        } else if (idType.equals(IdType.GROUP)) {
            string2 = "ou=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
        }
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setMaxResults(n);
        aMSearchControl.setTimeOut(n2);
        aMSearchControl.setSearchScope(1);
        if (set == null || set.isEmpty()) {
            aMSearchControl.setAllReturnAttributes(true);
        } else {
            aMSearchControl.setReturnAttributes(set);
        }
        try {
            AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
            switch (n3) {
                case 1: {
                    Object object;
                    AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(string2);
                    if (map == null || map.isEmpty()) {
                        aMSearchResults = aMPeopleContainer.searchUsers(string, map, aMSearchControl);
                    } else {
                        object = AMSDKRepo.constructFilter(0, map);
                        aMSearchResults = aMPeopleContainer.searchUsers(string, aMSearchControl, (String)object);
                    }
                    if (bl && ((object = aMSearchResults.getSearchResults()) == null || object.isEmpty())) {
                        if (map == null || map.isEmpty()) {
                            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.orgDN);
                            aMSearchControl.setSearchScope(2);
                            aMSearchResults = aMOrganization.searchUsers(string, aMSearchControl);
                            break;
                        }
                        String string3 = AMSDKRepo.constructFilter(0, map);
                        AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.orgDN);
                        aMSearchControl.setSearchScope(2);
                        aMSearchResults = aMOrganization.searchUsers("*", aMSearchControl, string3);
                    }
                    break;
                }
                case 100: {
                    AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(string2);
                    aMSearchResults = aMOrganizationalUnit.searchEntities(string, map, null, aMSearchControl);
                    break;
                }
                case 9: 
                case 10: {
                    AMGroupContainer aMGroupContainer = aMStoreConnection.getGroupContainer(string2);
                    aMSearchResults = aMGroupContainer.searchGroups(string, map, aMSearchControl);
                    break;
                }
                case 6: {
                    AMOrganization aMOrganization = aMStoreConnection.getOrganization(string2);
                    aMSearchResults = aMOrganization.searchRoles(string, aMSearchControl);
                    break;
                }
                case 8: {
                    AMOrganization aMOrganization = aMStoreConnection.getOrganization(string2);
                    aMSearchResults = aMOrganization.searchFilteredRoles(string, aMSearchControl);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{CLASS_NAME, idType.getName()};
                    throw new IdRepoException("amIdRepo", "210", objectArray);
                }
            }
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.search: Unable to perform search operation", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
        return new RepoSearchResults(aMSearchResults.getSearchResults(), aMSearchResults.getErrorCode(), aMSearchResults.getResultAttributes(), idType);
    }

    public RepoSearchResults search(SSOToken sSOToken, IdType idType, String string, int n, int n2, Set set, boolean bl, int n3, Map map, boolean bl2) throws IdRepoException, SSOException {
        AMSearchResults aMSearchResults;
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: search called" + idType + ": " + string + ": " + map);
        }
        String string2 = this.orgDN;
        int n4 = this.getProfileType(idType);
        if (idType.equals(IdType.USER)) {
            string2 = "ou=" + this.getDefaultPeopleContainerName() + "," + this.orgDN;
        } else if (idType.equals(IdType.AGENT)) {
            string2 = "ou=" + this.getDefaultAgentContainerName() + "," + this.orgDN;
        } else if (idType.equals(IdType.GROUP)) {
            string2 = "ou=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
        }
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setMaxResults(n2);
        aMSearchControl.setTimeOut(n);
        aMSearchControl.setSearchScope(1);
        if (bl) {
            aMSearchControl.setAllReturnAttributes(true);
        } else if (set != null && !set.isEmpty()) {
            aMSearchControl.setReturnAttributes(set);
        }
        try {
            AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
            switch (n4) {
                case 1: {
                    Object object;
                    AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(string2);
                    if (map == null || map.isEmpty()) {
                        aMSearchResults = aMPeopleContainer.searchUsers(string, map, aMSearchControl);
                    } else {
                        object = AMSDKRepo.constructFilter(n3, map);
                        aMSearchResults = aMPeopleContainer.searchUsers(string, aMSearchControl, (String)object);
                    }
                    if (bl2 && ((object = aMSearchResults.getSearchResults()) == null || object.isEmpty())) {
                        if (map == null || map.isEmpty()) {
                            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.orgDN);
                            aMSearchControl.setSearchScope(2);
                            aMSearchResults = aMOrganization.searchUsers(string, aMSearchControl);
                            break;
                        }
                        String string3 = AMSDKRepo.constructFilter(n3, map);
                        AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.orgDN);
                        aMSearchControl.setSearchScope(2);
                        aMSearchResults = aMOrganization.searchUsers("*", aMSearchControl, string3);
                    }
                    break;
                }
                case 100: {
                    AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(string2);
                    aMSearchResults = aMOrganizationalUnit.searchEntities(string, map, null, aMSearchControl);
                    break;
                }
                case 9: 
                case 10: {
                    AMGroupContainer aMGroupContainer = aMStoreConnection.getGroupContainer(string2);
                    aMSearchResults = aMGroupContainer.searchStaticGroups(string, map, aMSearchControl);
                    break;
                }
                case 6: {
                    AMOrganization aMOrganization = aMStoreConnection.getOrganization(string2);
                    aMSearchResults = aMOrganization.searchRoles(string, aMSearchControl);
                    break;
                }
                case 8: {
                    AMOrganization aMOrganization = aMStoreConnection.getOrganization(string2);
                    aMSearchResults = aMOrganization.searchFilteredRoles(string, aMSearchControl);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{CLASS_NAME, idType.getName()};
                    throw new IdRepoException("amIdRepo", "210", objectArray);
                }
            }
        }
        catch (AMException aMException) {
            String string4 = aMException.getErrorCode();
            if (!string4.equals("341")) {
                this.debug.error("AMSDKRepo.search: Unable to perform search operation", (Throwable)aMException);
            }
            if (n4 == 100 && string4.equals("341")) {
                return new RepoSearchResults(new HashSet(), 0, Collections.EMPTY_MAP, idType);
            }
            throw IdUtils.convertAMException(aMException);
        }
        return new RepoSearchResults(aMSearchResults.getSearchResults(), aMSearchResults.getErrorCode(), aMSearchResults.getResultAttributes(), idType);
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl) throws IdRepoException, SSOException {
        Object object;
        if (this.debug.messageEnabled()) {
            if (map.containsKey("userpassword")) {
                object = new AMHashMap();
                ((AMHashMap)object).copy(map);
                ((AMHashMap)object).remove("userpassword");
                ((AMHashMap)object).put("userpassword", "xxx...");
                this.debug.message("AMSDKRepo: setAttributes called" + idType + ": " + string + ": " + object);
            } else {
                this.debug.message("AMSDKRepo: setAttributes called" + idType + ": " + string + ": " + map);
            }
        }
        if (map == null || map.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        object = this.getDN(idType, string);
        int n = this.getProfileType(idType);
        try {
            if (adminToken != null) {
                sSOToken = adminToken;
            }
            IDirectoryServices iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
            iDirectoryServices.setAttributes(sSOToken, (String)object, n, map, null, false);
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.setAttributes: Unable to set attributes", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
    }

    public void setBinaryAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMSDKRepo: setBinaryAttributes called" + idType + ": " + string + ": " + map);
        }
        if (map == null || map.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        String string2 = this.getDN(idType, string);
        int n = this.getProfileType(idType);
        try {
            if (adminToken != null) {
                sSOToken = adminToken;
            }
            IDirectoryServices iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
            iDirectoryServices.setAttributes(sSOToken, string2, n, new AMHashMap(false), map, false);
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.setBinaryAttributes: Unable to set attributes", (Throwable)aMException);
            throw IdUtils.convertAMException(aMException);
        }
    }

    public void assignService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map) throws IdRepoException, SSOException {
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (adminToken != null) {
            sSOToken = adminToken;
        }
        if (idType.equals(IdType.USER)) {
            Set set = (Set)map.get("objectclass");
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add("objectclass");
            Map map2 = this.getAttributes(sSOToken, idType, string, hashSet);
            Set set2 = (Set)map2.get("objectclass");
            set = AMCommonUtils.combineOCs(set, set2);
            map.put("objectclass", set);
            if (schemaType.equals(SchemaType.USER)) {
                this.setAttributes(sSOToken, idType, string, map, false);
            } else if (schemaType.equals(SchemaType.DYNAMIC)) {
                this.setAttributes(sSOToken, idType, string, map, false);
            }
        } else if (idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE) || idType.equals(IdType.REALM)) {
            IDirectoryServices iDirectoryServices;
            block12: {
                iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
                try {
                    iDirectoryServices.registerService(sSOToken, this.orgDN, string2);
                }
                catch (AMException aMException) {
                    if (aMException.getErrorCode().equals("464")) break block12;
                    throw IdUtils.convertAMException(aMException);
                }
            }
            String string3 = this.getDN(idType, string);
            try {
                map.remove("objectclass");
                iDirectoryServices.createAMTemplate(sSOToken, string3, this.getProfileType(idType), string2, map, 0);
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo.assignService: Caught AMException", (Throwable)aMException);
                throw IdUtils.convertAMException(aMException);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unassignService(SSOToken sSOToken, IdType idType, String string, String string2, Map map) throws IdRepoException, SSOException {
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (adminToken != null) {
            sSOToken = adminToken;
        }
        if (idType.equals(IdType.USER)) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Set set = (Set)map.get("objectclass");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("objectclass");
            Map map2 = this.getAttributes(sSOToken, idType, string, hashSet);
            Set set2 = (Set)map2.get("objectclass");
            set = AMCommonUtils.updateAndGetRemovableOCs(set2, set);
            HashSet<String> hashSet2 = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                object3 = AMDirectoryAccessFactory.getDirectoryServices();
                object2 = object3.getAttributesForSchema((String)object4);
                object = object2.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    hashSet2.add(string3.toLowerCase());
                }
            }
            object4 = this.getAttributes(sSOToken, idType, string);
            object3 = object4.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (!hashSet2.contains(object2)) continue;
                try {
                    object = new AMHashMap();
                    object.put(object2, Collections.EMPTY_SET);
                    this.setAttributes(sSOToken, idType, string, (Map)object, false);
                }
                catch (Exception exception) {
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("AMUserImpl.unassignServices()Error occured while removing attribute: " + (String)object2);
                }
            }
            object2 = new AMHashMap();
            object2.put("objectclass", set2);
            this.setAttributes(sSOToken, idType, string, (Map)object2, false);
            return;
        } else if (idType.equals(IdType.ROLE)) {
            try {
                AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                String string4 = this.getDN(idType, string);
                AMRole aMRole = aMStoreConnection.getRole(string4);
                AMTemplate aMTemplate = aMRole.getTemplate(string2, 301);
                if (aMTemplate == null || !aMTemplate.isExists()) return;
                aMTemplate.delete();
                return;
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo.unassignService: Caught AMException", (Throwable)aMException);
                throw IdUtils.convertAMException(aMException);
            }
        } else if (idType.equals(IdType.FILTEREDROLE) || idType.equals(IdType.REALM)) {
            try {
                AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                String string5 = this.getDN(idType, string);
                AMFilteredRole aMFilteredRole = aMStoreConnection.getFilteredRole(string5);
                AMTemplate aMTemplate = aMFilteredRole.getTemplate(string2, 301);
                if (aMTemplate == null || !aMTemplate.isExists()) return;
                aMTemplate.delete();
                return;
            }
            catch (AMException aMException) {
                this.debug.error("AMSDKRepo.unassignService: Caught AMException", (Throwable)aMException);
                throw IdUtils.convertAMException(aMException);
            }
        } else {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
    }

    public Set getAssignedServices(SSOToken sSOToken, IdType idType, String string, Map map) throws IdRepoException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (map == null || map.isEmpty()) {
            return hashSet;
        }
        if (idType.equals(IdType.USER)) {
            Set set = this.readObjectClass(sSOToken, idType, string);
            set = this.convertToLowerCase(set);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Set set2 = (Set)map.get(string2);
                if (!set.containsAll(set2 = this.convertToLowerCase(set2))) continue;
                hashSet.add(string2);
            }
        } else if (idType.equals(IdType.ROLE)) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                try {
                    AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                    String string4 = this.getDN(idType, string);
                    AMRole aMRole = aMStoreConnection.getRole(string4);
                    AMTemplate aMTemplate = aMRole.getTemplate(string3, 301);
                    if (aMTemplate == null || !aMTemplate.isExists()) continue;
                    hashSet.add(string3);
                }
                catch (AMException aMException) {
                    // empty catch block
                }
            }
        } else if (idType.equals(IdType.FILTEREDROLE) || idType.equals(IdType.REALM)) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                try {
                    AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                    String string6 = this.getDN(idType, string);
                    AMFilteredRole aMFilteredRole = aMStoreConnection.getFilteredRole(string6);
                    AMTemplate aMTemplate = aMFilteredRole.getTemplate(string5, 301);
                    if (aMTemplate == null || !aMTemplate.isExists()) continue;
                    hashSet.add(string5);
                }
                catch (AMException aMException) {
                    // empty catch block
                }
            }
        } else {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        return hashSet;
    }

    public Map getServiceAttributes(SSOToken sSOToken, IdType idType, String string, String string2, Set set) throws IdRepoException, SSOException {
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (idType.equals(IdType.USER)) {
            return this.getAttributes(sSOToken, idType, string, set);
        }
        if (idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE) || idType.equals(IdType.REALM)) {
            try {
                AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                String string3 = this.getDN(idType, string);
                AMRole aMRole = aMStoreConnection.getRole(string3);
                AMTemplate aMTemplate = aMRole.getTemplate(string2, 301);
                if (aMTemplate != null && aMTemplate.isExists()) {
                    return aMTemplate.getAttributes(set);
                }
                if (this.debug.messageEnabled()) {
                    this.debug.message("AMSDKRepo::getServiceAttributes Service: " + string2 + " is not assigned to DN: " + string3);
                }
                return Collections.EMPTY_MAP;
            }
            catch (AMException aMException) {
                throw IdUtils.convertAMException(aMException);
            }
        }
        if (idType.equals(IdType.FILTEREDROLE) || idType.equals(IdType.REALM)) {
            try {
                AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                String string4 = this.getDN(idType, string);
                AMRole aMRole = aMStoreConnection.getRole(string4);
                AMTemplate aMTemplate = aMRole.getTemplate(string2, 301);
                if (aMTemplate != null && aMTemplate.isExists()) {
                    return aMTemplate.getAttributes(set);
                }
                Object[] objectArray = new Object[]{string2};
                throw new IdRepoException("amIdRepo", "101", objectArray);
            }
            catch (AMException aMException) {
                throw IdUtils.convertAMException(aMException);
            }
        }
        Object[] objectArray = new Object[]{this.getClass().getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
    }

    public void modifyService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map) throws IdRepoException, SSOException {
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (idType.equals(IdType.USER)) {
            if (schemaType.equals(SchemaType.DYNAMIC)) {
                Object[] objectArray = new Object[]{this.getClass().getName(), schemaType.toString(), idType.getName()};
                throw new IdRepoException("amIdRepo", "214", objectArray);
            }
            this.setAttributes(sSOToken, idType, string, map, false);
        } else {
            if (idType.equals(IdType.ROLE)) {
                if (schemaType.equals(SchemaType.USER)) {
                    Object[] objectArray = new Object[]{this.getClass().getName(), schemaType.toString(), idType.getName()};
                    throw new IdRepoException("amIdRepo", "214", objectArray);
                }
                try {
                    AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                    String string3 = this.getDN(idType, string);
                    AMRole aMRole = aMStoreConnection.getRole(string3);
                    AMTemplate aMTemplate = aMRole.getTemplate(string2, 301);
                    if (aMTemplate == null || !aMTemplate.isExists()) {
                        Object[] objectArray = new Object[]{string2};
                        throw new IdRepoException("amIdRepo", "101", objectArray);
                    }
                    aMTemplate.setAttributes(map);
                    aMTemplate.store();
                }
                catch (AMException aMException) {
                    throw IdUtils.convertAMException(aMException);
                }
            }
            if (idType.equals(IdType.FILTEREDROLE) || idType.equals(IdType.REALM)) {
                if (schemaType.equals(SchemaType.USER)) {
                    Object[] objectArray = new Object[]{this.getClass().getName(), schemaType.toString(), idType.getName()};
                    throw new IdRepoException("amIdRepo", "214", objectArray);
                }
                try {
                    AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
                    String string4 = this.getDN(idType, string);
                    AMFilteredRole aMFilteredRole = aMStoreConnection.getFilteredRole(string4);
                    AMTemplate aMTemplate = aMFilteredRole.getTemplate(string2, 301);
                    if (aMTemplate == null || !aMTemplate.isExists()) {
                        Object[] objectArray = new Object[]{string2};
                        throw new IdRepoException("amIdRepo", "101", objectArray);
                    }
                    aMTemplate.setAttributes(map);
                    aMTemplate.store();
                }
                catch (AMException aMException) {
                    throw IdUtils.convertAMException(aMException);
                }
            }
        }
    }

    public static void notifyObjectChangedEvent(String string, int n) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            IdRepoListener idRepoListener = (IdRepoListener)iterator.next();
            Map map = idRepoListener.getConfigMap();
            idRepoListener.objectChanged(string, n, map);
        }
    }

    public static void notifyAllObjectsChangedEvent() {
        block0: {
            Iterator iterator = listeners.iterator();
            if (!iterator.hasNext()) break block0;
            IdRepoListener idRepoListener = (IdRepoListener)iterator.next();
            idRepoListener.allObjectsChanged();
        }
    }

    private void loadSupportedOps() {
        HashSet<IdOperation> hashSet = new HashSet<IdOperation>();
        hashSet.add(IdOperation.CREATE);
        hashSet.add(IdOperation.DELETE);
        hashSet.add(IdOperation.EDIT);
        hashSet.add(IdOperation.READ);
        hashSet.add(IdOperation.SERVICE);
        this.supportedOps.put(IdType.USER, Collections.unmodifiableSet(hashSet));
        this.supportedOps.put(IdType.ROLE, Collections.unmodifiableSet(hashSet));
        this.supportedOps.put(IdType.FILTEREDROLE, Collections.unmodifiableSet(hashSet));
        HashSet hashSet2 = new HashSet(hashSet);
        hashSet2.remove(IdOperation.SERVICE);
        this.supportedOps.put(IdType.GROUP, Collections.unmodifiableSet(hashSet2));
        this.supportedOps.put(IdType.AGENT, Collections.unmodifiableSet(hashSet2));
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet3.remove(IdOperation.CREATE);
        hashSet3.remove(IdOperation.DELETE);
        hashSet3.remove(IdOperation.EDIT);
        this.supportedOps.put(IdType.REALM, Collections.unmodifiableSet(hashSet3));
    }

    private String getDefaultPeopleContainerName() {
        String string = "People";
        try {
            Map map;
            Set set;
            ServiceSchema serviceSchema;
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(ADMIN_SERVICE, adminToken);
            if (serviceSchemaManager != null && (serviceSchema = serviceSchemaManager.getGlobalSchema()) != null && (set = (Set)(map = serviceSchema.getAttributeDefaults()).get(PC_ATTR)) != null && !set.isEmpty()) {
                string = (String)set.iterator().next();
            }
        }
        catch (SMSException sMSException) {
            this.debug.error("AMSDKRepo.getDefaultGC: SMSException: ", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            this.debug.error("AMSDKRepo.getDefaultGC: SSOException", (Throwable)sSOException);
        }
        return string;
    }

    private String getDefaultGroupContainerName() {
        String string = "Groups";
        try {
            Map map;
            Set set;
            ServiceSchema serviceSchema;
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(ADMIN_SERVICE, adminToken);
            if (serviceSchemaManager != null && (serviceSchema = serviceSchemaManager.getGlobalSchema()) != null && (set = (Set)(map = serviceSchema.getAttributeDefaults()).get(GC_ATTR)) != null && !set.isEmpty()) {
                string = (String)set.iterator().next();
            }
        }
        catch (SMSException sMSException) {
            this.debug.error("AMSDKRepo.getDefaultAC: SMSException: ", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            this.debug.error("AMSDKRepo.getDefaultAC: SSOException", (Throwable)sSOException);
        }
        return string;
    }

    private String getDefaultAgentContainerName() {
        String string = "Agent";
        try {
            Map map;
            Set set;
            ServiceSchema serviceSchema;
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(ADMIN_SERVICE, adminToken);
            if (serviceSchemaManager != null && (serviceSchema = serviceSchemaManager.getGlobalSchema()) != null && (set = (Set)(map = serviceSchema.getAttributeDefaults()).get(AC_ATTR)) != null && !set.isEmpty()) {
                string = (String)set.iterator().next();
            }
        }
        catch (SMSException sMSException) {
            this.debug.error("AMSDKRepo.getDefaultAC: SMSException: ", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            this.debug.error("AMSDKRepo.getDefaultAC: SSOException", (Throwable)sSOException);
        }
        return string;
    }

    private AMOrganization checkAndGetOrg(SSOToken sSOToken) throws IdRepoException, SSOException {
        AMStoreConnection aMStoreConnection = sc == null ? new AMStoreConnection(sSOToken) : sc;
        try {
            int n = aMStoreConnection.getAMObjectType(this.orgDN);
            if (n != 2) {
                this.debug.error("AMSDKRepo.create(): Incorrectly configured  plugin: Org DN is wrong = " + this.orgDN);
                throw new IdRepoException("amIdRepo", "303", null);
            }
        }
        catch (AMException aMException) {
            this.debug.error("AMSDKRepo.create(): An exception occured while  initializing AM SDK ", (Throwable)aMException);
            Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.CREATE.getName()};
            throw new IdRepoException("amIdRepo", "304", objectArray);
        }
        return aMStoreConnection.getOrganization(this.orgDN);
    }

    private String getDN(IdType idType, String string) throws IdRepoException, SSOException {
        String string2;
        block24: {
            if (DN.isDN((String)string) && string.indexOf(",") > -1) {
                return string;
            }
            if (sc == null) {
                throw new IdRepoException("amProfile", "301", null);
            }
            if (idType.equals(IdType.USER)) {
                string2 = AMNamingAttrManager.getNamingAttr(1) + "=" + string + ",ou=" + this.getDefaultPeopleContainerName() + "," + this.orgDN;
                try {
                    int n = sc.getAMObjectType(string2);
                    if (n != 1) {
                        Object[] objectArray = new Object[]{sc.getAMObjectName(n)};
                        throw new IdRepoException("amIdRepo", "217", objectArray);
                    }
                    break block24;
                }
                catch (AMException aMException) {
                    throw IdUtils.convertAMException(aMException);
                }
            }
            if (idType.equals(IdType.AGENT)) {
                string2 = AMNamingAttrManager.getNamingAttr(100) + "=" + string + ",ou=" + this.getDefaultAgentContainerName() + "," + this.orgDN;
                try {
                    int n = sc.getAMObjectType(string2);
                    if (n != 100) {
                        Object[] objectArray = new Object[]{sc.getAMObjectName(n)};
                        throw new IdRepoException("amIdRepo", "217", objectArray);
                    }
                    break block24;
                }
                catch (AMException aMException) {
                    throw IdUtils.convertAMException(aMException);
                }
            }
            if (idType.equals(IdType.GROUP)) {
                string2 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + ",ou=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
                try {
                    int n = sc.getAMObjectType(string2);
                    if (n != 9 && n != 10) {
                        Object[] objectArray = new Object[]{sc.getAMObjectName(n)};
                        throw new IdRepoException("amIdRepo", "217", objectArray);
                    }
                    break block24;
                }
                catch (AMException aMException) {
                    throw IdUtils.convertAMException(aMException);
                }
            }
            if (idType.equals(IdType.ROLE)) {
                string2 = AMNamingAttrManager.getNamingAttr(6) + "=" + string + "," + this.orgDN;
                try {
                    int n = sc.getAMObjectType(string2);
                    if (n != 6) {
                        Object[] objectArray = new Object[]{sc.getAMObjectName(n)};
                        throw new IdRepoException("amIdRepo", "217", objectArray);
                    }
                    break block24;
                }
                catch (AMException aMException) {
                    throw IdUtils.convertAMException(aMException);
                }
            }
            if (idType.equals(IdType.FILTEREDROLE)) {
                string2 = AMNamingAttrManager.getNamingAttr(8) + "=" + string + "," + this.orgDN;
                try {
                    int n = sc.getAMObjectType(string2);
                    if (n != 8) {
                        Object[] objectArray = new Object[]{sc.getAMObjectName(n)};
                        throw new IdRepoException("amIdRepo", "217", objectArray);
                    }
                    break block24;
                }
                catch (AMException aMException) {
                    throw IdUtils.convertAMException(aMException);
                }
            }
            if (idType.equals(IdType.REALM)) {
                string2 = AMNamingAttrManager.getNamingAttr(8) + "=" + string + "," + this.orgDN;
            } else {
                Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.READ.getName(), idType.getName()};
                throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray);
            }
        }
        return string2;
    }

    private int getProfileType(IdType idType) throws IdRepoException {
        int n;
        if (idType.equals(IdType.USER)) {
            n = 1;
        } else if (idType.equals(IdType.AGENT)) {
            n = 100;
        } else if (idType.equals(IdType.GROUP)) {
            n = 9;
        } else if (idType.equals(IdType.ROLE)) {
            n = 6;
        } else if (idType.equals(IdType.FILTEREDROLE)) {
            n = 8;
        } else if (idType.equals(IdType.REALM) || idType.equals(IdType.REALM)) {
            n = 8;
        } else {
            Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.READ.getName(), idType.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray);
        }
        return n;
    }

    private Set readObjectClass(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("objectclass");
        Map map = this.getAttributes(sSOToken, idType, string, hashSet);
        Set set = (Set)map.get("objectclass");
        return set;
    }

    private Set convertToLowerCase(Set set) {
        if (set == null || set.isEmpty()) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((String)iterator.next()).toLowerCase());
        }
        return hashSet;
    }

    protected static String constructFilter(int n, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            stringBuffer.append("(|");
        } else if (n == 1) {
            stringBuffer.append("(&");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = ((Set)map.get(string)).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuffer.append("(").append(string).append("=").append(string2).append(")");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

