/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMTemplateImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.SearchControl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMRoleImpl
extends AMObjectImpl
implements AMRole {
    static String roleTypeAN = "iplanet-am-role-type";
    static String roleDNsAN = "nsroledn";
    private static final Integer POLICY_TEMPLATE_INTEGER = new Integer(300);

    public AMRoleImpl(SSOToken sSOToken, String string) {
        super(sSOToken, string, 6);
    }

    AMRoleImpl(SSOToken sSOToken, String string, int n) {
        super(sSOToken, string, n);
    }

    public int getRoleType() throws AMException, SSOException {
        return this.getIntegerAttribute(roleTypeAN);
    }

    public void setRoleType(int n) throws AMException, SSOException {
        this.setIntegerAttribute(roleTypeAN, n);
        this.store();
    }

    public void addUsers(Set set) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.dsServices.modifyMemberShip(this.token, set, this.entryDN, 6, 1);
    }

    public void removeUsers(Set set) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.dsServices.modifyMemberShip(this.token, set, this.entryDN, 6, 2);
    }

    public long getNumberOfUsers() throws AMException, SSOException {
        return this.getUserDNs().size();
    }

    public Set getUserDNs() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return this.dsServices.getMembers(this.token, this.entryDN, this.profileType);
    }

    public Set searchUsers(String string, int n) throws AMException, SSOException {
        return this.searchUsers(string, null, n);
    }

    public AMSearchResults searchUsers(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchUsers(string, null, aMSearchControl);
    }

    public Set searchUsers(String string, Map map, int n) throws AMException, SSOException {
        if (n != 1 && n != 2) {
            throw new AMException(AMSDKBundle.getString("123"), "123");
        }
        if (string == null || string.length() == 0) {
            throw new AMException(AMSDKBundle.getString("122"), "122");
        }
        String string2 = "(&(" + AMNamingAttrManager.getNamingAttr(1) + "=" + string + ")" + this.getSearchFilter(1) + "(" + roleDNsAN + "=" + this.entryDN + "))";
        String string3 = null;
        if (map == null) {
            string3 = string2;
        } else if (map.size() == 0) {
            string3 = string2;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(&").append(string2).append("(|");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                Iterator iterator2 = ((Set)map.get(string4)).iterator();
                while (iterator2.hasNext()) {
                    String string5 = (String)iterator2.next();
                    stringBuffer.append("(").append(string4).append("=").append(string5).append(")");
                }
            }
            stringBuffer.append("))");
            string3 = stringBuffer.toString();
        }
        return this.dsServices.search(this.token, this.getOrganizationDN(), string3, n);
    }

    public AMSearchResults searchUsers(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        Object object;
        Serializable serializable;
        int n = aMSearchControl.getSearchScope();
        if (n != 1 && n != 2) {
            throw new AMException(AMSDKBundle.getString("123"), "123");
        }
        if (string == null || string.length() == 0) {
            throw new AMException(AMSDKBundle.getString("122"), "122");
        }
        String string2 = "(&(" + AMNamingAttrManager.getNamingAttr(1) + "=" + string + ")" + this.getSearchFilter(1) + "(" + roleDNsAN + "=" + this.entryDN + "))";
        String string3 = null;
        if (map == null) {
            string3 = string2;
        } else if (map.size() == 0) {
            string3 = string2;
        } else {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("(&").append(string2).append("(|");
            object = map.keySet().iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                Iterator iterator = ((Set)map.get(string4)).iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    ((StringBuffer)serializable).append("(").append(string4).append("=").append(string5).append(")");
                }
            }
            ((StringBuffer)serializable).append("))");
            string3 = ((StringBuffer)serializable).toString();
        }
        serializable = aMSearchControl.getSearchControl();
        object = aMSearchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.getOrganizationDN(), string3, (SearchControl)serializable, (String[])object);
    }

    public AMSearchResults searchUsers(AMSearchControl aMSearchControl, String string) throws AMException, SSOException {
        int n = aMSearchControl.getSearchScope();
        if (n != 1 && n != 2) {
            throw new AMException(AMSDKBundle.getString("123"), "123");
        }
        String string2 = "(&" + this.getSearchFilter(1) + "(" + roleDNsAN + "=" + this.entryDN + ")" + string + ")";
        if (AMObjectImpl.debug.messageEnabled()) {
            AMObjectImpl.debug.message("AMRoleImpl.searchUsers: " + string2);
        }
        aMSearchControl.setSearchScope(2);
        SearchControl searchControl = aMSearchControl.getSearchControl();
        String[] stringArray = aMSearchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.getOrganizationDN(), string2, searchControl, stringArray);
    }

    public Set getTemplates(Map map) throws AMException, SSOException {
        return this.getTemplates(map, false);
    }

    private Set getTemplates(Map map, boolean bl) throws AMException, SSOException {
        Set set;
        SSOTokenManager.getInstance().validateToken(this.token);
        if (AMObjectImpl.debug.messageEnabled()) {
            AMObjectImpl.debug.message("AMRoleImpl.getTemplate: Map = [" + map + "] DN=" + this.entryDN);
        }
        if ((set = this.dsServices.search(this.token, this.getParentDN(), "(&(objectclass=costemplate)(cn=\"" + this.entryDN + "\"))", 2)) == null || set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        boolean bl2 = false;
        if (map == null || map.isEmpty()) {
            bl2 = true;
        }
        HashSet<AMTemplateImpl> hashSet = new HashSet<AMTemplateImpl>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DN dN = new DN((String)iterator.next());
            if (AMObjectImpl.debug.messageEnabled()) {
                AMObjectImpl.debug.message("AMRoleImpl.getTemplate: DN=" + dN);
            }
            String string = ((RDN)dN.getParent().getRDNs().get(0)).getValues()[0];
            int n = 301;
            if (bl2) {
                if (!bl) {
                    hashSet.add(new AMTemplateImpl(this.token, dN.toRFCString(), string, n));
                    continue;
                }
                if (n != 300) continue;
                hashSet.add(new AMTemplateImpl(this.token, dN.toRFCString(), string, n));
                continue;
            }
            Integer n2 = (Integer)map.get(string);
            if (n2 == null || n2 != 303 && n2 != n) continue;
            hashSet.add(new AMTemplateImpl(this.token, dN.toRFCString(), string, n));
        }
        return hashSet;
    }

    public Set getPolicyTemplates(Set set) throws AMException, SSOException {
        if (set == null || set.isEmpty()) {
            return this.getTemplates(null, true);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashMap.put((String)iterator.next(), POLICY_TEMPLATE_INTEGER);
        }
        return this.getTemplates(hashMap, false);
    }

    public Set getAssignedPolicyDNs() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        throw new UnsupportedOperationException();
    }
}

