/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMSDKRepo;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMObjectListenerImpl
implements AMObjectListener {
    private Debug debug = Debug.getInstance((String)"amProfileListener");

    AMObjectListenerImpl() {
    }

    public void objectChanged(String string, int n, Map map) {
        String string2;
        block5: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMObjectListenerImpl.objectChanged(): name: " + string + " type: " + n);
            }
            string2 = new DN(string).toRFCString().toLowerCase();
            AMStoreConnection.updateCache(string2, n);
            try {
                if (AMCompliance.isComplianceUserDeletionEnabled()) {
                    AMCompliance.cleanDeletedOrgCache(string2);
                }
                if (AMDCTree.isRequired()) {
                    AMDCTree.cleanDomainMap(string2);
                }
            }
            catch (AMException aMException) {
                if (!this.debug.warningEnabled()) break block5;
                this.debug.warning("AMObjectListenerImpl.objectChanged() AMException occured: ", (Throwable)aMException);
            }
        }
        AMObjectImpl.notifyEntryEvent(string2, n, false);
        AMSDKRepo.notifyObjectChangedEvent(string2, n);
    }

    public void objectsChanged(String string, int n, Set set, Map map) {
        String string2;
        block5: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMObjectListenerImpl.objectsChanged(): parentName: " + string + " type: " + n + "\n config map= " + map);
            }
            string2 = new DN(string).toRFCString().toLowerCase();
            AMStoreConnection.updateCache(string2, n);
            try {
                if (AMCompliance.isComplianceUserDeletionEnabled()) {
                    AMCompliance.cleanDeletedOrgCache(string2);
                }
                if (AMDCTree.isRequired()) {
                    AMDCTree.cleanDomainMap(string2);
                }
            }
            catch (AMException aMException) {
                if (!this.debug.warningEnabled()) break block5;
                this.debug.warning("AMObjectListenerImpl.objectsChanged() AMException occured: ", (Throwable)aMException);
            }
        }
        AMObjectImpl.notifyEntryEvent(string2, n, true);
        AMSDKRepo.notifyAllObjectsChangedEvent();
    }

    public void permissionsChanged(String string, Map map) {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMObjectListenerImpl.permissionsChanged(): orgName: " + string);
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        AMStoreConnection.updateCache(string2, 4);
        AMObjectImpl.notifyACIChangeEvent(string2, 4);
        AMSDKRepo.notifyAllObjectsChangedEvent();
    }

    public void allObjectsChanged() {
        this.debug.error("AMObjectListenerImpl: Received all objects changed event from event service");
        AMEvent aMEvent = new AMEvent(AMStoreConnection.rootSuffix);
        AMObjectImpl.notifyAffectedDNs(AMStoreConnection.rootSuffix, aMEvent);
        AMSDKRepo.notifyAllObjectsChangedEvent();
    }

    public Map getConfigMap() {
        return null;
    }

    public void setConfigMap(Map map) {
    }
}

