/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;

public final class AMEntityType {
    private String name;
    private int type;
    private String serviceName;
    private String searchTemplateName;
    private String creationTemplateName;
    private String containerRDN;
    private int containerType;
    private String stAttribute;
    private String namingAttribute;
    private String objectClass;
    private Debug debug = AMCommonUtils.debug;

    protected AMEntityType(String string, int n, String string2, String string3, String string4, String string5, int n2, String string6, String string7, String string8) {
        this.name = string;
        this.type = n;
        this.serviceName = string2;
        this.containerRDN = string5;
        this.containerType = n2;
        this.stAttribute = string7;
        this.namingAttribute = string6;
        this.objectClass = string8;
        this.searchTemplateName = string3;
        this.creationTemplateName = string4;
        if (this.debug.messageEnabled()) {
            this.debug.message("AMEntityType:Constructor-> created type " + this.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Entity Name=\t").append(this.name).append("\n").append("Entity type=\t").append(this.type).append("\n").append("Object Class=\t").append(this.objectClass).append("\n").append("Service Name=\t").append(this.serviceName).append("\n").append("Creation Template=\t").append(this.creationTemplateName).append("\n").append("Search Template=\t").append(this.searchTemplateName).append("\n").append("Naming Attribute=\t").append(this.namingAttribute).append("\n").append("Status Attribute=\t").append(this.stAttribute).append("\n").append("Container RDN=\t").append(this.containerRDN).append("\n").append("Container Type=\t").append(this.containerType).append("\n");
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceSchemaManager getServiceSchemaManager(SSOToken sSOToken) throws AMException, SSOException {
        if (this.serviceName == null || this.serviceName.length() == 0) {
            Object[] objectArray = new Object[]{this.name};
            throw new AMException(AMSDKBundle.getString("978", objectArray), "978", objectArray);
        }
        try {
            return new ServiceSchemaManager(this.serviceName, sSOToken);
        }
        catch (SMSException sMSException) {
            this.debug.error("AMEntityType.getServiceSchemaManager: SM Exception", (Throwable)sMSException);
            Object[] objectArray = new Object[]{this.name};
            throw new AMException(AMSDKBundle.getString("978", objectArray), "978", objectArray);
        }
    }

    protected String getNamingAttribute() {
        return this.namingAttribute;
    }

    protected String getObjectClass() {
        return this.objectClass;
    }

    protected String getCreationTemplate() {
        return this.creationTemplateName;
    }

    public String getSearchTemplate() {
        return this.searchTemplateName;
    }

    protected String getContainerRDN() {
        return this.containerRDN;
    }

    protected int getContainerType() {
        return this.containerType;
    }
}

