/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Locale;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DisplayUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

class SessionRequest {
    private static final String USER_ID = "UserId";
    private SessionID curSessionID;
    private Session curSession;
    private ResourceBundle bundle;
    private String serverName;

    SessionRequest(SSOToken sSOToken, String string, ResourceBundle resourceBundle) throws AdminException {
        this.serverName = this.trimTrailingSlash(string);
        this.bundle = resourceBundle;
        this.curSessionID = new SessionID(sSOToken.getTokenID().toString());
        try {
            this.curSession = Session.getSession((SessionID)this.curSessionID);
        }
        catch (SessionException sessionException) {
            throw new AdminException(sessionException);
        }
    }

    public void displaySessions(String string) throws AdminException {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(this.serverName, ":");
        if (stringTokenizer.countTokens() == 3) {
            List list = this.getSessionList(this.serverName, string);
            if (list != null && !list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.printSessionInformation((SessionData)iterator.next());
                }
                this.promptForInvalidation(list);
            } else {
                System.err.println(this.bundle.getString("sessionsListEmpty"));
            }
        } else {
            System.err.println(this.bundle.getString("serverNameError"));
        }
    }

    private List getSessionList(String string, String string2) throws AdminException {
        ArrayList<SessionData> arrayList = Collections.EMPTY_LIST;
        try {
            System.out.println(this.bundle.getString("getSessionList") + " " + this.bundle.getString("serverName") + " = " + string);
            String string3 = this.curSession.getProperty("SessionHandle");
            AMSearchResults aMSearchResults = this.curSession.getValidSessions(string, null);
            String string4 = this.getSearchResultWarningMessage(aMSearchResults);
            if (string4.length() > 0) {
                System.out.println(string4);
            }
            Hashtable hashtable = (Hashtable)aMSearchResults.getResultAttributes();
            arrayList = new ArrayList<SessionData>(hashtable.size());
            boolean bl = false;
            int n = 0;
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext()) {
                String string5;
                boolean bl2 = false;
                Session session = (Session)iterator.next();
                if (!bl) {
                    try {
                        bl2 = session.getProperty("SessionHandle").equals(string3);
                    }
                    catch (SessionException sessionException) {
                        throw new AdminException(sessionException);
                    }
                    bl = bl2;
                }
                if ((string5 = session.getProperty(USER_ID)) == null || !DisplayUtils.wildcardMatch((String)(string5 = this.dnToName(string5)), (String)string2)) continue;
                int n2 = bl2 ? -1 : n++;
                SessionData sessionData = this.createSessionData(n2, string5, session);
                if (n2 == -1) {
                    arrayList.add(0, sessionData);
                    continue;
                }
                arrayList.add(sessionData);
            }
        }
        catch (SessionException sessionException) {
            System.err.println(this.bundle.getString("invalidServiceHostName"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private String dnToName(String string) {
        String string2 = string;
        if (DN.isDN((String)string)) {
            String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
            string2 = stringArray[0];
        }
        return string2;
    }

    private void promptForInvalidation(List list) throws AdminException {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        System.out.println(this.bundle.getString("toInvalidate"));
        System.out.println(this.bundle.getString("CRToExit"));
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() != 0) {
                boolean bl = true;
                while (stringTokenizer.hasMoreTokens() && bl) {
                    String string2 = stringTokenizer.nextToken();
                    bl = this.sessionIndexMatched(list, string2);
                    if (bl) {
                        arrayList.add(string2);
                        continue;
                    }
                    System.err.println(this.bundle.getString("selectionNotInList"));
                }
                if (bl) {
                    this.invalidateSessions(list, arrayList);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(this.bundle.getString("ioExceptionReadingInput") + " " + iOException);
        }
    }

    private boolean sessionIndexMatched(List list, String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = n >= 0 && n < list.size();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    private void destroySession(Session session, Session session2) {
        try {
            session.destroySession(session2);
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
    }

    private void invalidateSessions(List list, List list2) throws AdminException {
        if (list2 != null && !list2.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SessionData sessionData = (SessionData)iterator.next();
                String string = String.valueOf(sessionData.index);
                if (!list2.contains(string)) continue;
                this.destroySession(this.curSession, sessionData.session);
                String[] stringArray = new String[]{sessionData.userId};
                AdminUtils.logOperation(0, Level.INFO, "STATUS_MSG36", stringArray);
            }
            System.out.println(this.bundle.getString("destroySessionSucceeded"));
        }
    }

    private SessionData createSessionData(int n, String string, Session session) throws SessionException {
        SessionData sessionData = new SessionData();
        sessionData.userId = string;
        sessionData.clientID = session.getClientID();
        sessionData.index = n;
        sessionData.session = session;
        sessionData.timeRemain = String.valueOf(session.getTimeLeft() / 60L);
        sessionData.maxSessionTime = String.valueOf(session.getMaxSessionTime());
        sessionData.idleTime = String.valueOf(session.getIdleTime() / 60L);
        sessionData.maxIdleTime = String.valueOf(session.getMaxIdleTime());
        return sessionData;
    }

    private void printSessionInformation(SessionData sessionData) {
        if (sessionData.index == -1) {
            System.out.print(this.bundle.getString("currentSession") + " ");
        } else {
            System.out.print(this.bundle.getString("index") + " " + sessionData.index + " ");
        }
        System.out.println(this.bundle.getString("userId") + " " + sessionData.userId + " " + this.bundle.getString("timeRemain") + " " + sessionData.timeRemain + " " + this.bundle.getString("maxSessionTime") + " " + sessionData.maxSessionTime + " " + this.bundle.getString("idleTime") + " " + sessionData.idleTime + " " + this.bundle.getString("maxIdleTime") + " " + sessionData.maxIdleTime);
    }

    private String getSearchResultWarningMessage(AMSearchResults aMSearchResults) {
        String string = null;
        Object[] objectArray = null;
        if (aMSearchResults != null) {
            int n = aMSearchResults.getErrorCode();
            if (n == 1) {
                string = Locale.getString((ResourceBundle)this.bundle, (String)"sizeLimitExceeded", objectArray);
            } else if (n == 2) {
                string = Locale.getString((ResourceBundle)this.bundle, (String)"timeLimitExceeded", objectArray);
            }
        }
        return string != null ? string : "";
    }

    private String trimTrailingSlash(String string) {
        int n = string.length();
        while (n > 0 && string.charAt(n - 1) == '/') {
            string = string.substring(0, n - 1);
            --n;
        }
        return string;
    }

    private class SessionData {
        private int index = 0;
        private String userId = null;
        private String clientID = null;
        private Session session = null;
        private String timeRemain = null;
        private String maxSessionTime = null;
        private String idleTime = null;
        private String maxIdleTime = null;

        private SessionData() {
        }
    }
}

