/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.sdk.AMSearchControl;

abstract class SearchReq
extends AdminReq {
    protected int errorCode = 0;
    protected String filter = "*";
    protected int timeLimit = 0;
    protected int sizeLimit = 0;

    SearchReq(String string) {
        super(string);
    }

    int getErrorCode() {
        return this.errorCode;
    }

    void setSizeLimit(String string) throws AdminException {
        if (string != null && string.trim().length() > 0) {
            try {
                this.sizeLimit = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdminException(numberFormatException);
            }
        }
    }

    void setTimeLimit(String string) throws AdminException {
        if (string != null && string.trim().length() > 0) {
            try {
                this.timeLimit = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdminException(numberFormatException);
            }
        }
    }

    int getSizeLimit() {
        return this.sizeLimit;
    }

    int getTimeLimit() {
        return this.timeLimit;
    }

    void setFilter(String string) {
        if (string != null && string.trim().length() > 0) {
            this.filter = string;
        }
    }

    String getFilter() {
        return this.filter;
    }

    AMSearchControl createSearchControl(int n) {
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(n);
        aMSearchControl.setMaxResults(this.sizeLimit);
        aMSearchControl.setTimeOut(this.timeLimit);
        return aMSearchControl;
    }

    void printSearchLimitError() {
        String string = null;
        switch (this.errorCode) {
            case 2: {
                string = AdminReq.bundle.getString("searchTimeLimitExceeded");
                break;
            }
            case 1: {
                string = AdminReq.bundle.getString("searchSizeLimitExceeded");
            }
        }
        if (string != null) {
            System.out.println();
            System.out.println(string);
            System.out.println();
        }
    }
}

