/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class RealmModifyServiceReq
extends AdminReq {
    private Map serviceAttrMap;
    private String serviceName = null;
    private String realmPath = null;

    RealmModifyServiceReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    void setAttrMap(Map map) {
        this.serviceAttrMap = map;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription110") + " " + this.targetDN);
        if (this.serviceAttrMap != null && !this.serviceAttrMap.isEmpty()) {
            Set set = this.serviceAttrMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printWriter.println("  " + string + " =");
                Set set2 = (Set)this.serviceAttrMap.get(string);
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    printWriter.println("    " + string2);
                }
            }
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("realm") + "\n" + AdminReq.bundle.getString("realmModifySvc") + " " + this.serviceName + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
        String[] stringArray = new String[]{this.serviceName, this.realmPath};
        try {
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, this.realmPath);
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            AMIdentity aMIdentity = aMIdentityRepository.getRealmIdentity();
            Set set = organizationConfigManager.getAssignedServices(true);
            Set set2 = aMIdentity.getAssignedServices();
            boolean bl = true;
            if (set.contains(this.serviceName)) {
                this.doLog(stringArray, "MODIFY_SERVICE_ORGCONFIG_ATTEMPT");
                organizationConfigManager.modifyService(this.serviceName, this.serviceAttrMap);
                this.doLog(stringArray, "MODIFY_SERVICE_ORGCONFIG");
                bl = false;
            }
            if (set2.contains(this.serviceName)) {
                this.doLog(stringArray, "MODIFY_SERVICE_REALM_ATTEMPT");
                aMIdentity.modifyService(this.serviceName, this.serviceAttrMap);
                this.doLog(stringArray, "MODIFY_SERVICE_REALM");
                bl = false;
            }
            if (bl) {
                this.doLog(stringArray, "MODIFY_SERVICE_NOTIN_ORGCONFIG_OR_REALM");
            }
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

