/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;

class RealmGetSvcAttributesReq
extends AdminReq {
    private String serviceName = null;
    private String realmPath = null;

    RealmGetSvcAttributesReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription108") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("realm") + "\n" + AdminReq.bundle.getString("realmSvcAttributes") + " " + this.serviceName + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN + ", " + AdminReq.bundle.getString("orgAttributes"));
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        try {
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, this.realmPath);
            Map map = null;
            Set set = organizationConfigManager.getAssignedServices(true);
            if (set.contains(this.serviceName)) {
                map = organizationConfigManager.getServiceAttributes(this.serviceName);
                if (map != null) {
                    printUtils.printAVPairs(map, 1);
                } else {
                    AdminReq.writer.println(" " + AdminReq.bundle.getString("none"));
                }
            }
            AdminReq.writer.println(AdminReq.bundle.getString("realmSvcAttributes") + " " + this.serviceName + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN + ", " + AdminReq.bundle.getString("dynamicAttributes"));
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            AMIdentity aMIdentity = aMIdentityRepository.getRealmIdentity();
            Set set2 = aMIdentity.getAssignedServices();
            if (set2.contains(this.serviceName)) {
                map = aMIdentity.getServiceAttributes(this.serviceName);
                if (map != null) {
                    printUtils.printAVPairs(map, 1);
                } else {
                    AdminReq.writer.println(" " + AdminReq.bundle.getString("none"));
                }
            }
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

