/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class RealmCreateRealmReq
extends AdminReq {
    private Map realmSvcMap = new HashMap();
    private String parentRealm = null;
    private String childRealm = null;

    RealmCreateRealmReq(String string) {
        super(string);
    }

    void setParentRealm(String string) {
        this.parentRealm = string;
    }

    void setSubRealm(String string) {
        this.childRealm = string;
    }

    void createRealmReq(String string, Map map) {
        this.realmSvcMap.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription101") + " " + this.targetDN);
        if (!this.realmSvcMap.isEmpty()) {
            AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.realmSvcMap);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("realm") + "\n" + AdminReq.bundle.getString("createRealm") + " " + this.childRealm + " " + AdminReq.bundle.getString("inrealm") + " " + this.parentRealm);
        String[] stringArray = new String[]{this.childRealm, this.parentRealm};
        try {
            this.doLog(stringArray, "CREATE_REALM_ATTEMPT");
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, this.parentRealm);
            Set set = organizationConfigManager.getSubOrganizationNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.childRealm.equals(string)) continue;
                throw new AdminException(AdminReq.bundle.getString("realmExists") + " " + this.targetDN);
            }
            organizationConfigManager.createSubOrganization(this.childRealm, this.realmSvcMap);
            this.doLog(stringArray, "CREATE_REALM");
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
    }
}

