/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class RealmAssignServiceReq
extends AdminReq {
    private Map assignSvcMap = new HashMap();
    private String realmPath = null;

    RealmAssignServiceReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void createAssignSvcReq(String string, Map map) {
        this.assignSvcMap.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription105") + " " + this.targetDN);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.assignSvcMap);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("realm") + "\n" + AdminReq.bundle.getString("realmAssignSvc") + " " + this.realmPath);
        try {
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, this.realmPath);
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            AMIdentity aMIdentity = aMIdentityRepository.getRealmIdentity();
            PrintUtils printUtils = new PrintUtils(AdminReq.writer);
            Set set = organizationConfigManager.getAssignableServices();
            Set set2 = aMIdentity.getAssignableServices();
            int n = this.assignSvcMap.size();
            Set set3 = this.assignSvcMap.keySet();
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String[] stringArray = new String[]{string, this.realmPath};
                Map map = (Map)this.assignSvcMap.get(string);
                if (set.contains(string)) {
                    this.doLog(stringArray, "ASSIGN_SERVICE_TO_REALM_ATTEMPT");
                    organizationConfigManager.assignService(string, map);
                    this.doLog(stringArray, "ASSIGN_SERVICE_TO_REALM");
                } else {
                    this.doLog(stringArray, "ASSIGN_SERVICE_TO_REALM_NOTINLIST");
                }
                if (set2.contains(string)) {
                    this.doLog(stringArray, "ASSIGN_SERVICE_TO_ORGCONFIG_ATTEMPT");
                    aMIdentity.assignService(string, map);
                    this.doLog(stringArray, "ASSIGN_SERVICE_TO_ORGCONFIG");
                    continue;
                }
                this.doLog(stringArray, "ASSIGN_SERVICE_TO_ORGCONFIG_NOTINLIST");
            }
            printUtils.printSet(set3, 1);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

