/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.SearchReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class PCGetSubPCReq
extends SearchReq {
    private Set subPCDNs = new HashSet();
    private String level = "SCOPE_SUB";
    private boolean DNsOnly = true;

    PCGetSubPCReq(String string) {
        super(string);
    }

    void setLevel(String string) {
        this.level = string;
    }

    String getLevel() {
        return this.level;
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    boolean isDNsOnly() {
        return this.DNsOnly;
    }

    void addSubPCDNs(String string) {
        this.subPCDNs.add(string);
    }

    Set getSubPCDNs() {
        return this.subPCDNs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription51") + " " + this.targetDN);
        printWriter.println("  level = " + this.level);
        printWriter.println("  DNsOnly = " + this.DNsOnly);
        printWriter.println("  filter = " + this.filter);
        if (this.subPCDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.subPCDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        AdminReq.writer.println(AdminReq.bundle.getString("peoplecontainer") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getpeoplecontainers"));
        try {
            int n;
            AdminReq.writer.println(this.targetDN);
            AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(this.targetDN);
            boolean bl = false;
            int n2 = n = this.level.equals("SCOPE_SUB") ? 2 : 1;
            if (this.subPCDNs.isEmpty()) {
                this.subPCDNs = aMPeopleContainer.searchSubPeopleContainers(this.filter, n);
            } else {
                bl = true;
            }
            Iterator iterator = this.subPCDNs.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMPeopleContainer aMPeopleContainer2 = aMStoreConnection.getPeopleContainer(string);
                if (bl && (!aMPeopleContainer2.isExists() || !AdminUtils.isDescendantOf(aMPeopleContainer2, this.targetDN, n))) continue;
                AdminReq.writer.println("  " + string);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMPeopleContainer.getAttributes(), 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

