/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.SearchReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;

class OrgGetSubOrgReq
extends SearchReq {
    private Set subOrgDNs = new HashSet();
    private boolean DNsOnly = true;

    OrgGetSubOrgReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    boolean isDNsOnly() {
        return this.DNsOnly;
    }

    void addSubOrgDNs(String string) {
        this.subOrgDNs.add(string);
    }

    Set getSubOrgDNs() {
        return this.subOrgDNs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription41") + " " + this.targetDN);
        printWriter.println("   DNsOnly = " + this.DNsOnly);
        printWriter.println("   filter = " + this.filter);
        printWriter.println("   sizeLimit = " + this.sizeLimit);
        printWriter.println("   timeLimit = " + this.timeLimit);
        if (this.subOrgDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.subOrgDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getsuborgs"));
        try {
            Object object;
            Object object2;
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            AdminReq.writer.println(this.targetDN);
            boolean bl = false;
            if (this.subOrgDNs.isEmpty()) {
                object2 = this.createSearchControl(2);
                object = aMOrganization.searchSubOrganizations(this.filter, (AMSearchControl)object2);
                this.subOrgDNs = ((AMSearchResults)object).getSearchResults();
                this.errorCode = ((AMSearchResults)object).getErrorCode();
            } else {
                bl = true;
            }
            object2 = this.subOrgDNs.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                AMOrganization aMOrganization2 = aMOrganization.getSubOrganization((String)object);
                if (bl && (!aMOrganization2.isExists() || !AdminUtils.isDescendantOf(aMOrganization2, this.targetDN))) continue;
                AdminReq.writer.println("  " + (String)object);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMOrganization2.getAttributes(), 2);
            }
            this.printSearchLimitError();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

