/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class OrgCreateGroupReq
extends AdminReq {
    private Map staticGroups = new HashMap();
    private Map dynamicGroups = new HashMap();
    private Map assignableDynamicGroups = new HashMap();

    OrgCreateGroupReq(String string) {
        super(string);
    }

    void addGroupReq(String string, String string2, Map map) {
        if (string2.equals("assignableDynamic")) {
            this.assignableDynamicGroups.put(string, map);
        } else if (string2.equals("dynamic")) {
            this.dynamicGroups.put(string, map);
        } else {
            this.staticGroups.put(string, map);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription26") + this.targetDN);
        if (!this.staticGroups.isEmpty()) {
            printUtils.printSet(this.staticGroups.keySet(), 1);
        }
        if (!this.dynamicGroups.isEmpty()) {
            printUtils.printSet(this.dynamicGroups.keySet(), 1);
        }
        if (!this.assignableDynamicGroups.isEmpty()) {
            printUtils.printSet(this.assignableDynamicGroups.keySet(), 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("creategroups"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("creategroups"));
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        String[] stringArray = new String[2];
        try {
            Set set;
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            AMGroupContainer aMGroupContainer = this.getDefaultGroupContainer(aMStoreConnection, aMOrganization);
            if (!this.staticGroups.isEmpty()) {
                this.doLogStringSet(this.staticGroups.keySet(), "CREATE_GROUP_ATTEMPT");
                set = aMGroupContainer.createStaticGroups(this.staticGroups.keySet());
                printUtils.printSet(this.staticGroups.keySet(), 1);
                this.doLog(set, "CREATE_GROUP");
            }
            if (!this.dynamicGroups.isEmpty()) {
                Set set2;
                set = this.dynamicGroups.keySet();
                this.doLogStringSet(set, "CREATE_GROUP_ATTEMPT");
                String string = (String)set.iterator().next();
                Map map = (Map)this.dynamicGroups.get(string);
                String string2 = null;
                if (map != null && map.get("filterinfo") != null && (set2 = (Set)map.remove("filterinfo")) != null && !set2.isEmpty()) {
                    string2 = (String)set2.iterator().next();
                }
                set2 = aMGroupContainer.createDynamicGroups(this.dynamicGroups);
                AMDynamicGroup aMDynamicGroup = (AMDynamicGroup)set2.iterator().next();
                if (string2 != null) {
                    aMDynamicGroup.setFilter(string2);
                    aMDynamicGroup.store();
                }
                printUtils.printSet(set, 1);
                this.doLog(aMDynamicGroup, "CREATE_GROUP");
            }
            if (!this.assignableDynamicGroups.isEmpty()) {
                this.doLogStringSet(this.assignableDynamicGroups.keySet(), "CREATE_GROUP_ATTEMPT");
                set = aMGroupContainer.createAssignableDynamicGroups(this.assignableDynamicGroups.keySet());
                printUtils.printSet(this.assignableDynamicGroups.keySet(), 1);
                this.doLog(set, "CREATE_GROUP");
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg21"));
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private AMGroupContainer getDefaultGroupContainer(AMStoreConnection aMStoreConnection, AMOrganization aMOrganization) throws AdminException {
        AMGroupContainer aMGroupContainer = null;
        try {
            String string = AdminInterfaceUtils.getNamingAttribute((int)4, (Debug)AdminReq.debug) + "=" + AdminInterfaceUtils.defaultGroupContainerName() + "," + aMOrganization.getDN();
            aMGroupContainer = aMStoreConnection.getGroupContainer(string);
            if (aMGroupContainer == null || !aMGroupContainer.isExists()) {
                Object[] objectArray = new String[]{string};
                String string2 = MessageFormat.format(AdminReq.bundle.getString("defaultGroupContainerNoFound"), objectArray);
                throw new AdminException(string2);
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return aMGroupContainer;
    }
}

