/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.EntityUtils;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class OrgCreateEntityReq
extends AdminReq {
    private Map entityReq = new HashMap();
    private String entityType = null;
    private SSOToken ssoToken;

    OrgCreateEntityReq(String string, SSOToken sSOToken) {
        super(string);
        this.ssoToken = sSOToken;
    }

    void addRequest(String string, Map map) {
        this.entityReq.put(string, map);
    }

    void setEntityType(String string) {
        this.entityType = string;
    }

    public String toString(AMStoreConnection aMStoreConnection) {
        EntityUtils entityUtils = new EntityUtils();
        Map map = entityUtils.getEntityTypesMap(aMStoreConnection);
        AMEntityType aMEntityType = (AMEntityType)map.get(this.entityType);
        if (aMEntityType == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription87") + " " + this.targetDN);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.ssoToken, this.entityReq, aMEntityType.getServiceName(), null);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        EntityUtils entityUtils = new EntityUtils();
        Map map = entityUtils.getEntityTypesMap(aMStoreConnection);
        AMEntityType aMEntityType = (AMEntityType)map.get(this.entityType);
        if (aMEntityType == null) {
            throw new AdminException(AdminReq.bundle.getString("invalidEntity"));
        }
        String string = entityUtils.getL10NAttributeName(aMStoreConnection, aMEntityType.getServiceName(), "entity-name-description");
        Object[] objectArray = new String[]{string};
        String string2 = MessageFormat.format(AdminReq.bundle.getString("createEntity"), objectArray);
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + string2);
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            this.doLogStringSet(this.entityReq.keySet(), "CREATE_ENTITY_ATTEMPT");
            Set set = aMOrganization.createEntities(aMEntityType.getType(), this.entityReq);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg45"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMEntity aMEntity = (AMEntity)iterator.next();
                AdminReq.writer.println(aMEntity.getDN());
            }
            this.doLogForEntity(set, "CREATE_ENTITY", string);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

