/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminResourceBundle;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.AdminXMLParser;
import com.iplanet.am.admin.cli.ArgumentValidator;
import com.iplanet.am.admin.cli.Authenticator;
import com.iplanet.am.admin.cli.SessionRequest;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.ISResourceBundle;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.liberty.ws.meta.LibertyMetaHandler;
import com.sun.identity.liberty.ws.meta.MetaException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSMigration70;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import netscape.ldap.LDAPException;

class Main {
    static final String AUTH_CORE_SERVICE = "iPlanetAMAuthService";
    private static ResourceBundle bundle = null;
    private static final int INVALID = 0;
    private static final int RUN_AS_DN = 1;
    private static final int PASSWORD = 2;
    private static final int VERBOSE = 3;
    private static final int DEBUG = 4;
    private static final int SCHEMA = 5;
    private static final int DATA = 6;
    private static final int LOCALE_NAME = 7;
    private static final int HELP = 8;
    private static final int DELETE = 9;
    private static final int VERSION = 10;
    private static final int PASSWORDFILE = 11;
    private static final int SESSION = 12;
    private static final int CONTINUE = 13;
    private static final int IMPORT_REMOTE = 14;
    private static final int IMPORT_HOSTED = 15;
    private static final int ADD_ATTRIBUTES = 16;
    private static final int NOLOG = 17;
    private static final int LIBERTY_DATA = 18;
    private static final int ENTITY_NAME = 19;
    private static final int OUTPUT = 20;
    private static final int XML_SIG = 21;
    private static final int VERIFY_SIG = 22;
    private static final int DEFAULT_URL_PREFIX = 23;
    private static final int META_ALIAS = 24;
    private static final int ADD_RESOURCE_BUNDLE = 25;
    private static final int RESOURCE_BUNDLE_FILE = 26;
    private static final int GET_RESOURCE_STRING = 27;
    private static final int DELETE_RESOURCE_BUNDLE = 28;
    private static final int RESOURCE_LOCALE = 29;
    private static final int DELETE_POLICY_RULE = 30;
    private static final int MIGRATE70TOREALMS = 31;
    private static final int OUTPUTFILENAME = 32;
    private static Map arguments = new HashMap();
    private List infileNames = Collections.synchronizedList(new ArrayList());
    private String outfileName;
    private static String bindDN = null;
    private static String bindPW = null;
    private String passwordfile = null;
    private String localeName = null;
    private static String inUserId = null;
    private String smUserId = null;
    private int operation = 0;
    private int comptype;
    private int debugFlg = 0;
    private int verboseFlg = 0;
    private boolean continueFlag = false;
    private AMStoreConnection connec = null;
    private SSOToken ssot;
    private String entityName = null;
    private String serverName = null;
    private String defaultUrlPrefix;
    private String addServiceName = null;
    private String addSchemaType = null;
    private boolean xmlSig = false;
    private boolean verifySig = false;
    private String metaPrefix = null;
    private List metaAlias = Collections.synchronizedList(new ArrayList());
    String sprotocol;
    String _sserver;
    String sserver;
    String sport;
    private String resourceBundleName;
    private String resourceFileName;
    private String resourceLocale;
    private int deletePolicyRuleFlg = 0;
    private Map sessionStoreInfo = null;
    private String entryDN;
    private String outputFileName = null;
    private String libertyDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
    private static boolean isInstallTime;

    Main() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromPassword(String var1_1) throws AdminException {
        var2_2 = null;
        var3_3 = null;
        try {
            try {
                var3_3 = new BufferedReader(new FileReader(var1_1));
                if (var3_3.ready()) {
                    var2_2 = var3_3.readLine();
                }
                var4_4 = var2_2;
                var6_6 = null;
                if (var3_3 == null) return var4_4;
            }
            catch (IOException var4_5) {
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log("Could not open file " + var4_5.getMessage());
                }
                var6_7 = null;
                if (var3_3 == null) return null;
                try {
                    var3_3.close();
                    return null;
                }
                catch (Exception var7_10) {
                    if (AdminUtils.logEnabled() == false) return null;
                    AdminUtils.log("Unable to close the file: " + var7_10.getMessage());
                    return null;
                }
            }
        }
        catch (Throwable var5_12) {
            var6_8 = null;
            if (var3_3 == null) throw var5_12;
            ** try [egrp 2[TRYBLOCK] [2 : 95->102)] { 
lbl31:
            // 1 sources

            var3_3.close();
            throw var5_12;
lbl33:
            // 1 sources

            catch (Exception var7_11) {
                if (AdminUtils.logEnabled() == false) throw var5_12;
                AdminUtils.log("Unable to close the file: " + var7_11.getMessage());
            }
            throw var5_12;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 95->102)] { 
lbl39:
        // 1 sources

        var3_3.close();
        return var4_4;
lbl41:
        // 1 sources

        catch (Exception var7_9) {
            if (AdminUtils.logEnabled() == false) return var4_4;
            AdminUtils.log("Unable to close the file: " + var7_9.getMessage());
        }
        return var4_4;
    }

    private void parseCommandLine(String[] stringArray) throws AdminException {
        if (!ArgumentValidator.validateArguments(stringArray, bundle)) {
            System.err.println(bundle.getString("usage"));
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.getToken(stringArray[n]);
            block0 : switch (n2) {
                case 14: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    int n3 = n;
                    while (n3 < stringArray.length) {
                        this.infileNames.add(stringArray[n3]);
                        ++n3;
                        ++n;
                    }
                    break;
                }
                case 15: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.defaultUrlPrefix = stringArray[n];
                    int n4 = ++n;
                    while (n4 < stringArray.length) {
                        this.infileNames.add(stringArray[n4]);
                        ++n4;
                        ++n;
                    }
                    break;
                }
                case 12: {
                    this.operation = n2;
                    if (++n >= stringArray.length || arguments.containsKey(stringArray[n].toString())) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.serverName = stringArray[n] == null ? "*" : stringArray[n];
                    this.smUserId = ++n >= stringArray.length ? "*" : stringArray[n];
                    break;
                }
                case 1: {
                    String string;
                    String string2;
                    StringTokenizer stringTokenizer;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if ((this.comptype = this.getToken((bindDN = stringArray[n]).toLowerCase())) != 0) {
                        throw new AdminException(bundle.getString("nodnforadmin"));
                    }
                    Object object = new StringTokenizer(bindDN, ",");
                    if (!((StringTokenizer)object).hasMoreTokens() || !(stringTokenizer = new StringTokenizer(string2 = ((StringTokenizer)object).nextToken(), "=")).hasMoreTokens() || !(string = stringTokenizer.nextToken()).equals("uid") || !stringTokenizer.hasMoreTokens()) break;
                    inUserId = stringTokenizer.nextToken();
                    break;
                }
                case 2: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if ((this.comptype = this.getToken((bindPW = stringArray[n]).toLowerCase())) == 0) break;
                    throw new AdminException(bundle.getString("nopwdforadmin"));
                }
                case 11: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.passwordfile = stringArray[n];
                    bindPW = this.readFromPassword(this.passwordfile);
                    if (bindPW == null || (this.comptype = this.getToken(bindPW.toLowerCase())) != 0) {
                        throw new AdminException(bundle.getString("nopwdforadmin"));
                    }
                    bindPW = bindPW.trim();
                    break;
                }
                case 19: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.entityName = stringArray[n];
                    this.comptype = this.getToken(this.entityName.toLowerCase());
                    if (this.comptype == 0) break;
                    throw new AdminException(bundle.getString("noentityname"));
                }
                case 5: 
                case 6: 
                case 18: {
                    Object object;
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if (!((String)(object = stringArray[n].toLowerCase())).endsWith(".xml")) {
                        throw new AdminException(bundle.getString("nofile"));
                    }
                    int n5 = n;
                    while (n5 < stringArray.length) {
                        object = stringArray[n5].toLowerCase();
                        if (((String)object).endsWith(".xml")) {
                            this.infileNames.add(stringArray[n5]);
                            n += n5;
                        } else {
                            n = n5 - 1;
                            break block0;
                        }
                        ++n5;
                    }
                    break;
                }
                case 22: {
                    this.verifySig = true;
                    break;
                }
                case 21: {
                    this.xmlSig = true;
                    break;
                }
                case 23: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.metaPrefix = stringArray[n];
                    this.comptype = this.getToken(this.metaPrefix.toLowerCase());
                    if (this.comptype == 0) break;
                    throw new AdminException(bundle.getString("nodefaulturlprefix"));
                }
                case 24: {
                    int n6 = n++;
                    if (n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    int n7 = n;
                    while (n7 < stringArray.length) {
                        this.comptype = this.getToken(stringArray[n7].toLowerCase());
                        if (this.comptype != 0) {
                            --n;
                            break;
                        }
                        this.metaAlias.add(stringArray[n7]);
                        ++n7;
                        ++n;
                    }
                    if (n6 != n) break;
                    throw new AdminException(bundle.getString("nometaalias"));
                }
                case 20: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.outfileName = stringArray[n];
                    this.comptype = this.getToken(this.outfileName.toLowerCase());
                    if (this.comptype == 0) break;
                    throw new AdminException(bundle.getString("nooutfilename"));
                }
                case 7: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.localeName = stringArray[n];
                    if (this.localeName == null || (this.comptype = this.getToken(this.localeName.toLowerCase())) != 0) {
                        throw new AdminException(bundle.getString("nolocalename"));
                    }
                    if (this.debugFlg == 1) {
                        AdminResourceBundle.setLocale("en_US");
                        bundle = AdminResourceBundle.getResources();
                        break;
                    }
                    AdminResourceBundle.setLocale(this.localeName);
                    bundle = AdminResourceBundle.getResources();
                    break;
                }
                case 4: {
                    this.debugFlg = 1;
                    if (this.verboseFlg == 1) {
                        System.out.println(bundle.getString("dbgerror") + " --verbose|--debug");
                        System.exit(1);
                        break;
                    }
                    AdminUtils.setDebug(AdminReq.debug);
                    AdminUtils.setDebugStatus(3);
                    AdminUtils.enableDebug(true);
                    AdminResourceBundle.setLocale("en_US");
                    bundle = AdminResourceBundle.getResources();
                    break;
                }
                case 17: {
                    AdminUtils.setLog(false);
                    break;
                }
                case 3: {
                    this.verboseFlg = 1;
                    if (this.debugFlg == 1) {
                        System.out.println(bundle.getString("dbgerror") + " --verbose|--debug");
                        System.exit(1);
                        break;
                    }
                    AdminUtils.setDebug(AdminReq.debug);
                    AdminUtils.setDebugStatus(4);
                    AdminUtils.enableVerbose(true);
                    break;
                }
                case 8: {
                    this.printHelp();
                    System.exit(0);
                    break;
                }
                case 10: {
                    this.printVersion();
                    System.exit(0);
                    break;
                }
                case 13: {
                    this.continueFlag = true;
                    break;
                }
                case 9: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if (stringArray[n] == null || arguments.containsKey(stringArray[n].toString())) {
                        throw new AdminException(bundle.getString("noservicename"));
                    }
                    int n8 = n;
                    while (n8 < stringArray.length) {
                        this.infileNames.add(stringArray[n8]);
                        ++n;
                        if (arguments.containsKey(stringArray[n8].toString())) {
                            n = n8 - 1;
                            this.infileNames.remove(stringArray[n8]);
                            break block0;
                        }
                        ++n8;
                    }
                    break;
                }
                case 16: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.addServiceName = stringArray[n];
                    this.addSchemaType = stringArray[++n];
                    int n9 = ++n;
                    while (n9 < stringArray.length) {
                        this.infileNames.add(stringArray[n9]);
                        ++n9;
                        ++n;
                    }
                    break;
                }
                case 25: 
                case 27: 
                case 28: {
                    if (++n >= stringArray.length || this.operation != 0) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.operation = n2;
                    this.resourceBundleName = stringArray[n];
                    break;
                }
                case 26: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.resourceFileName = stringArray[n];
                    break;
                }
                case 29: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.resourceLocale = stringArray[n];
                    break;
                }
                case 30: {
                    this.deletePolicyRuleFlg = 1;
                    break;
                }
                case 31: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.operation = n2;
                    this.entryDN = stringArray[n];
                    break;
                }
                case 32: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.outputFileName = stringArray[n];
                    break;
                }
                default: {
                    AdminUtils.setDebug(AdminReq.debug);
                    AdminUtils.setDebugStatus(0);
                    System.err.println(bundle.getString("usage"));
                    System.err.println(bundle.getString("invopt") + stringArray[n]);
                    System.exit(1);
                }
            }
            ++n;
        }
        if (bindDN == null || bindPW == null) {
            AdminUtils.setDebug(AdminReq.debug);
            AdminUtils.setDebugStatus(0);
            System.err.println(bundle.getString("usage"));
            System.exit(1);
        }
    }

    private void runCommand() throws AdminException, LDAPException {
        if (this.operation != 12) {
            Authenticator authenticator = new Authenticator(bundle);
            authenticator.ldapLogin(bindDN, bindPW);
            this.ssot = authenticator.getSSOToken();
        }
        switch (this.operation) {
            case 14: {
                this.processImportRemoteRequests();
                break;
            }
            case 15: {
                this.processImportHostedRequests();
                break;
            }
            case 6: {
                this.processDataRequests();
                break;
            }
            case 5: {
                this.processSchemaRequests();
                break;
            }
            case 9: {
                this.processDeleteRequests();
                break;
            }
            case 12: {
                this.processSessionRequest();
                break;
            }
            case 16: {
                this.processAddAttributesRequests();
                break;
            }
            case 18: {
                this.processLibertyDataRequests();
                break;
            }
            case 20: {
                this.outputLibertyData();
                break;
            }
            case 25: {
                this.addResourceBundle();
                break;
            }
            case 27: {
                this.getResourceStrings();
                break;
            }
            case 28: {
                this.deleteResourceBundle();
                break;
            }
            case 31: {
                this.migrate70ToRealms();
                break;
            }
            default: {
                AdminUtils.setDebug(AdminReq.debug);
                AdminUtils.setDebugStatus(0);
                System.err.println(bundle.getString("nodataschemawarning"));
                System.err.println(bundle.getString("usage"));
                System.exit(1);
            }
        }
    }

    private void processSessionRequest() throws AdminException {
        Authenticator authenticator = new Authenticator(bundle);
        String string = inUserId != null ? inUserId : bindDN;
        AuthContext authContext = authenticator.sessionBasedLogin(string, bindPW);
        SSOToken sSOToken = authenticator.getSSOToken();
        AdminUtils.setSSOToken(sSOToken);
        SessionRequest sessionRequest = new SessionRequest(sSOToken, this.serverName, bundle);
        sessionRequest.displaySessions(this.smUserId);
        try {
            authContext.logout();
        }
        catch (AuthLoginException authLoginException) {
            this.handleRunCommandException(authLoginException);
        }
    }

    private void processImportRemoteRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg1"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg2") + string);
            }
            try {
                this.convertImportMetaData(string, this.ssot, "remote", null);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processImportHostedRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg1"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg2") + string);
            }
            try {
                this.convertImportMetaData(string, this.ssot, "hosted", this.defaultUrlPrefix);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processDataRequests() throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg1"));
        }
        try {
            this.connec = new AMStoreConnection(this.ssot);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg2") + string);
            }
            try {
                this.processDataRequests(string, this.connec, this.ssot, this.continueFlag);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processLibertyDataRequests() throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg1"));
        }
        if (this.infileNames == null || this.infileNames.isEmpty()) {
            throw new AdminException(bundle.getString("missingLibertyMetaInputFile"));
        }
        LibertyMetaHandler libertyMetaHandler = this.getLibertyMetaHandler();
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg2") + string);
            }
            try {
                libertyMetaHandler.metaToSM(string, this.verifySig, this.metaPrefix, this.metaAlias);
            }
            catch (MetaException metaException) {
                throw new AdminException(bundle.getString("failLoadLibertyMeta") + metaException.getMessage());
            }
        }
    }

    private void outputLibertyData() throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg40") + this.outfileName);
        }
        if (this.entityName == null) {
            throw new AdminException(bundle.getString("missingEntityName"));
        }
        if (this.outfileName == null) {
            throw new AdminException(bundle.getString("missingLibertyMetaOutputFile"));
        }
        LibertyMetaHandler libertyMetaHandler = this.getLibertyMetaHandler();
        try {
            libertyMetaHandler.SMToMeta(this.entityName, this.xmlSig, this.outfileName);
        }
        catch (MetaException metaException) {
            throw new AdminException(metaException);
        }
    }

    private LibertyMetaHandler getLibertyMetaHandler() throws AdminException {
        LibertyMetaHandler libertyMetaHandler = null;
        try {
            libertyMetaHandler = new LibertyMetaHandler(this.ssot, this.libertyDN);
            if (libertyMetaHandler == null) {
                throw new AdminException(bundle.getString("cannotObtainMetaHandler"));
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        return libertyMetaHandler;
    }

    private void processSchemaRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg3"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg4") + string);
            }
            try {
                Set set = this.registerServiceSchema(string);
                if (set == null || set.isEmpty()) continue;
                String[] stringArray = new String[]{(String)set.iterator().next()};
                AdminUtils.logOperation(0, Level.INFO, "LOAD_SERVICE", stringArray);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processDeleteRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg28"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg29") + string);
            }
            try {
                this.processDeleteService(string);
                String[] stringArray = new String[]{string};
                AdminUtils.logOperation(0, Level.INFO, "DELETE_SERVICE", stringArray);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processAddAttributesRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg34"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg35") + string);
            }
            try {
                this.processAddAttributes(this.addServiceName, this.addSchemaType, string);
                String[] stringArray = new String[]{string};
                AdminUtils.logOperation(0, Level.INFO, "ADD_ATTRS", stringArray);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void handleRunCommandException(Exception exception) {
        System.err.println(bundle.getString("execfailed") + "\n" + exception.getLocalizedMessage());
        if (AdminUtils.logEnabled() && this.debugFlg == 1) {
            AdminUtils.log(bundle.getString("execfailed"), exception);
        }
        AdminUtils.logOperation(1, bundle.getString("execfailed") + " " + exception);
        if (!this.continueFlag) {
            System.exit(1);
        }
    }

    void printVersion() {
        System.out.println();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("AMConfig");
        Object[] objectArray = new String[]{resourceBundle.getString("com.iplanet.am.version")};
        System.out.println(MessageFormat.format(bundle.getString("version"), objectArray));
        System.out.println();
    }

    void printHelp() {
        System.out.println(bundle.getString("usage"));
    }

    void processDataRequests(String string, AMStoreConnection aMStoreConnection, SSOToken sSOToken, boolean bl) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("processingDataXML") + " " + string);
            AdminUtils.log(bundle.getString("statusmsg5"));
        }
        AdminXMLParser adminXMLParser = new AdminXMLParser();
        adminXMLParser.processAdminReqs(string, aMStoreConnection, sSOToken, bl, this.outputFileName);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("doneProcessingXML") + " " + string);
        }
    }

    void convertImportMetaData(String string, SSOToken sSOToken, String string2, String string3) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("processingDataXML") + " " + string);
            AdminUtils.log(bundle.getString("statusmsg5"));
        }
        AdminXMLParser adminXMLParser = new AdminXMLParser();
        adminXMLParser.processLibertyMetaData(string, sSOToken, string2, string3);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("doneProcessingXML") + " " + string);
        }
    }

    public static void main(String[] stringArray) throws AdminException {
        String string = System.getProperty("installTime");
        if (string != null && string.length() > 0) {
            isInstallTime = string.toLowerCase().startsWith("true");
        }
        if (isInstallTime) {
            SystemProperties.initializeProperties((String)"com.sun.identity.security.amadmin", (String)"true");
        }
        AdminResourceBundle.setLocale(null);
        bundle = AdminResourceBundle.getResources();
        Crypt.checkCaller();
        Main main = new Main();
        try {
            main.parseCommandLine(stringArray);
            main.runCommand();
            System.out.println(bundle.getString("successful"));
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println(bundle.getString("oprfailed") + " " + exception.getLocalizedMessage());
            System.exit(1);
        }
    }

    int getToken(String string) {
        try {
            return (Integer)arguments.get(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Set registerServiceSchema(String string) throws AdminException {
        FileInputStream fileInputStream;
        Set set;
        block11: {
            set = Collections.EMPTY_SET;
            if (AdminUtils.logEnabled()) {
                AdminUtils.log("\n" + bundle.getString("loadingServiceSchema") + " " + string);
            }
            System.out.println(bundle.getString("loadServiceSchema") + " " + string);
            fileInputStream = null;
            ServiceManager serviceManager = new ServiceManager(this.ssot);
            fileInputStream = new FileInputStream(string);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg12") + string);
            }
            set = serviceManager.registerServices(fileInputStream);
            if (!AdminUtils.logEnabled()) break block11;
            AdminUtils.log(bundle.getString("doneLoadingServiceSchema") + " " + set.toString());
        }
        Object var8_6 = null;
        if (fileInputStream == null) return set;
        try {
            fileInputStream.close();
            return set;
        }
        catch (IOException iOException) {
            if (!AdminUtils.logEnabled()) return set;
            AdminUtils.log(bundle.getString("statusmsg15"), iOException);
        }
        return set;
        {
            catch (IOException iOException) {
                if (!AdminUtils.logEnabled()) throw new AdminException(bundle.getString("file"));
                AdminUtils.log(bundle.getString("file"), iOException);
                throw new AdminException(bundle.getString("file"));
            }
            catch (SSOException sSOException) {
                if (!AdminUtils.logEnabled()) throw new AdminException(sSOException);
                AdminUtils.log(bundle.getString("statusmsg13"), sSOException);
                throw new AdminException(sSOException);
            }
            catch (SMSException sMSException) {
                if (!AdminUtils.logEnabled()) throw new AdminException(sMSException);
                AdminUtils.log(bundle.getString("statusmsg14"), sMSException);
                throw new AdminException(sMSException);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                if (!AdminUtils.logEnabled()) throw throwable;
                AdminUtils.log(bundle.getString("statusmsg15"), iOException);
            }
            throw throwable;
        }
    }

    void processAddAttributes(String string, String string2, String string3) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("\n" + bundle.getString("addAttributes") + " " + string + " " + string2);
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.ssot);
            ServiceSchema serviceSchema = null;
            FileInputStream fileInputStream = null;
            if (string2.equalsIgnoreCase("global")) {
                serviceSchema = serviceSchemaManager.getGlobalSchema();
            } else if (string2.equalsIgnoreCase("organization")) {
                serviceSchema = serviceSchemaManager.getOrganizationSchema();
            } else if (string2.equalsIgnoreCase("dynamic")) {
                serviceSchema = serviceSchemaManager.getDynamicSchema();
            } else if (string2.equalsIgnoreCase("user")) {
                serviceSchema = serviceSchemaManager.getUserSchema();
            } else if (string2.equalsIgnoreCase("policy")) {
                serviceSchema = serviceSchemaManager.getPolicySchema();
            }
            fileInputStream = new FileInputStream(string3);
            serviceSchema.addAttributeSchema(fileInputStream);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("doneAddingAttributes") + " " + string);
            }
        }
        catch (IOException iOException) {
            if (AdminUtils.logEnabled() && this.debugFlg == 1) {
                AdminUtils.log(bundle.getString("file"), iOException);
            }
            throw new AdminException(bundle.getString("file"));
        }
        catch (SSOException sSOException) {
            if (AdminUtils.logEnabled() && this.debugFlg == 1) {
                AdminUtils.log(bundle.getString("statusmsg13"), sSOException);
            }
            throw new AdminException("\n" + bundle.getString("smsdelexception") + "\n\n" + sSOException.getLocalizedMessage() + "\n");
        }
        catch (SMSException sMSException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg14"), sMSException);
            }
            throw new AdminException("\n" + bundle.getString("smsdelexception") + "\n\n" + sMSException.getLocalizedMessage() + "\n");
        }
    }

    void processDeleteService(String string) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("\n" + bundle.getString("deletingService") + " " + string);
        }
        System.out.println(bundle.getString("deleteServiceSchema") + " " + string);
        try {
            String[] stringArray;
            Object object;
            ServiceManager serviceManager = new ServiceManager(this.ssot);
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string, this.ssot);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg12") + string);
            }
            if (this.deletePolicyRuleFlg == 1) {
                object = new ServiceSchemaManager(string, this.ssot);
                if (object == null) {
                    if (AdminUtils.logEnabled() && this.debugFlg == 1) {
                        stringArray = new String[]{string};
                        AdminUtils.logOperation(0, Level.INFO, "NO_POLICY_PRIVS", stringArray);
                    }
                } else if (((ServiceSchemaManager)object).getPolicySchema() == null) {
                    if (AdminUtils.logEnabled() && this.debugFlg == 1) {
                        stringArray = new String[]{string};
                        AdminUtils.logOperation(0, Level.INFO, "SVC_NOT_FOUND", stringArray);
                    }
                } else {
                    this.processCleanPolicies(string);
                }
            }
            if (serviceConfigManager.getGlobalConfig(null) != null) {
                serviceConfigManager.removeGlobalConfiguration(null);
            }
            if (string.equalsIgnoreCase(AUTH_CORE_SERVICE)) {
                serviceManager.deleteService(string);
            } else {
                object = serviceManager.getServiceVersions(string);
                stringArray = object.iterator();
                while (stringArray.hasNext()) {
                    serviceManager.removeService(string, (String)stringArray.next());
                }
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("doneDeletingService") + " " + string);
            }
        }
        catch (SSOException sSOException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg13"), sSOException);
            }
            throw new AdminException(sSOException);
        }
        catch (SMSException sMSException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg14"), sMSException);
            }
            throw new AdminException(sMSException);
        }
    }

    private void processCleanPolicies(String string) throws AdminException {
        String[] stringArray;
        if (AdminUtils.logEnabled()) {
            stringArray = new String[]{string};
            AdminUtils.logOperation(0, Level.INFO, "START_DELETING_POLICIES", stringArray);
        }
        try {
            PolicyUtils.removePolicyRules(this.ssot, string);
            if (AdminUtils.logEnabled()) {
                stringArray = new String[]{string};
                AdminUtils.logOperation(0, Level.INFO, "DONE_DELETING_POLICIES", stringArray);
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
    }

    private void addResourceBundle() throws AdminException {
        if (this.resourceBundleName == null || this.resourceBundleName.length() == 0) {
            throw new AdminException(bundle.getString("missingResourceBundleName"));
        }
        if (this.resourceFileName == null || this.resourceFileName.length() == 0) {
            throw new AdminException(bundle.getString("missingResourceFileName"));
        }
        try {
            Object[] objectArray;
            Map map = this.getResourceStringsMap(this.resourceFileName);
            ISResourceBundle.storeResourceBundle((SSOToken)this.ssot, (String)this.resourceBundleName, (String)this.resourceLocale, (Map)map);
            String string = null;
            String string2 = null;
            if (this.resourceLocale != null) {
                objectArray = new String[]{this.resourceBundleName, this.resourceLocale};
                string2 = MessageFormat.format(bundle.getString("add-resource-bundle-to-directory-server"), objectArray);
                string = "ADD_RESOURCE_BUNDLE_TO_DIRECTORY_SERVER";
            } else {
                objectArray = new String[]{this.resourceBundleName};
                string2 = MessageFormat.format(bundle.getString("add-default-resource-bundle-to-directory-server"), objectArray);
                string = "ADD_DEFAULT_RESOURCE_BUNDLE_TO_DIRECTORY_SERVER";
            }
            AdminUtils.logOperation(0, Level.INFO, string, (String[])objectArray);
            System.out.println(string2);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getResourceStringsMap(String string) throws AdminException {
        HashMap hashMap = new HashMap();
        BufferedReader bufferedReader = null;
        try {
            try {
                int n = 0;
                bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    String string3;
                    int n2;
                    if ((string2 = string2.trim()).startsWith("/*")) {
                        ++n;
                    } else if (string2.endsWith("*/")) {
                        --n;
                    } else if (!string2.startsWith("#") && n == 0 && (n2 = string2.indexOf(61)) != -1 && (string3 = string2.substring(0, n2).trim()).length() > 0) {
                        HashSet<String> hashSet = new HashSet<String>(2);
                        String string4 = string2.substring(n2 + 1).trim();
                        hashSet.add(string4);
                        hashMap.put(string3, hashSet);
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                throw new AdminException(iOException);
            }
            Object var11_11 = null;
            if (bufferedReader == null) return hashMap;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new AdminException(iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new AdminException(iOException);
        }
        bufferedReader.close();
        return hashMap;
    }

    private void getResourceStrings() throws AdminException {
        if (this.resourceBundleName == null || this.resourceBundleName.length() == 0) {
            throw new AdminException(bundle.getString("missingResourceBundleName"));
        }
        try {
            ResourceBundle resourceBundle = ISResourceBundle.getResourceBundle((SSOToken)this.ssot, (String)this.resourceBundleName, (String)this.resourceLocale);
            if (resourceBundle != null) {
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    String string2 = resourceBundle.getString(string);
                    System.out.println(string + "=" + string2);
                }
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        catch (MissingResourceException missingResourceException) {
            throw new AdminException(missingResourceException);
        }
    }

    private void deleteResourceBundle() throws AdminException {
        if (this.resourceBundleName == null || this.resourceBundleName.length() == 0) {
            throw new AdminException(bundle.getString("missingResourceBundleName"));
        }
        try {
            Object[] objectArray;
            ISResourceBundle.deleteResourceBundle((SSOToken)this.ssot, (String)this.resourceBundleName, (String)this.resourceLocale);
            String string = null;
            String string2 = null;
            if (this.resourceLocale != null) {
                objectArray = new String[]{this.resourceBundleName, this.resourceLocale};
                string2 = MessageFormat.format(bundle.getString("delete-resource-bundle-from-directory-server"), objectArray);
                string = "DELETE_RESOURCE_BUNDLE_FROM_DIRECTORY_SERVER";
            } else {
                objectArray = new String[]{this.resourceBundleName};
                string2 = MessageFormat.format(bundle.getString("delete-default-resource-bundle-from-directory-server"), objectArray);
                string = "DELETE_DEFAULT_RESOURCE_BUNDLE_FROM_DIRECTORY_SERVER";
            }
            AdminUtils.logOperation(0, Level.INFO, string, (String[])objectArray);
            System.out.println(string);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private void migrate70ToRealms() throws AdminException {
        try {
            SMSMigration70.migrate63To70(this.ssot, this.entryDN);
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    static {
        arguments.put("--debug", new Integer(4));
        arguments.put("-d", new Integer(4));
        arguments.put("--verbose", new Integer(3));
        arguments.put("-v", new Integer(3));
        arguments.put("--nolog", new Integer(17));
        arguments.put("-O", new Integer(17));
        arguments.put("--schema", new Integer(5));
        arguments.put("-s", new Integer(5));
        arguments.put("--data", new Integer(6));
        arguments.put("-t", new Integer(6));
        arguments.put("--runasdn", new Integer(1));
        arguments.put("-u", new Integer(1));
        arguments.put("--password", new Integer(2));
        arguments.put("-w", new Integer(2));
        arguments.put("--passwordfile", new Integer(11));
        arguments.put("-f", new Integer(11));
        arguments.put("--locale", new Integer(7));
        arguments.put("-l", new Integer(7));
        arguments.put("--help", new Integer(8));
        arguments.put("-h", new Integer(8));
        arguments.put("--deleteservice", new Integer(9));
        arguments.put("-r", new Integer(9));
        arguments.put("--version", new Integer(10));
        arguments.put("-n", new Integer(10));
        arguments.put("--session", new Integer(12));
        arguments.put("-m", new Integer(12));
        arguments.put("--continue", new Integer(13));
        arguments.put("-c", new Integer(13));
        arguments.put("--importRemote", new Integer(14));
        arguments.put("-I", new Integer(14));
        arguments.put("--importHosted", new Integer(15));
        arguments.put("-p", new Integer(15));
        arguments.put("--addAttribute", new Integer(16));
        arguments.put("-a", new Integer(16));
        arguments.put("--import", new Integer(18));
        arguments.put("-g", new Integer(18));
        arguments.put("--entityname", new Integer(19));
        arguments.put("-e", new Integer(19));
        arguments.put("--verifysig", new Integer(22));
        arguments.put("-y", new Integer(22));
        arguments.put("--export", new Integer(20));
        arguments.put("-o", new Integer(20));
        arguments.put("--xmlsig", new Integer(21));
        arguments.put("-x", new Integer(21));
        arguments.put("--defaulturlprefix", new Integer(23));
        arguments.put("-k", new Integer(23));
        arguments.put("--metaalias", new Integer(24));
        arguments.put("-q", new Integer(24));
        arguments.put("--addresourcebundle", new Integer(25));
        arguments.put("-b", new Integer(25));
        arguments.put("--resourcebundlefilename", new Integer(26));
        arguments.put("-i", new Integer(26));
        arguments.put("--resourcelocale", new Integer(29));
        arguments.put("-R", new Integer(29));
        arguments.put("--getresourcestrings", new Integer(27));
        arguments.put("-z", new Integer(27));
        arguments.put("--deleteresourcebundle", new Integer(28));
        arguments.put("-j", new Integer(28));
        arguments.put("-C", new Integer(30));
        arguments.put("--cleanpolicyrules", new Integer(30));
        arguments.put("-M", new Integer(31));
        arguments.put("--migrate70torealms", new Integer(31));
        arguments.put("-ofilename", new Integer(32));
        arguments.put("--ofilename", new Integer(32));
        arguments.put("-F", new Integer(32));
    }
}

