/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdUnassignServiceReq
extends AdminReq {
    private String serviceName = null;
    private String realmPath = null;
    private String idName = null;
    private IdType idType;

    IdUnassignServiceReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription131") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("rmServiceId") + " " + this.serviceName + " " + AdminReq.bundle.getString("fromIdentity") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
        String[] stringArray = new String[]{this.serviceName, this.idType.toString(), this.idName, this.realmPath};
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            Set set = aMIdentityRepository.getAllowedIdOperations(this.idType);
            if (!set.contains(IdOperation.SERVICE)) {
                throw new AdminException(this.idType.toString() + " " + AdminReq.bundle.getString("doesNotSupportServices"));
            }
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            Set set2 = idSearchResults.getSearchResults();
            if (set2.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            AMIdentity aMIdentity = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity2 = (AMIdentity)iterator.next();
                if (aMIdentity != null) continue;
                aMIdentity = aMIdentity2;
            }
            if (aMIdentity == null) {
                throw new AdminException(AdminReq.bundle.getString("couldNotFind") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            this.doLog(stringArray, "UNASSIGN_SERVICE_IDENTITY_ATTEMPT");
            aMIdentity.unassignService(this.serviceName);
            this.doLog(stringArray, "UNASSIGN_SERVICE_IDENTITY");
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

