/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class IdSetAttributesReq
extends AdminReq {
    private Map attrMap = null;
    private String serviceName = null;
    private String realmPath = null;
    private String idName = null;
    private IdType idType;

    IdSetAttributesReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    void setAttrMap(Map map) {
        this.attrMap = map;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription133") + " " + this.targetDN);
        if (this.attrMap != null && !this.attrMap.isEmpty()) {
            Set set = this.attrMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printWriter.println("  " + string + " =");
                Set set2 = (Set)this.attrMap.get(string);
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    printWriter.println("    " + string2);
                }
            }
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("setAttrId") + " " + this.serviceName + " " + AdminReq.bundle.getString("foridentity") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        printUtils.printAVPairs(this.attrMap, 1);
        String[] stringArray = new String[]{this.serviceName, this.idType.toString(), this.idName, this.realmPath};
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            Set set = idSearchResults.getSearchResults();
            if (set.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            AMIdentity aMIdentity = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity2 = (AMIdentity)iterator.next();
                if (aMIdentity != null) continue;
                aMIdentity = aMIdentity2;
            }
            if (aMIdentity == null) {
                throw new AdminException(AdminReq.bundle.getString("couldNotFind") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            this.doLog(stringArray, "SET_ATTRIBUTES_IDENTITY_ATTEMPT");
            aMIdentity.setAttributes(this.attrMap);
            aMIdentity.store();
            this.doLog(stringArray, "SET_ATTRIBUTES_IDENTITY");
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

