/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdIsActiveReq
extends AdminReq {
    private String realmPath = null;
    private String idName = null;
    private IdType idType;

    IdIsActiveReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription126") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("is") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("active") + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            Set set = idSearchResults.getSearchResults();
            if (set.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            AMIdentity aMIdentity = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity2 = (AMIdentity)iterator.next();
                if (aMIdentity != null) continue;
                aMIdentity = aMIdentity2;
            }
            if (aMIdentity == null) {
                throw new AdminException(AdminReq.bundle.getString("couldNotFind") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            boolean bl = aMIdentity.isActive();
            AdminReq.writer.println(" " + bl);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

