/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdGetMembershipsReq
extends AdminReq {
    private String realmPath = null;
    private String idName = null;
    private IdType idType;
    private IdType targetIdType;

    IdGetMembershipsReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setTargetIdType(IdType idType) {
        this.targetIdType = idType;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription124") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("getMembershipsId") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.targetIdType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        try {
            Object object;
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            Set set = this.idType.canBeMemberOf();
            if (!set.contains(this.targetIdType)) {
                throw new AdminException(this.idType.toString() + " " + AdminReq.bundle.getString("canNotBeMemberOf") + " " + this.targetIdType.toString());
            }
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            Set set2 = idSearchResults.getSearchResults();
            Object object2 = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                object = (AMIdentity)iterator.next();
                if (object2 != null) continue;
                object2 = object;
            }
            object = ((AMIdentity)object2).getMemberships(this.targetIdType);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                AMIdentity aMIdentity = (AMIdentity)iterator2.next();
                String string = aMIdentity.getName();
                AdminReq.writer.println("  " + string);
            }
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

