/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class IdCreateIdentityReq
extends AdminReq {
    private Map idAttrMap = null;
    private String idName = null;
    private IdType idType;
    private String realmPath = null;

    IdCreateIdentityReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setAttrMap(Map map) {
        this.idAttrMap = map;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription114") + " " + this.targetDN);
        if (this.idAttrMap != null && !this.idAttrMap.isEmpty()) {
            Set set = this.idAttrMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printWriter.println("  " + string + " =");
                Set set2 = (Set)this.idAttrMap.get(string);
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    printWriter.println("    " + string2);
                }
            }
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("createIdentity") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
        String[] stringArray = new String[]{this.idName, this.idType.toString(), this.realmPath};
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            Set set = aMIdentityRepository.getAllowedIdOperations(this.idType);
            if (!set.contains(IdOperation.CREATE)) {
                throw new AdminException(this.realmPath + " " + AdminReq.bundle.getString("doesNotSupportCreation") + " " + this.idType.toString());
            }
            this.doLog(stringArray, "CREATE_IDENTITY_ATTEMPT");
            aMIdentityRepository.createIdentity(this.idType, this.idName, this.idAttrMap);
            this.doLog(stringArray, "CREATE_IDENTITY");
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

