/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class IdCreateIdentitiesReq
extends AdminReq {
    private Map idAttrMap = new HashMap();
    private String realmPath = null;
    private IdType idType;

    IdCreateIdentitiesReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void createIdCreateReq(String string, Map map) {
        this.idAttrMap.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription115") + " " + this.targetDN);
        if (this.idAttrMap != null && !this.idAttrMap.isEmpty()) {
            Set set = this.idAttrMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printWriter.println(" " + string + " = ");
                Map map = (Map)this.idAttrMap.get(string);
                Set set2 = map.keySet();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    printWriter.println("   " + string2 + " = ");
                    Set set3 = (Set)map.get(string2);
                    Iterator iterator3 = set3.iterator();
                    while (iterator3.hasNext()) {
                        String string3 = (String)iterator3.next();
                        printWriter.println("     " + string3);
                    }
                }
            }
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("createIdentities") + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        String[] stringArray = new String[]{this.idType.toString(), this.realmPath};
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            Set set = aMIdentityRepository.getAllowedIdOperations(this.idType);
            if (!set.contains(IdOperation.CREATE)) {
                throw new AdminException(this.realmPath + " " + AdminReq.bundle.getString("doesNotSupportCreation") + " " + this.idType.toString());
            }
            this.doLog(stringArray, "CREATE_IDENTITIES_ATTEMPT");
            aMIdentityRepository.createIdentities(this.idType, this.idAttrMap);
            this.doLog(stringArray, "CREATE_IDENTITIES");
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

