/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

class GroupUtils {
    GroupUtils() {
    }

    static int getGroupType(String string, AMStoreConnection aMStoreConnection, ResourceBundle resourceBundle) throws AdminException {
        int n = -1;
        try {
            n = aMStoreConnection.getAMObjectType(string);
            switch (n) {
                case 9: 
                case 11: 
                case 12: {
                    break;
                }
                default: {
                    throw new AdminException(resourceBundle.getString("invalidStaticGroupDN"));
                }
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return n;
    }

    static AMObject getGroupObject(String string, AMStoreConnection aMStoreConnection, ResourceBundle resourceBundle) throws AdminException {
        AMGroup aMGroup = null;
        int n = GroupUtils.getGroupType(string, aMStoreConnection, resourceBundle);
        try {
            switch (n) {
                case 9: {
                    aMGroup = aMStoreConnection.getStaticGroup(string);
                    break;
                }
                case 11: {
                    aMGroup = aMStoreConnection.getDynamicGroup(string);
                    break;
                }
                case 12: {
                    aMGroup = aMStoreConnection.getAssignableDynamicGroup(string);
                }
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return aMGroup;
    }

    static void deleteGroup(AdminReq adminReq, String string, AMStoreConnection aMStoreConnection, ResourceBundle resourceBundle, boolean bl) throws AdminException {
        int n = GroupUtils.getGroupType(string, aMStoreConnection, resourceBundle);
        try {
            switch (n) {
                case 9: {
                    AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(string);
                    adminReq.doLog(aMStaticGroup, "DELETE_GROUP_ATTEMPT");
                    aMStaticGroup.delete(bl);
                    adminReq.doLog(aMStaticGroup, "DELETE_GROUP");
                    break;
                }
                case 11: {
                    AMDynamicGroup aMDynamicGroup = aMStoreConnection.getDynamicGroup(string);
                    adminReq.doLog(aMDynamicGroup, "DELETE_GROUP_ATTEMPT");
                    aMDynamicGroup.delete(bl);
                    adminReq.doLog(aMDynamicGroup, "DELETE_GROUP");
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = aMStoreConnection.getAssignableDynamicGroup(string);
                    adminReq.doLog(aMAssignableDynamicGroup, "DELETE_GROUP_ATTEMPT");
                    aMAssignableDynamicGroup.delete(bl);
                    adminReq.doLog(aMAssignableDynamicGroup, "DELETE_GROUP");
                }
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    static AMGroup getGroup(String string, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        AMGroup aMGroup = null;
        try {
            switch (n) {
                case 10: {
                    aMGroup = aMStoreConnection.getStaticGroup(string);
                    break;
                }
                case 11: {
                    aMGroup = aMStoreConnection.getDynamicGroup(string);
                    break;
                }
                case 12: {
                    aMGroup = aMStoreConnection.getAssignableDynamicGroup(string);
                }
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
        return aMGroup;
    }

    static void printGroupInformation(PrintUtils printUtils, Set set, AMStoreConnection aMStoreConnection, ResourceBundle resourceBundle, int n) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMGroup aMGroup = GroupUtils.getGroup(string, aMStoreConnection, n);
                Map map = aMGroup.getAttributes();
                AdminReq.writer.println("  " + string);
                printUtils.printAVPairs(map, 2);
                if (!AdminUtils.logEnabled()) continue;
                AdminUtils.log(resourceBundle.getString("statusmsg27"));
                printUtils.printAVPairs(map, 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

