/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;

class GroupGetNumOfNestedGroupsReq
extends AdminReq {
    GroupGetNumOfNestedGroupsReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription95") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        long l = this.getNumberOfNestedGroups(aMStoreConnection);
        AdminReq.writer.println(AdminReq.bundle.getString("numberofnestedgroups") + this.targetDN + "\n" + l);
        AdminReq.writer.flush();
    }

    protected long getNumberOfNestedGroups(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(this.targetDN);
            Set set = aMStaticGroup.getNestedGroupDNs();
            return set.size();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

