/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class GroupGetNestedGroupReq
extends AdminReq {
    private Set nestedGroupDNs = new HashSet();
    private boolean DNsOnly = true;

    GroupGetNestedGroupReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    void addNestedGroupDNs(String string) {
        this.nestedGroupDNs.add(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription94") + " " + this.targetDN);
        printWriter.println("   DNsOnly =" + this.DNsOnly);
        if (this.nestedGroupDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.nestedGroupDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        AdminReq.writer.println(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getnestedgroups"));
        Set set = this.getNestedGroupDNs(aMStoreConnection);
        if (this.nestedGroupDNs.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                this.printInformation(printUtils, string, aMStoreConnection, this.DNsOnly);
            }
        } else {
            Iterator iterator = this.nestedGroupDNs.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (!set.contains(string)) continue;
                this.printInformation(printUtils, string, aMStoreConnection, this.DNsOnly);
            }
        }
    }

    protected Set getNestedGroupDNs(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(this.targetDN);
            return aMStaticGroup.getNestedGroupDNs();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    void printInformation(PrintUtils printUtils, String string, AMStoreConnection aMStoreConnection, boolean bl) throws AdminException {
        try {
            AdminReq.writer.println("  " + string);
            if (!bl) {
                AMGroup aMGroup = null;
                int n = aMStoreConnection.getAMObjectType(string);
                switch (n) {
                    case 9: 
                    case 10: {
                        aMGroup = aMStoreConnection.getStaticGroup(string);
                        break;
                    }
                    case 11: {
                        aMGroup = aMStoreConnection.getDynamicGroup(string);
                        break;
                    }
                    case 12: {
                        aMGroup = aMStoreConnection.getAssignableDynamicGroup(string);
                    }
                }
                if (aMGroup != null) {
                    printUtils.printAVPairs(aMGroup.getAttributes(), 2);
                }
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

