/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.ISLocaleContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

class EntityUtils {
    private static final String USER_SERVICE = "iPlanetAMUserService";
    private ISLocaleContext localeContext = new ISLocaleContext();

    EntityUtils() {
    }

    static void printEntityInformation(PrintUtils printUtils, AMEntity aMEntity, AMStoreConnection aMStoreConnection, boolean bl) throws AdminException {
        try {
            AdminReq.writer.println("  " + aMEntity.getDN());
            if (!bl) {
                printUtils.printAVPairs(aMEntity.getAttributes(), 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }

    public Map getEntityTypesMap(AMStoreConnection aMStoreConnection) {
        HashMap<String, AMEntityType> hashMap = Collections.EMPTY_MAP;
        Set set = aMStoreConnection.getEntityTypes();
        if (set != null && !set.isEmpty()) {
            hashMap = new HashMap<String, AMEntityType>(set.size() * 2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMEntityType aMEntityType = (AMEntityType)iterator.next();
                String string = aMEntityType.getServiceName();
                if (string == null || string.equals(USER_SERVICE)) continue;
                hashMap.put(aMEntityType.getName(), aMEntityType);
            }
        } else {
            hashMap = Collections.EMPTY_MAP;
        }
        return hashMap;
    }

    public String getL10NAttributeName(AMStoreConnection aMStoreConnection, String string, String string2) {
        String string3 = string2;
        try {
            String string4 = aMStoreConnection.getI18NPropertiesFileName(string);
            if (string4 != null) {
                ResourceBundle resourceBundle = EntityUtils.getBundle(string4, this.localeContext.getLocale());
                string3 = Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)AdminReq.debug);
            }
        }
        catch (AMException aMException) {
            AdminReq.debug.warning("EntityUtils.getL10NAttributeName", (Throwable)aMException);
        }
        catch (MissingResourceException missingResourceException) {
            AdminReq.debug.warning("EntityUtils.getL10NAttributeName", (Throwable)missingResourceException);
        }
        return string3;
    }

    public static ResourceBundle getBundle(String string, java.util.Locale locale) {
        AMResourceBundleCache aMResourceBundleCache = AMResourceBundleCache.getInstance();
        ResourceBundle resourceBundle = aMResourceBundleCache.getResBundle(string, locale);
        if (resourceBundle == null) {
            resourceBundle = aMResourceBundleCache.getResBundle("amAdminCLI", locale);
        }
        return resourceBundle;
    }
}

