/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.EntityUtils;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

class ContModifyEntityReq
extends AdminReq {
    private Map values = new HashMap();
    private String entityDN;
    private String entityType = null;

    ContModifyEntityReq(String string) {
        super(string);
    }

    void addRequest(String string, Map map) {
        this.entityDN = string;
        this.values = map;
    }

    void setEntityType(String string) {
        this.entityType = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription86") + " " + this.targetDN + "\n" + "  " + this.entityDN);
        printUtils.printAVPairs(this.values, 2);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        EntityUtils entityUtils = new EntityUtils();
        Map map = entityUtils.getEntityTypesMap(aMStoreConnection);
        AMEntityType aMEntityType = (AMEntityType)map.get(this.entityType);
        if (aMEntityType == null) {
            throw new AdminException(AdminReq.bundle.getString("invalidEntity"));
        }
        String string = entityUtils.getL10NAttributeName(aMStoreConnection, aMEntityType.getServiceName(), "entity-name-description");
        Object[] objectArray = new String[]{string};
        String string2 = MessageFormat.format(AdminReq.bundle.getString("modifyEntity"), objectArray);
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + string2);
        try {
            AMEntity aMEntity = aMStoreConnection.getEntity(this.entityDN);
            this.doLog(aMEntity, "MODIFY_ENTITY_ATTEMPT", string);
            aMEntity.setAttributes(this.values);
            aMEntity.store();
            this.doLog(aMEntity, "MODIFY_ENTITY", string);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

