/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.RoleUtils;
import com.iplanet.am.admin.cli.SearchReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;

class ContGetRoleReq
extends SearchReq {
    private String level = "SCOPE_SUB";

    ContGetRoleReq(String string) {
        super(string);
    }

    void setLevel(String string) {
        this.level = string;
    }

    String getLevel() {
        return this.level;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription16") + " " + this.targetDN);
        printWriter.println("   level = " + this.level);
        printWriter.println("   filter = " + this.filter);
        printWriter.println("   sizeLimit = " + this.sizeLimit);
        printWriter.println("   timeLimit = " + this.timeLimit);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + "\n" + AdminReq.bundle.getString("getroles"));
        try {
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            AdminReq.writer.println(this.targetDN);
            int n = this.level.equals("SCOPE_SUB") ? 2 : 1;
            AMSearchControl aMSearchControl = this.createSearchControl(n);
            AMSearchResults aMSearchResults = aMOrganizationalUnit.searchRoles(this.filter, aMSearchControl);
            if (aMSearchResults.getErrorCode() != 0) {
                this.errorCode = aMSearchResults.getErrorCode();
            }
            Set set = aMSearchResults.getSearchResults();
            RoleUtils.printRoleInformation(printUtils, set, aMStoreConnection, AdminReq.bundle, 6);
            AMSearchResults aMSearchResults2 = aMOrganizationalUnit.searchFilteredRoles(this.filter, aMSearchControl);
            if (aMSearchResults2.getErrorCode() != 0) {
                this.errorCode = aMSearchResults2.getErrorCode();
            }
            Set set2 = aMSearchResults2.getSearchResults();
            RoleUtils.printRoleInformation(printUtils, set2, aMStoreConnection, AdminReq.bundle, 8);
            this.printSearchLimitError();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

