/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.GroupUtils;
import com.iplanet.am.admin.cli.SearchReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ContGetGroupReq
extends SearchReq {
    private String level = "SCOPE_SUB";

    ContGetGroupReq(String string) {
        super(string);
    }

    void setLevel(String string) {
        this.level = string;
    }

    String getLevel() {
        return this.level;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription12") + " " + this.targetDN);
        printWriter.println("   level = " + this.level);
        printWriter.println("   filter = " + this.filter);
        printWriter.println("   sizeLimit = " + this.sizeLimit);
        printWriter.println("   timeLimit = " + this.timeLimit);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getgroups"));
        try {
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            int n = this.level.equals("SCOPE_SUB") ? 2 : 1;
            AMSearchControl aMSearchControl = this.createSearchControl(n);
            if (n == 1) {
                Set set = aMOrganizationalUnit.getGroupContainers(1);
                if (set != null && !set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        AdminReq.writer.println(string);
                        AMGroupContainer aMGroupContainer = aMStoreConnection.getGroupContainer(string);
                        this.searchGroups(aMStoreConnection, aMGroupContainer, aMSearchControl);
                    }
                }
            } else {
                this.searchGroups(aMStoreConnection, aMOrganizationalUnit, aMSearchControl);
            }
            this.printSearchLimitError();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }

    private void searchGroups(AMStoreConnection aMStoreConnection, AMOrganizationalUnit aMOrganizationalUnit, AMSearchControl aMSearchControl) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        try {
            AMSearchResults aMSearchResults = aMOrganizationalUnit.searchStaticGroups(this.filter, aMSearchControl);
            if (aMSearchResults.getErrorCode() != 0) {
                this.errorCode = aMSearchResults.getErrorCode();
            }
            Set set = aMSearchResults.getSearchResults();
            AMSearchResults aMSearchResults2 = aMOrganizationalUnit.searchDynamicGroups(this.filter, aMSearchControl);
            if (aMSearchResults2.getErrorCode() != 0) {
                this.errorCode = aMSearchResults2.getErrorCode();
            }
            Set set2 = aMSearchResults2.getSearchResults();
            AMSearchResults aMSearchResults3 = aMOrganizationalUnit.searchAssignableDynamicGroups(this.filter, aMSearchControl);
            if (aMSearchResults3.getErrorCode() != 0) {
                this.errorCode = aMSearchResults3.getErrorCode();
            }
            Set set3 = aMSearchResults3.getSearchResults();
            GroupUtils.printGroupInformation(printUtils, set, aMStoreConnection, AdminReq.bundle, 10);
            GroupUtils.printGroupInformation(printUtils, set2, aMStoreConnection, AdminReq.bundle, 11);
            GroupUtils.printGroupInformation(printUtils, set3, aMStoreConnection, AdminReq.bundle, 12);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }

    private void searchGroups(AMStoreConnection aMStoreConnection, AMGroupContainer aMGroupContainer, AMSearchControl aMSearchControl) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        try {
            AMSearchResults aMSearchResults = aMGroupContainer.searchGroups(this.filter, null, aMSearchControl);
            Set set = aMSearchResults.getSearchResults();
            if (aMSearchResults.getErrorCode() != 0) {
                this.errorCode = aMSearchResults.getErrorCode();
            }
            if (set != null && !set.isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = new HashSet<String>();
                HashSet<String> hashSet3 = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    int n = GroupUtils.getGroupType(string, aMStoreConnection, AdminReq.bundle);
                    switch (n) {
                        case 9: {
                            hashSet.add(string);
                            break;
                        }
                        case 11: {
                            hashSet2.add(string);
                            break;
                        }
                        case 12: {
                            hashSet3.add(string);
                        }
                    }
                }
                GroupUtils.printGroupInformation(printUtils, hashSet, aMStoreConnection, AdminReq.bundle, 10);
                GroupUtils.printGroupInformation(printUtils, hashSet2, aMStoreConnection, AdminReq.bundle, 11);
                GroupUtils.printGroupInformation(printUtils, hashSet3, aMStoreConnection, AdminReq.bundle, 12);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

