/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.EntityUtils;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class ContDeleteEntitiesReq
extends AddDeleteReq {
    private String entityType = null;

    ContDeleteEntitiesReq(String string) {
        super(string);
    }

    void setEntityType(String string) {
        this.entityType = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription85") + " " + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        EntityUtils entityUtils = new EntityUtils();
        Map map = entityUtils.getEntityTypesMap(aMStoreConnection);
        AMEntityType aMEntityType = (AMEntityType)map.get(this.entityType);
        if (aMEntityType == null) {
            throw new AdminException(AdminReq.bundle.getString("invalidEntity"));
        }
        String string = entityUtils.getL10NAttributeName(aMStoreConnection, aMEntityType.getServiceName(), "entity-name-description");
        String string2 = entityUtils.getL10NAttributeName(aMStoreConnection, aMEntityType.getServiceName(), "entities-description");
        Object[] objectArray = new String[]{string2};
        String string3 = MessageFormat.format(AdminReq.bundle.getString("deleteEntities"), objectArray);
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + string3);
        try {
            this.doLogStringSet(this.DNSet, "DELETE_ENTITY_ATTEMPT");
            HashSet<String> hashSet = new HashSet<String>();
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            Iterator iterator = this.DNSet.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (!this.deleteEntity(aMStoreConnection, aMOrganizationalUnit, string4)) continue;
                hashSet.add(string4);
            }
            this.doLogStringSetForEntity(hashSet, "DELETE_ENTITY", string);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private boolean deleteEntity(AMStoreConnection aMStoreConnection, AMOrganizationalUnit aMOrganizationalUnit, String string) {
        boolean bl;
        block11: {
            AMEntity aMEntity;
            block10: {
                bl = false;
                aMEntity = null;
                try {
                    aMEntity = aMStoreConnection.getEntity(string);
                    if (!aMEntity.isExists()) {
                        aMEntity = null;
                    }
                }
                catch (SSOException sSOException) {
                    if (!AdminUtils.logEnabled()) break block10;
                    AdminUtils.log(sSOException.getMessage());
                }
            }
            if (aMEntity != null) {
                try {
                    aMEntity.delete(true);
                    bl = true;
                }
                catch (AMException aMException) {
                    if (AdminUtils.logEnabled()) {
                        AdminUtils.log(aMException.getMessage());
                    }
                    break block11;
                }
                catch (SSOException sSOException) {
                    if (AdminUtils.logEnabled()) {
                        AdminUtils.log(sSOException.getMessage());
                    }
                    break block11;
                }
            }
            if (AdminUtils.logEnabled()) {
                Object[] objectArray = new String[]{string};
                String string2 = AdminReq.bundle.getString("entityDoNotExists");
                AdminUtils.log(MessageFormat.format(string2, objectArray));
            }
        }
        return bl;
    }
}

