/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ContCreateRoleReq
extends AdminReq {
    protected Map values;
    protected String roleDN;

    ContCreateRoleReq(String string) {
        super(string);
    }

    void addRoleReq(String string, Map map) {
        this.roleDN = string;
        this.values = map;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription4") + " " + this.targetDN);
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        hashMap.put(this.roleDN, this.values);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, hashMap);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createroles"));
        try {
            String[] stringArray = new String[]{this.roleDN};
            this.doLog(stringArray, "CREATE_ROLE_ATTEMPT");
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            hashMap.put(this.roleDN, this.values);
            Set set = aMOrganizationalUnit.createRoles(hashMap);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg18"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMRole aMRole = (AMRole)iterator.next();
                AdminReq.writer.println(aMRole.getDN());
            }
            this.doLog(set, "CREATE_ROLE");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

