/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

class Authenticator {
    private ResourceBundle bundle;
    private SSOToken ssoToken;
    private static final String LOGIN_STATUS = "iplanet-am-user-login-status";
    private static final String ACCOUNT_LIFE = "iplanet-am-user-account-life";
    private static final String STRING_ACTIVE = "active";
    private static Set ACTIVE_STATE_ATTRIBUTES = new HashSet(4);

    Authenticator(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    SSOToken getSSOToken() {
        return this.ssoToken;
    }

    com.sun.identity.authentication.AuthContext sessionBasedLogin(String string, String string2) throws AdminException {
        try {
            return this.sessionBasedLoginInternal(string, string2);
        }
        catch (AdminException adminException) {
            this.logLoginFailure(string);
            throw adminException;
        }
    }

    private com.sun.identity.authentication.AuthContext sessionBasedLoginInternal(String string, String string2) throws AdminException {
        com.sun.identity.authentication.AuthContext authContext = this.getAuthContext();
        this.processCallback(authContext, string, string2);
        try {
            this.ssoToken = authContext.getSSOToken();
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        return authContext;
    }

    void ldapLogin(String string, String string2) throws AdminException {
        String string3 = SystemProperties.get((String)"com.sun.identity.security.amadmin", (String)"false");
        if (string3.equalsIgnoreCase("false")) {
            try {
                this.sessionBasedLoginInternal(string, string2);
                AdminUtils.setSSOToken(this.ssoToken);
            }
            catch (Exception exception) {
                this.ldapLoginInternal(string, string2);
            }
        }
        if (this.ssoToken == null) {
            this.ldapLoginInternal(string, string2);
        }
    }

    void ldapLoginInternal(String string, String string2) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(this.bundle.getString("statusmsg6"));
        }
        try {
            AuthContext authContext = this.getLDAPAuthContext(string, string2);
            if (authContext.getLoginStatus() == 3) {
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(this.bundle.getString("statusmsg7"));
                    AdminUtils.log(this.bundle.getString("statusmsg8"));
                }
            } else {
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(this.bundle.getString("statusmsg9"));
                }
                throw new AdminException(this.bundle.getString("ldapauthfail"));
            }
            this.ssoToken = authContext.getSSOToken();
            AdminUtils.setSSOToken(this.ssoToken);
        }
        catch (LoginException loginException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(this.bundle.getString("ldapauthfail"), loginException);
            }
            throw new AdminException(this.bundle.getString("ldapauthfail"));
        }
        catch (InvalidAuthContextException invalidAuthContextException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(this.bundle.getString("ldapauthfail"), invalidAuthContextException);
            }
            throw new AdminException(this.bundle.getString("ldapauthfail"));
        }
    }

    private AuthContext getLDAPAuthContext(String string, String string2) throws LoginException {
        AuthPrincipal authPrincipal = new AuthPrincipal(string);
        AuthContext authContext = new AuthContext(authPrincipal, string2.toCharArray());
        return authContext;
    }

    private com.sun.identity.authentication.AuthContext getAuthContext() throws AdminException {
        try {
            com.sun.identity.authentication.AuthContext authContext = new com.sun.identity.authentication.AuthContext("/");
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, "LDAP");
            return authContext;
        }
        catch (LoginException loginException) {
            loginException.printStackTrace();
            throw new AdminException(this.bundle.getString("loginFailed"));
        }
    }

    private void processCallback(com.sun.identity.authentication.AuthContext authContext, String string, String string2) throws AdminException {
        while (authContext.hasMoreRequirements()) {
            Callback[] callbackArray = authContext.getRequirements();
            if (callbackArray == null) continue;
            this.setCallbackValues(callbackArray, string, string2);
            authContext.submitRequirements(callbackArray);
        }
        if (authContext.getStatus() != AuthContext.Status.SUCCESS) {
            throw new AdminException(this.bundle.getString("loginFailed"));
        }
    }

    private void setCallbackValues(Callback[] callbackArray, String string, String string2) {
        int n = 0;
        while (n < callbackArray.length) {
            Callback callback;
            if (callbackArray[n] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[n];
                ((NameCallback)callback).setName(string);
            } else if (callbackArray[n] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[n];
                char[] cArray = string2.toCharArray();
                ((PasswordCallback)callback).setPassword(cArray);
            }
            ++n;
        }
    }

    private void logLoginFailure(String string) {
        SSOToken sSOToken = this.getAdminSSOToken();
        if (sSOToken != null) {
            String[] stringArray = new String[]{string};
            AdminUtils.logOperation(1, Level.INFO, "LOGIN_FAIL", stringArray);
        }
    }

    private SSOToken getAdminSSOToken() {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (SSOException sSOException) {
            AdminUtils.log(sSOException.getMessage());
        }
        return sSOToken;
    }

    private boolean isPrincipalActive() throws AdminException {
        boolean bl;
        block11: {
            bl = false;
            try {
                new ServiceSchemaManager("iPlanetAMAdminConsoleService", this.ssoToken);
                new ServiceSchemaManager("DAI", this.ssoToken);
                AMStoreConnection aMStoreConnection = new AMStoreConnection(this.ssoToken);
                Map map = null;
                String string = this.ssoToken.getProperty("Principal");
                int n = 0;
                try {
                    n = aMStoreConnection.getAMObjectType(string);
                }
                catch (AMException aMException) {
                    bl = true;
                }
                if (bl) break block11;
                switch (n) {
                    case 1: {
                        AMUser aMUser = aMStoreConnection.getUser(string);
                        bl = aMUser.isActivated();
                        if (bl) {
                            map = aMUser.getAttributes(ACTIVE_STATE_ATTRIBUTES);
                            String string2 = Authenticator.getStringValue(map, LOGIN_STATUS);
                            boolean bl2 = bl = string2 == null || string2.equalsIgnoreCase(STRING_ACTIVE);
                            if (bl) {
                                bl = !Authenticator.isExpired(Authenticator.getStringValue(map, ACCOUNT_LIFE));
                            }
                        }
                        break;
                    }
                    default: {
                        AMEntity aMEntity = aMStoreConnection.getEntity(string);
                        bl = aMEntity.isActivated();
                    }
                }
            }
            catch (AMException aMException) {
                throw new AdminException(this.bundle.getString("ldapauthfail"));
            }
            catch (SSOException sSOException) {
                throw new AdminException(this.bundle.getString("ldapauthfail"));
            }
            catch (SMSException sMSException) {
                bl = true;
            }
        }
        return bl;
    }

    private static String getStringValue(Map map, String string) {
        Set set;
        String string2 = null;
        if (map != null && !map.isEmpty() && (set = (Set)map.get(string)) != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
        }
        return string2;
    }

    private static boolean isExpired(String string) {
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            Date date = Locale.parseNormalizedDateString((String)string);
            bl = date.before(new Date());
        }
        return bl;
    }

    static {
        ACTIVE_STATE_ATTRIBUTES.add(LOGIN_STATUS);
        ACTIVE_STATE_ATTRIBUTES.add(ACCOUNT_LIFE);
    }
}

