/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminResourceBundle;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;

abstract class AdminReq {
    static final String SCHEMA_TYPE_ORGANIZATION = "organization";
    static final String SCHEMA_TYPE_DYNAMIC = "dynamic";
    static final String SCHEMA_TYPE_POLICY = "policy";
    static final String GROUP_TYPE_STATIC = "static";
    static final String GROUP_TYPE_DYNAMIC = "dynamic";
    static final String GROUP_TYPE_ASSIGNABLE_DYNAMIC = "assignableDynamic";
    static final String GROUP_FILTER_INFO = "filterinfo";
    static final String ROLE_TYPE_STATIC = "static";
    static final String ROLE_TYPE_FILTERED = "filtered";
    static final String ROLE_FILTER_INFO = "filterinfo";
    static final String AUTH_SERVICE = "iPlanetAMAuthService";
    static final String AUTH_USER_CONTAINER_ATTRIBUTE = "iplanet-am-auth-user-container";
    static final String ENTITY_NAME = "entity-name-description";
    static final String ENTITIES_DESC = "entities-description";
    protected static Debug debug = Debug.getInstance((String)"amAdmin");
    protected static PrintWriter writer = new PrintWriter(System.out, true);
    protected static ResourceBundle bundle = AdminResourceBundle.getResources();
    protected String targetDN = null;

    AdminReq() {
    }

    AdminReq(String string) {
        this.targetDN = string;
    }

    void setTargetDN(String string) {
        this.targetDN = string;
    }

    String getTargetDN() {
        return this.targetDN;
    }

    ServiceSchemaManager getServiceSchemaManager(SSOToken sSOToken, String string) throws AdminException {
        try {
            return new ServiceSchemaManager(string, sSOToken);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
    }

    void printAMObjectDN(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMObject aMObject = (AMObject)iterator.next();
            writer.println(aMObject.getDN());
        }
    }

    void doLog(Set set, String string) {
        String[] stringArray = new String[1];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMObject aMObject = (AMObject)iterator.next();
            stringArray[0] = aMObject.getDN();
            AdminUtils.logOperation(0, Level.INFO, string, stringArray);
        }
    }

    void doLogForEntity(Set set, String string, String string2) {
        String[] stringArray = new String[2];
        stringArray[0] = string2;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMEntity aMEntity = (AMEntity)iterator.next();
            stringArray[1] = aMEntity.getDN();
            AdminUtils.logOperation(0, Level.INFO, string, stringArray);
        }
    }

    void doLog(AMObject aMObject, String string) {
        String[] stringArray = new String[]{aMObject.getDN()};
        AdminUtils.logOperation(0, Level.INFO, string, stringArray);
    }

    void doLog(AMEntity aMEntity, String string, String string2) {
        String[] stringArray = new String[]{string2, aMEntity.getDN()};
        AdminUtils.logOperation(0, Level.INFO, string, stringArray);
    }

    void doLogStringSet(Set set, String string) {
        String[] stringArray = new String[1];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[0] = (String)iterator.next();
            AdminUtils.logOperation(0, Level.INFO, string, stringArray);
        }
    }

    void doLogStringSetForEntity(Set set, String string, String string2) {
        String[] stringArray = new String[2];
        stringArray[0] = string2;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[1] = (String)iterator.next();
            AdminUtils.logOperation(0, Level.INFO, string, stringArray);
        }
    }

    void doLogStringSet(Set set, AMObject aMObject, String string) {
        String[] stringArray = new String[2];
        stringArray[1] = aMObject.getDN();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[0] = (String)iterator.next();
            AdminUtils.logOperation(0, Level.INFO, string, stringArray);
        }
    }

    void doLog(String string, AMObject aMObject, String string2) {
        String[] stringArray = new String[]{string, aMObject.getDN()};
        AdminUtils.logOperation(0, Level.INFO, string2, stringArray);
    }

    void doLog(String[] stringArray, String string) {
        AdminUtils.logOperation(0, Level.INFO, string, stringArray);
    }
}

