/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.messageid;

import com.iplanet.am.util.Resource;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.messageid.LogMessageID;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.spi.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LogMessageProviderBase
implements LogMessageProvider {
    private List messageIDs = new ArrayList();
    private Map hashMessageIDs = new HashMap();
    private String xmlDefinitionFilename;

    protected LogMessageProviderBase(String string) throws IOException {
        this.xmlDefinitionFilename = string;
        this.registerMessageIDs();
    }

    public List getAllMessageIDs() {
        return this.messageIDs;
    }

    public LogRecord createLogRecord(String string, String[] stringArray, Object object) {
        LogRecord logRecord = null;
        LogMessageID logMessageID = (LogMessageID)this.hashMessageIDs.get(string);
        if (logMessageID != null) {
            logRecord = object != null ? new LogRecord(logMessageID.getLogLevel(), this.formatMessage(stringArray), object) : new LogRecord(logMessageID.getLogLevel(), this.formatMessage(stringArray));
            logRecord.addLogInfo("MessageID", logMessageID.getPrefix() + "-" + logMessageID.getID());
        } else {
            Debug.error("LogMessageProviderBase.createLogRecord: unable to locale message ID object for " + string);
        }
        return logRecord;
    }

    public LogRecord createLogRecord(String string, String[] stringArray, Hashtable hashtable) {
        LogRecord logRecord = null;
        LogMessageID logMessageID = (LogMessageID)this.hashMessageIDs.get(string);
        if (logMessageID != null) {
            logRecord = new LogRecord(logMessageID.getLogLevel(), this.formatMessage(stringArray), hashtable);
            logRecord.addLogInfo("MessageID", logMessageID.getPrefix() + "-" + logMessageID.getID());
        } else {
            Debug.error("LogMessageProviderBase.createLogRecord: unable to locale message ID object for " + string);
        }
        return logRecord;
    }

    private String formatMessage(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    protected void registerMessageIDs() throws IOException {
        Element element;
        String string;
        Document document = this.getXMLDoc();
        if (document != null && (string = (element = document.getDocumentElement()).getNodeName()).equals("logmessages")) {
            String string2 = element.getAttribute("prefix");
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                LogMessageID logMessageID = LogMessageID.createInstance(string2, nodeList.item(n2));
                if (logMessageID != null) {
                    this.messageIDs.add(logMessageID);
                    this.hashMessageIDs.put(logMessageID.getName(), logMessageID);
                }
                ++n2;
            }
        }
    }

    private Document getXMLDoc() throws IOException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ValidationErrorHandler());
            documentBuilder.setEntityResolver(new XMLHandler());
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.xmlDefinitionFilename);
            if (inputStream == null) {
                throw new IOException(this.xmlDefinitionFilename + " cannot be found.");
            }
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXParseException sAXParseException) {
            Debug.error("LogMessageProviderBase.getXMLDoc", sAXParseException);
        }
        catch (SAXException sAXException) {
            Debug.error("LogMessageProviderBase.getXMLDoc", sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Debug.error("LogMessageProviderBase.getXMLDoc", parserConfigurationException);
        }
        return document;
    }

    class XMLHandler
    extends DefaultHandler {
        XMLHandler() {
        }

        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = null;
            String string3 = string2.trim();
            if (string3.toLowerCase().startsWith("jar://")) {
                String string4 = string3.substring(5);
                String string5 = Resource.read((String)string4).trim();
                inputSource = new InputSource(new StringReader(string5));
            }
            return inputSource;
        }
    }

    class ValidationErrorHandler
    implements ErrorHandler {
        ValidationErrorHandler() {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            System.err.println(LogMessageProviderBase.this.xmlDefinitionFilename + "\n" + sAXParseException.getMessage() + "\nLine Number in XML file : " + sAXParseException.getLineNumber() + "\nColumn Number in XML file : " + sAXParseException.getColumnNumber());
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            System.err.println(LogMessageProviderBase.this.xmlDefinitionFilename + "\n" + sAXParseException.getMessage() + "\nLine Number in XML file : " + sAXParseException.getLineNumber() + "\nColumn Number in XML file : " + sAXParseException.getColumnNumber());
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            System.err.println(LogMessageProviderBase.this.xmlDefinitionFilename + "\n" + sAXParseException.getMessage() + "\nLine Number in XML file : " + sAXParseException.getLineNumber() + "\nColumn Number in XML file : " + sAXParseException.getColumnNumber());
        }
    }
}

