/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.log.NullLocationException;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.FormatterInitException;
import com.sun.identity.log.secure.LogSign;
import com.sun.identity.log.secure.LogVerifier;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.secure.SecurityInitializer;
import com.sun.identity.log.secure.VerifierList;
import com.sun.identity.log.spi.Archiver;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.Token;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.util.Password;

public class SecureFileHandler
extends Handler {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private static String PREFIX = "_secure.";
    private OutputStream output;
    private Writer writer;
    private MeteredStream meteredStream;
    private static Hashtable archiverTable = new Hashtable();
    private static Map currentFileList = new HashMap();
    private static Hashtable helperTable = new Hashtable();
    private static boolean verificationInitialized = false;
    private File[] files;
    private boolean headerWritten;
    private int count;
    private int maxFileSize;
    private String location;
    private Formatter formatter;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss.ddMMyyyy");
    private Date date;
    private String currentFileName;
    private String logName;
    private int filesPerKeyStore;
    private String archiverClass;
    private Timer signTimer = null;
    private Timer verifyTimer = null;
    private long signInterval = 0L;
    private static Password logPassword = null;
    private static Password verPassword = null;
    private static Password tokenPassword = null;
    private SecureLogHelper helper = null;
    private LogVerifier lv = null;
    private boolean verificationOn = false;
    private static String token = null;

    private void setOutputStream(OutputStream outputStream) throws SecurityException, UnsupportedEncodingException {
        if (outputStream == null && Debug.warningEnabled()) {
            Debug.warning(this.logName + ":SecureFileHandler: OutputStream is null");
        }
        this.output = outputStream;
        this.headerWritten = false;
        String string = this.getEncoding();
        if (string == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.output, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.error(this.logName + ":SecureFileHandler: Unsupported Encoding", unsupportedEncodingException);
                throw new UnsupportedEncodingException(unsupportedEncodingException.getMessage());
            }
        }
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        if (this.output == null) {
            return;
        }
        this.flush();
        this.writer = string == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, string);
    }

    private void configure() throws NullLocationException, FormatterInitException {
        String string;
        String string2;
        String string3 = this.lmanager.getProperty("iplanet-am-logging-num-hist-file");
        this.count = string3 == null || string3.length() == 0 ? 0 : Integer.parseInt(string3);
        String string4 = this.lmanager.getProperty("iplanet-am-logging-signature-period-in-seconds");
        this.signInterval = string4 == null || string4.length() == 0 ? 600000L : Long.parseLong(string4) * 1000L;
        String string5 = this.lmanager.getProperty("iplanet-am-logging-max-file-size");
        this.maxFileSize = string5 == null || string5.length() == 0 ? 0 : Integer.parseInt(string5);
        this.location = this.lmanager.getProperty("iplanet-am-logging." + this.logName + ".location");
        if (this.location == null) {
            this.location = this.lmanager.getProperty("iplanet-am-logging-location");
        }
        if (this.location == null || this.location.length() == 0) {
            throw new NullLocationException("Location Not Specified");
        }
        if (!this.location.endsWith(File.separator)) {
            this.location = this.location + File.separator;
        }
        if ((string2 = this.lmanager.getProperty("iplanet-am-logging-files-per-keystore")) == null || string2.length() == 0) {
            if (Debug.warningEnabled()) {
                Debug.warning(this.logName + ":Archiver: could not get the files per keystore str setting it to 1");
            }
            string2 = "5";
        }
        this.filesPerKeyStore = Integer.parseInt(string2);
        if (Debug.messageEnabled()) {
            Debug.message(this.logName + ":Files per Key Store = " + string2);
        }
        if ((string = this.lmanager.getProperty("iplanet-am-logging-archiver-class")) == null || string.length() == 0) {
            throw new NullLocationException("Archvier class not specified");
        }
        this.archiverClass = string;
    }

    private void openFiles(String string) throws IOException {
        this.open(new File(string), true);
    }

    private void open(File file, boolean bl) throws IOException {
        int n = 0;
        n = (int)file.length();
        FileOutputStream fileOutputStream = new FileOutputStream(file.toString(), true);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.meteredStream = new MeteredStream(bufferedOutputStream, n);
        this.setOutputStream(this.meteredStream);
        this.checkForHeaderWritten(file.toString());
    }

    public SecureFileHandler(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.logName = string;
        try {
            this.configure();
        }
        catch (NullLocationException nullLocationException) {
            Debug.error(this.logName + ":SecureFileHandler: Location not specified", nullLocationException);
        }
        catch (FormatterInitException formatterInitException) {
            Debug.error(this.logName + ":SecureFileHandler: could not instantiate Formatter", formatterInitException);
        }
        string = this.location + PREFIX + string;
        Logger logger = (Logger)Logger.getLogger(this.logName);
        if (logger.getLevel() != Level.OFF) {
            try {
                this.openFiles(string);
            }
            catch (IOException iOException) {
                Debug.error(this.logName + ":SecureFileHandler: Unable to open Files", iOException);
            }
            logger.setCurrentFile(PREFIX + this.logName);
            this.initializeSecurity();
        }
    }

    public void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception exception) {
                Debug.error(this.logName + ":SecureFileHandler: Could not Flush Output", exception);
            }
        }
    }

    public void close() {
        if (Debug.messageEnabled()) {
            Debug.message(this.logName + ":SecureFileHandler: close() called");
        }
        this.flush();
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            Debug.error(this.logName + ":SecureFileHandler: Could not close writer", iOException);
        }
        if (this.signTimer != null) {
            this.stopPeriodicLogSigner();
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Stopped Log Signer");
            }
        }
        if (this.lv != null) {
            this.lv.stopLogVerifier();
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Stopped Log Verifier");
            }
        }
    }

    public synchronized void publish(java.util.logging.LogRecord logRecord) {
        if (this.writer == null) {
            Debug.warning(this.logName + ":SecureFileHandler: Writer is null");
            return;
        }
        if (!this.isLoggable(logRecord)) {
            return;
        }
        String string = "";
        string = this.getFormatter().format(logRecord);
        try {
            if (!this.headerWritten) {
                this.writer.write(this.getFormatter().getHead(this));
                this.headerWritten = true;
            }
            this.writer.write(string);
        }
        catch (IOException iOException) {
            Debug.error(this.logName + ":SecureFileHandler: could not write to file", iOException);
        }
        this.flush();
        if (!this.lv.getVerificationFlag()) {
            this.helper.setLastLineforLogger(true);
        }
        if (Debug.messageEnabled()) {
            Debug.message(this.logName + ":Check for file size = " + this.maxFileSize + " with size written = " + this.meteredStream.written);
        }
        if (string.length() > 0 && this.meteredStream.written >= this.maxFileSize) {
            if (Debug.messageEnabled()) {
                Debug.message("SecureFileHandler: FileFull Event reached");
            }
            this.archive();
        }
    }

    public static Archiver getArchiver(String string) {
        if (string == null || string.length() == 0) {
            Debug.warning(string + ":Logger: could not get archiver, null logName");
            return null;
        }
        return (Archiver)archiverTable.get(string);
    }

    public static void setArchiver(String string, Archiver archiver) {
        if (string == null || string.length() == 0) {
            if (Debug.warningEnabled()) {
                Debug.warning(string + ":Logger: Could not set archiver, null logName");
            }
            return;
        }
        archiverTable.put(string, archiver);
    }

    private void archive() {
        Object object;
        Archiver archiver = SecureFileHandler.getArchiver(this.logName);
        String string = "";
        String string2 = "Signature";
        try {
            object = new LogSign(this.logName);
            string2 = ((LogSign)object).sign();
        }
        catch (Exception exception) {
            Debug.error(this.logName + ":SecureFileHandler: could not generate signature");
        }
        object = new LogRecord(Level.INFO, "Signature");
        ((java.util.logging.LogRecord)object).setLoggerName(this.logName);
        ((LogRecord)object).addLogInfo("Signature", string2);
        string = this.getFormatter().format((java.util.logging.LogRecord)object);
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            Debug.error(this.logName + ":SecureLogHelper: could not write signature to file", iOException);
        }
        this.flush();
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            Debug.error(this.logName + ":SecureFileHandler: Couldnot close writer", iOException);
        }
        try {
            archiver.archive(this.logName, this.location);
            int n = archiver.checkCount();
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Files per keystore=" + this.filesPerKeyStore + " and current file count = " + n);
            }
            if (n >= this.filesPerKeyStore) {
                Debug.message(this.logName + ":Keystore limit reached");
                archiver.archiveKeyStore(this.logName, this.location);
                Debug.message(this.logName + ":FilesPerKeystore counter = " + archiver.checkCount());
                this.initializeKeyStore();
            }
        }
        catch (Exception exception) {
            Debug.error(this.logName + ":SecureFileHandler: Could not archive file", exception);
        }
        try {
            this.open(new File(this.location + PREFIX + this.logName), false);
            this.writer.write(this.getFormatter().getHead(this));
            this.headerWritten = true;
            int n = archiver.checkCount();
            if (n != 0) {
                this.writer.write(string);
            }
        }
        catch (IOException iOException) {
            Debug.error(this.logName + ":SecureFileHandler: could not write to file", iOException);
        }
        this.flush();
    }

    private void checkForHeaderWritten(String string) {
        Object object;
        byte[] byArray = new byte[1024];
        try {
            object = new FileInputStream(new File(string));
            ((FileInputStream)object).read(byArray);
        }
        catch (IOException iOException) {
            Debug.error(this.logName + ":SecureFileHandler: could not read file content", iOException);
        }
        object = new String(byArray);
        object = ((String)object).trim();
        if (((String)object).startsWith("#Version")) {
            this.headerWritten = true;
        }
    }

    public static void setLogPassword(String string, Object object) {
        if (Authorizer.isAuthorized(object)) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                try {
                    logPassword = new Password(new String(messageDigest.digest(Password.charToByte((char[])string.toCharArray())), "UTF-8").toCharArray());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logPassword = new Password(new String(messageDigest.digest(Password.charToByte((char[])string.toCharArray()))).toCharArray());
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logPassword = new Password(string.toCharArray());
            }
        }
    }

    public static void setVerPassword(String string, Object object) {
        if (Authorizer.isAuthorized(object)) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                try {
                    verPassword = new Password(new String(messageDigest.digest(Password.charToByte((char[])string.toCharArray())), "UTF-8").toCharArray());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    verPassword = new Password(new String(messageDigest.digest(Password.charToByte((char[])string.toCharArray()))).toCharArray());
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                verPassword = new Password(string.toCharArray());
            }
        }
    }

    public static void setTokenPassword(String string, Object object) {
        if (Authorizer.isAuthorized(object)) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                try {
                    tokenPassword = new Password(new String(messageDigest.digest(Password.charToByte((char[])string.toCharArray())), "UTF-8").toCharArray());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    tokenPassword = new Password(new String(messageDigest.digest(Password.charToByte((char[])string.toCharArray()))).toCharArray());
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                tokenPassword = new Password(string.toCharArray());
            }
        }
    }

    static Password getLogPassword() {
        return logPassword;
    }

    static Password getVerPassword() {
        return verPassword;
    }

    public static SecureLogHelper getSecureLogHelper(String string) {
        if (string == null || string.length() == 0) {
            Debug.warning(string + ":Logger: could not get SecureLogHelper , null logName");
            return null;
        }
        return (SecureLogHelper)helperTable.get(string);
    }

    private static void setSecureLogHelper(String string, SecureLogHelper secureLogHelper) {
        if (string == null || string.length() == 0) {
            Debug.warning(string + ":Logger: Could not set SecureLogHelper , null logName");
            return;
        }
        helperTable.put(string, secureLogHelper);
    }

    void initializeSecurity() {
        String string;
        Object object;
        Archiver archiver;
        Object object2;
        String string2;
        Object object3;
        String string3;
        String string4 = this.logName;
        try {
            string3 = this.lmanager.getProperty("iplanet-am-logging-certificate-database-directory");
            object3 = this.lmanager.getProperty("iplanet-am-logging-certificate-database-prefix");
            string2 = this.lmanager.getProperty("iplanet-am-logging-key-database-prefix");
            object2 = this.lmanager.getProperty("iplanet-am-logging-security-module-name");
            archiver = new CryptoManager.InitializationValues(string3, (String)object3, string2, (String)object2);
            object = this.lmanager.getProperty("iplanet-am-logging-location");
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            String string5 = string4;
            string = (String)object + PREFIX + "log." + string5;
            String string6 = (String)object + PREFIX + "ver." + string5;
            this.helper = SecureFileHandler.getSecureLogHelper(this.logName);
            if (this.helper == null) {
                this.helper = new SecureLogHelper((CryptoManager.InitializationValues)archiver);
                SecureFileHandler.setSecureLogHelper(this.logName, this.helper);
            }
            this.helper.initializeSecureLogHelper(token, string, logPassword, string6, logPassword);
            if (verificationInitialized) {
                this.helper.initializeVerifier(string6, logPassword, verPassword);
            }
        }
        catch (Exception exception) {
            Debug.error(this.logName + ":Logger: exception thrown while initializing secure logger", exception);
        }
        archiver = null;
        try {
            if (SecureFileHandler.getArchiver(this.logName) == null) {
                archiver = (Archiver)Class.forName(this.archiverClass).newInstance();
                SecureFileHandler.setArchiver(this.logName, archiver);
            }
        }
        catch (Exception exception) {
            Debug.error(this.logName + ":SecureFileHandler: Could Not set Archiver", exception);
        }
        string3 = this.lmanager.getProperty("iplanet-am-logging-signature-period-in-seconds");
        this.signInterval = string3 == null || string3.length() == 0 ? 600000L : Long.parseLong(string3) * 1000L;
        this.startPeriodicLogSigner();
        if (verificationInitialized) {
            this.startVerifierThread();
        }
        Debug.message(this.logName + ":Done initializeSecurity in Handler");
        object3 = new VerifierList();
        string2 = this.location;
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        object2 = ((VerifierList)object3).getKeysAndFiles(new File(string2), this.logName);
        object = (Vector)((TreeMap)object2).get(PREFIX + "log." + this.logName);
        int n = 1;
        while (n < ((Vector)object).size()) {
            string = (String)((Vector)object).elementAt(n);
            string = string.substring(PREFIX.length(), string.length());
            SecureFileHandler.addToCurrentFileList(string, string, this.logName);
            if (archiver != null) {
                archiver.incrementCount();
            }
            ++n;
        }
        string = (String)((Vector)object).elementAt(0);
        string = string.substring(PREFIX.length(), string.length());
        SecureFileHandler.addToCurrentFileList(string, string, this.logName);
    }

    public static void initializeVerifier(String string, Object object) {
        try {
            SecureFileHandler.setVerPassword(string, object);
            LogManager logManager = LogManagerUtil.getLogManager();
            String string2 = logManager.getProperty("iplanet-am-logging-location");
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            LogManager logManager2 = LogManagerUtil.getLogManager();
            Enumeration<String> enumeration = logManager2.getLoggerNames();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                String string4 = string2 + PREFIX + "ver." + string3;
                SecureLogHelper secureLogHelper = SecureFileHandler.getSecureLogHelper(string3);
                Password password = SecureFileHandler.getLogPassword();
                if (secureLogHelper != null) {
                    secureLogHelper.initializeVerifier(string4, password, verPassword);
                    try {
                        Debug.message(string3 + ":Trying to start the Verifier Thread");
                        Logger logger = (Logger)Logger.getLogger(string3);
                        Handler[] handlerArray = logger.getHandlers();
                        ((SecureFileHandler)handlerArray[0]).startVerifierThread();
                        Debug.message(string3 + ":Started Log Verifier thread");
                    }
                    catch (Exception exception) {
                        Debug.error(string3 + ":Unable to start Verifier Thread", exception);
                    }
                }
                verificationInitialized = true;
            }
        }
        catch (Exception exception) {
            Debug.error("Error initializing Verification", exception);
        }
    }

    LogVerifier getVerifier() {
        return this.lv;
    }

    void startVerifierThread() {
        try {
            Debug.message(this.logName + ":Trying to start the Verifier Thread");
            this.lv = new LogVerifier(this.logName, logPassword, verPassword);
            this.lv.startLogVerifier();
            Debug.message(this.logName + ":Started Log Verifier thread");
        }
        catch (Exception exception) {
            Debug.error(this.logName + ":Unable to start Verifier Thread", exception);
        }
    }

    public static void addToCurrentFileList(String string, String string2, String string3) {
        ArrayList<String> arrayList = (ArrayList<String>)currentFileList.get(PREFIX + string3);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        currentFileList.remove(PREFIX + string3);
        ((AbstractCollection)arrayList).remove(PREFIX + string);
        arrayList.add(PREFIX + string2);
        if (!string.equals(string2)) {
            arrayList.add(PREFIX + string);
        }
        currentFileList.put(PREFIX + string3, arrayList);
    }

    public static ArrayList getCurrentFileList(String string) {
        return (ArrayList)currentFileList.get(PREFIX + string);
    }

    public static void resetCurrentFileList(String string) {
        currentFileList.remove(PREFIX + string);
    }

    public void initializeKeyStore() {
        try {
            Logger logger = (Logger)Logger.getLogger(this.logName);
            SecureFileHandler.resetCurrentFileList(this.logName);
            SecureFileHandler.addToCurrentFileList(this.logName, this.logName, this.logName);
            String string = this.lmanager.getProperty("iplanet-am-logging-location");
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            String string2 = this.logName;
            String string3 = string + PREFIX + "log." + string2;
            String string4 = string + PREFIX + "ver." + string2;
            Debug.message(this.logName + ":Logger Keystore name = " + string3);
            Debug.message(this.logName + ":Verifier Keystore name= " + string4);
            this.helper.initializeSecureLogHelper(token, string3, logPassword, string4, logPassword);
            Debug.message(this.logName + ":Initialized SecureLogHelper");
            this.helper.initializeVerifier(string4, logPassword, verPassword);
            Debug.message(this.logName + ":Done init of SecureLogHelper and Verifier");
        }
        catch (Exception exception) {
            Debug.error(this.logName + ":Logger: exception thrown while initializing secure logger", exception);
        }
    }

    public static void setTokenName(String string) {
        if (string != null) {
            token = string;
        }
    }

    public static String getTokenName() {
        return token;
    }

    public static void setLoggerKeyName(String string) {
        SecureLogHelper.setLoggerKeyName(string);
    }

    public static String getLoggerKeyName() {
        return SecureLogHelper.getLoggerKeyName();
    }

    public SecureLogHelper getSecureLogHelper() {
        return this.helper;
    }

    void startPeriodicLogSigner() {
        if (this.signTimer == null) {
            this.signTimer = new Timer();
            this.signTimer.scheduleAtFixedRate((TimerTask)new SignTask(), this.signInterval, this.signInterval);
        }
    }

    void stopPeriodicLogSigner() {
        if (this.signTimer != null) {
            Debug.message(this.logName + "Sign Thread being stopped");
            this.signTimer.cancel();
        }
    }

    static /* synthetic */ String access$000(SecureFileHandler secureFileHandler) {
        return secureFileHandler.logName;
    }

    static /* synthetic */ String access$100() {
        return PREFIX;
    }

    static /* synthetic */ Password access$200() {
        return logPassword;
    }

    static {
        SecurityInitializer.doInitialization();
    }

    class SignTask
    extends TimerTask {
        SignTask() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = (Logger)Logger.getLogger(SecureFileHandler.access$000(SecureFileHandler.this));
            try {
                Logger.rwLock.readRequest();
                var2_2 = var1_1;
                synchronized (var2_2) {
                    try {
                        block14: {
                            var3_3 = LogReader.read(SecureFileHandler.access$100() + SecureFileHandler.access$000(SecureFileHandler.this), new LogQuery(1), Token.createToken("Auditor", new String(SecureFileHandler.access$200().getCharCopy())));
                            if (var3_3 == null || var3_3.length == 0) break block14;
                            var4_5 = new LogSign(SecureFileHandler.access$000(SecureFileHandler.this));
                            var5_6 = -1;
                            var6_7 = "Signature";
                            var7_8 = 0;
                            if (true) ** GOTO lbl30
                        }
                        Debug.message(SecureFileHandler.access$000(SecureFileHandler.this) + ": Read returned null records");
                    }
                    catch (Exception var3_4) {
                        Debug.error(SecureFileHandler.access$000(SecureFileHandler.this) + ":Error Writing Signature", var3_4);
                    }
                    break block13;
                }
            }
            catch (Throwable var11_14) {
                var12_11 = null;
                Logger.rwLock.readDone();
                throw var11_14;
            }
            {
                block13: {
                    do {
                        if (var3_3[0][var7_8].equalsIgnoreCase(var6_7)) {
                            var5_6 = var7_8;
                            break;
                        }
                        ++var7_8;
lbl30:
                        // 2 sources

                    } while (var7_8 < var3_3[0].length);
                    if (var5_6 == -1) {
                        Debug.error("Could not locate sign header");
                        // MONITOREXIT @DISABLED, blocks:[3, 9] lbl32 : MonitorExitStatement: MONITOREXIT : var2_2
                        var12_9 = null;
                        Logger.rwLock.readDone();
                        return;
                    }
                    if (var3_3.length > 1 && var3_3[1][var5_6].trim().equals("-")) {
                        var8_12 = var4_5.sign();
                        if (var8_12 != null && !var8_12.equals("")) {
                            var9_13 = new LogRecord(Level.SEVERE, "Signature");
                            var9_13.addLogInfo("Signature", var8_12);
                            SecureFileHandler.this.publish(var9_13);
                        } else {
                            Debug.warning(SecureFileHandler.access$000(SecureFileHandler.this) + "Signature is Null");
                        }
                    } else {
                        Debug.message(SecureFileHandler.access$000(SecureFileHandler.this) + ": Read returned only header or last record was a signature ");
                    }
                }
            }
            var12_10 = null;
            Logger.rwLock.readDone();
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream outputStream, int n) {
            this.out = outputStream;
            this.written = n;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.written;
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
            this.written += byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.written += n2;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

