/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.cli;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.secure.VerifierList;
import com.sun.identity.log.spi.IVerifierOutput;
import com.sun.identity.log.spi.VerifierAction;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.util.Password;

public class ISArchiveVerify {
    private static String USAGE = "Usage: amverifyarchive -l <logName> -p <path> -u <uname> -w <password>";
    private static String PREFIX = "_secure.";
    private String curMAC = null;
    private String prevSignature = null;
    private IVerifierOutput result;
    private boolean verified = true;
    private SecureLogHelper helper;
    private Password logPassword;
    private Password verPassword;
    private String name;
    private static CryptoManager.InitializationValues configValues;
    private static ResourceBundle bundle;
    static final int INVALID = 0;
    static final int LOGNAME = 1;
    static final int PATH = 2;
    static final int USERNAME = 3;
    static final int PASSWORD = 4;
    static Map OPTIONS;

    static int getToken(String string) {
        try {
            return (Integer)OPTIONS.get(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0 || stringArray.length != 8) {
            System.err.println(USAGE);
            System.exit(1);
        }
        try {
            CryptoManager cryptoManager = CryptoManager.getInstance();
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            String string = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.dir");
            String string2 = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.prefix");
            String string3 = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.passfile");
            String string4 = "secmod.db";
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string, string2, string2, string4);
            CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
        }
        ISArchiveVerify.runCommand(stringArray);
    }

    private static void runCommand(String[] stringArray) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            while (n5 < stringArray.length) {
                int n6 = ISArchiveVerify.getToken(stringArray[n5]);
                switch (n6) {
                    case 1: {
                        n = ++n5;
                        break;
                    }
                    case 2: {
                        n2 = ++n5;
                        break;
                    }
                    case 3: {
                        n3 = ++n5;
                        break;
                    }
                    case 4: {
                        n4 = ++n5;
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                System.err.println(exception.getMessage());
            }
            exception.printStackTrace();
            System.err.println(USAGE);
            System.exit(1);
        }
        try {
            ISArchiveVerify iSArchiveVerify = new ISArchiveVerify();
            boolean bl = iSArchiveVerify.verifyArchive(stringArray[n], stringArray[n2], stringArray[n3], stringArray[n4]);
            if (bl) {
                System.out.println(bundle.getString("verificationOfLogArchiveFor") + " " + stringArray[n] + " " + bundle.getString("archiveVerificationPassed"));
            } else {
                System.out.println(bundle.getString("verificationOfLogArchiveFor") + " " + stringArray[n] + " " + bundle.getString("archiveVerificationFailed"));
            }
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                System.err.println(exception.getMessage());
            }
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private boolean verifyLogRecord(String[] stringArray, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length - 2) {
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        this.curMAC = new String(stringArray[n]);
        this.verified = this.helper.verifyMAC(stringBuffer.toString(), SecureLogHelper.toByteArray(this.curMAC));
        return this.verified;
    }

    private boolean verifySignature(String[] stringArray, int n, int n2) throws Exception {
        byte[] byArray;
        String string = new String(stringArray[n]);
        if (this.curMAC == null) {
            return false;
        }
        byte[] byArray2 = SecureLogHelper.toByteArray(this.curMAC);
        if (this.prevSignature == null || this.prevSignature.equals("")) {
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        } else {
            byArray = new byte[byArray2.length + SecureLogHelper.toByteArray(this.prevSignature).length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(SecureLogHelper.toByteArray(this.prevSignature), 0, byArray, byArray2.length, SecureLogHelper.toByteArray(this.prevSignature).length);
        }
        if (n2 != 0) {
            this.prevSignature = string;
        }
        this.verified = this.helper.verifySignature(SecureLogHelper.toByteArray(string), byArray);
        return this.verified;
    }

    public boolean verifyArchive(String string, String string2, String string3, String string4) throws Exception {
        TreeMap treeMap;
        Password password;
        String string5 = string;
        LogManager logManager = (LogManager)LogManagerUtil.getLogManager();
        logManager.readConfiguration();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            try {
                password = new Password(new String(messageDigest.digest(Password.charToByte((char[])string4.toCharArray())), "UTF-8").toCharArray());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                password = new Password(new String(messageDigest.digest(Password.charToByte((char[])string4.toCharArray()))).toCharArray());
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            password = new Password(string4.toCharArray());
        }
        SSOToken sSOToken = null;
        SSOTokenManager sSOTokenManager = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string3), string4);
        }
        catch (SSOException sSOException) {
            System.out.println(bundle.getString("archiveVerification") + "SSOException: " + sSOException.getMessage());
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            System.out.println(bundle.getString("archiveVerification") + "UnsupportedOperationException: " + unsupportedOperationException.getMessage());
            return false;
        }
        VerifierList verifierList = new VerifierList();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if ((treeMap = verifierList.getKeysAndFiles(new File(string2), string)).size() == 0) {
            System.out.println(bundle.getString("archiveVerification") + bundle.getString("noFilesToVerify"));
            return true;
        }
        Object[] objectArray = treeMap.keySet().toArray();
        String string6 = new String();
        String string7 = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.dir");
        String string8 = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.prefix");
        String string9 = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.passfile");
        String string10 = "secmod.db";
        CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string7, string8, string8, string10);
        if (objectArray.length == 1) {
            System.out.println(bundle.getString("archiveVerification") + bundle.getString("noFilesToVerify"));
        }
        int n = 1;
        while (n < objectArray.length) {
            this.helper = new SecureLogHelper(initializationValues);
            Vector vector = (Vector)treeMap.get(objectArray[n]);
            String string11 = ((String)objectArray[n]).substring(((String)objectArray[n]).indexOf(".") + 1);
            string6 = string11.substring(string11.indexOf("."));
            string6 = PREFIX + "ver" + string6;
            this.helper.initializeVerifier(string2 + string6, password, password);
            this.helper.reinitializeVerifier(string2 + string6, password);
            this.curMAC = null;
            this.prevSignature = null;
            int n2 = 0;
            while (n2 < vector.size()) {
                System.out.println(bundle.getString("fileBeingVerified") + (String)vector.elementAt(n2));
                int n3 = 0;
                String[][] stringArray = new String[1][1];
                try {
                    stringArray = LogReader.read((String)vector.elementAt(n2), sSOToken);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (stringArray != null || stringArray.length != 0) {
                    Vector<String> vector2 = new Vector<String>(stringArray[0].length);
                    int n4 = 0;
                    while (n4 < stringArray[0].length) {
                        vector2.add(stringArray[0][n4]);
                        ++n4;
                    }
                    int n5 = -1;
                    int n6 = -1;
                    String string12 = "Signature";
                    String string13 = "MAC";
                    int n7 = 0;
                    while (n7 < vector2.size()) {
                        if (((String)vector2.get(n7)).equalsIgnoreCase(string12)) {
                            n5 = n7;
                            break;
                        }
                        ++n7;
                    }
                    int n8 = 0;
                    while (n8 < vector2.size()) {
                        if (((String)vector2.get(n8)).equalsIgnoreCase(string13)) {
                            n6 = n8;
                            break;
                        }
                        ++n8;
                    }
                    if (n5 == -1 || n6 == -1) {
                        return VerifierAction.doVerifierAction(string5, this.verified);
                    }
                    int n9 = 1;
                    while (n9 < stringArray.length) {
                        if (stringArray[n9][n5].equals("-")) {
                            this.verified = this.verifyLogRecord(stringArray[n9], n6);
                            if (!this.verified) {
                                System.err.println(bundle.getString("recordVerificationFailed") + (String)vector.elementAt(n2) + " " + bundle.getString("atRecordNumber") + n9);
                                break;
                            }
                            System.out.println(bundle.getString("recordVerificationPassed") + (String)vector.elementAt(n2) + " " + bundle.getString("atRecordNumber") + n9);
                        } else {
                            n3 = stringArray.length - 1 - n9;
                            this.verified = this.verifySignature(stringArray[n9], n5, n3);
                            if (!this.verified) {
                                System.err.println(bundle.getString("signatureVerificationFailed") + (String)vector.elementAt(n2) + bundle.getString("atRecordNumber") + n9);
                                break;
                            }
                            System.out.println(bundle.getString("signatureVerificationPassed") + (String)vector.elementAt(n2) + bundle.getString("atRecordNumber") + n9);
                        }
                        ++n9;
                    }
                } else {
                    System.err.println(bundle.getString("archiveVerification") + bundle.getString("emptyReturn") + (String)vector.elementAt(n2));
                }
                if (!this.verified) {
                    return this.verified;
                }
                ++n2;
            }
            this.helper.reinitializeVerifier(string2 + string6, password);
            ++n;
        }
        return this.verified;
    }

    static {
        bundle = null;
        OPTIONS = new HashMap();
        bundle = Locale.getInstallResourceBundle((String)"amLogging");
        OPTIONS.put("-l", new Integer(1));
        OPTIONS.put("-p", new Integer(2));
        OPTIONS.put("-u", new Integer(3));
        OPTIONS.put("-w", new Integer(4));
    }
}

