/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class MapFactory {
    private static boolean useConcHashMap;
    private static int concRate;
    private static final String CONC_MAP = "java.util.concurrent.ConcurrentHashMap";
    private static final Debug debug;

    private static Map constructMap(int n) throws Exception {
        Class<?> clazz = Class.forName(CONC_MAP);
        Class[] classArray = new Class[]{Integer.TYPE, Float.TYPE, Integer.TYPE};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        Object[] objectArray = new Object[]{new Integer(100), new Float(0.75), new Integer(n)};
        return (Map)constructor.newInstance(objectArray);
    }

    public static Map getMap() {
        Hashtable hashtable = null;
        if (useConcHashMap) {
            try {
                hashtable = MapFactory.constructMap(concRate);
            }
            catch (Exception exception) {
                hashtable = new Hashtable();
            }
        } else {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    public static Enumeration elements(Map map) {
        try {
            Method method = map.getClass().getMethod("elements", null);
            return (Enumeration)method.invoke((Object)map, null);
        }
        catch (Exception exception) {
            debug.error("Mapfactory.elements()", exception);
            throw new UnsupportedOperationException(exception.getMessage());
        }
    }

    static {
        block5: {
            useConcHashMap = false;
            concRate = 16;
            debug = Debug.getInstance("amSession");
            try {
                Class<?> clazz = Class.forName(CONC_MAP);
                useConcHashMap = true;
                String string = SystemProperties.get("com.sun.am.concurrencyRate");
                if (string == null || string.length() <= 0) break block5;
                try {
                    concRate = Integer.parseInt(string);
                    if (concRate < 0) {
                        concRate = 16;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    concRate = 16;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

