/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMSendMail;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.authentication.spi.AMAuthCallBackImpl;
import com.sun.identity.common.AccountLockoutInfo;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.MessagingException;

public class ISAccountLockout {
    private static final String USER_STATUS_ATTR = "inetuserstatus";
    private static final String USER_ACTIVE = "Active";
    private static final String USER_INACTIVE = "Inactive";
    private static final String SPACE_DELIM = " ";
    private static final String PIPE_DELIM = "|";
    private static final String FROM_ADDRESS = "lockOutEmailFrom";
    private static final String EMAIL_SUBJECT = "lockOutEmailSub";
    private static final String EMAIL_MESSAGE = "lockOutEmailMsg";
    private static final String INVALID_ATTEMPTS_XML_OBJECT_CLASS = "sunAMAuthAccountLockout";
    private static final String INVALID_ATTEMPTS_XML_ATTR = "sunAMAuthInvalidAttemptsData";
    private static final String BEGIN_XML = "<InvalidPassword>";
    private static final String INVALID_PASS_COUNT_BEGIN = "<InvalidCount>";
    private static final String INVALID_PASS_COUNT_END = "</InvalidCount>";
    private static final String LAST_FAILED_BEGIN = "<LastInvalidAt>";
    private static final String LAST_FAILED_END = "</LastInvalidAt>";
    private static final String LOCKEDOUT_AT_BEGIN = "<LockedoutAt>";
    private static final String LOCKEDOUT_AT_END = "</LockedoutAt>";
    private static final String END_XML = "</InvalidPassword>";
    private boolean failureLockoutMode = false;
    private boolean memoryLocking = false;
    private boolean storeInvalidAttemptsInDS = true;
    private long failureLockoutTime = 300L;
    private int failureLockoutCount = 5;
    private String lockoutNotification = null;
    private int lockoutUserWarning = 3;
    private int userWarningCount = 0;
    private long failureLockoutDuration = 0L;
    private String lockoutAttrValue = null;
    private String lockoutAttrName = null;
    private String bundleName = null;
    static Debug debug = Debug.getInstance("amAccountLockout");
    private AMAuthCallBackImpl callbackImpl = null;
    static Map loginFailHash = Collections.synchronizedMap(new HashMap());

    public ISAccountLockout(boolean bl, long l, int n, String string, int n2, String string2, String string3, long l2, String string4) {
        this.failureLockoutMode = bl;
        this.failureLockoutTime = l;
        this.failureLockoutCount = n;
        this.lockoutNotification = string;
        this.lockoutUserWarning = n2;
        this.lockoutAttrName = string2;
        this.lockoutAttrValue = string3;
        this.failureLockoutDuration = l2;
        if (l2 > 0L) {
            this.memoryLocking = true;
        }
        this.bundleName = string4;
    }

    public boolean isLockoutEnabled() {
        return this.failureLockoutMode && this.failureLockoutCount > 0 && this.failureLockoutTime > 0L;
    }

    public boolean getStoreInvalidAttemptsInDS() {
        return this.storeInvalidAttemptsInDS;
    }

    public void setStoreInvalidAttemptsInDS(boolean bl) {
        this.storeInvalidAttemptsInDS = bl;
    }

    public boolean isMemoryLocking() {
        return this.memoryLocking;
    }

    public int invalidPasswd(String string, String string2, AMIdentity aMIdentity, AccountLockoutInfo accountLockoutInfo) {
        if (accountLockoutInfo == null) {
            accountLockoutInfo = new AccountLockoutInfo();
            loginFailHash.put(string, accountLockoutInfo);
        }
        if (debug.messageEnabled()) {
            debug.message("ISAccountLockout::invalidPasswd with userDN,AMIdentity");
            debug.message("userDN : " + string);
        }
        long l = System.currentTimeMillis();
        int n = accountLockoutInfo.getFailCount();
        long l2 = accountLockoutInfo.getLastFailTime();
        long l3 = accountLockoutInfo.getLockoutAt();
        if (l2 + this.failureLockoutTime > l && ++n == this.failureLockoutCount) {
            l3 = l;
        }
        if (this.storeInvalidAttemptsInDS) {
            HashMap hashMap = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            String string3 = ISAccountLockout.createInvalidAttemptsXML(n, l, l3);
            hashSet.add(string3);
            if (debug.messageEnabled()) {
                debug.message("Invalid Attempt XML being inserted= " + string3);
            }
            hashMap.put(INVALID_ATTEMPTS_XML_ATTR, hashSet);
            try {
                this.setLockoutObjectClass(aMIdentity);
                aMIdentity.setAttributes(hashMap);
                aMIdentity.store();
                debug.message("Stored Invalid Attempt XML ");
            }
            catch (Exception exception) {
                debug.error("Idrepo exception while storing identity attribute", exception);
                return -1;
            }
        } else {
            accountLockoutInfo.setLastFailTime(l);
            accountLockoutInfo.setFailCount(n);
            accountLockoutInfo.setLockoutAt(l3);
            if (l3 > 0L) {
                accountLockoutInfo.setLockout(true);
            }
            accountLockoutInfo.setUserToken(string2);
        }
        if (n == this.failureLockoutCount) {
            if (!this.memoryLocking) {
                this.inactivateUserAccount(aMIdentity);
            }
            try {
                this.sendLockOutNotice(string2);
                this.callbackImpl = AMAuthCallBackImpl.getInstance((String)aMIdentity.getRealm());
                this.callbackImpl.processedAccounttLockout(new Long(l), string2);
            }
            catch (AMAuthCallBackException aMAuthCallBackException) {
                if (debug.getState() >= 1) {
                    debug.error("ISAccountLockout invalidPasswd : error getting callback implementation instance or error from callback module", aMAuthCallBackException);
                }
            }
            catch (Exception exception) {
                debug.message("Error activating account/sendingnotification ", exception);
            }
        }
        this.setWarningCount(n, this.failureLockoutCount);
        return this.userWarningCount;
    }

    public AccountLockoutInfo getAcInfo(String string, AMIdentity aMIdentity) {
        AccountLockoutInfo accountLockoutInfo = null;
        if (this.storeInvalidAttemptsInDS) {
            accountLockoutInfo = new AccountLockoutInfo();
            Set set = Collections.EMPTY_SET;
            try {
                set = aMIdentity.getAttribute(INVALID_ATTEMPTS_XML_ATTR);
            }
            catch (Exception exception) {
                debug.error("Idrepo exception while getting identity attribute");
                return null;
            }
            String string2 = null;
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                string2 = (String)iterator.next();
            }
            int n = 0;
            long l = 0L;
            long l2 = 0L;
            if (string2 != null && string2.length() != 0) {
                String string3 = ISAccountLockout.getElement(string2, INVALID_PASS_COUNT_BEGIN, INVALID_PASS_COUNT_END);
                n = Integer.parseInt(string3);
                String string4 = ISAccountLockout.getElement(string2, LAST_FAILED_BEGIN, LAST_FAILED_END);
                l = Long.parseLong(string4);
                String string5 = ISAccountLockout.getElement(string2, LOCKEDOUT_AT_BEGIN, LOCKEDOUT_AT_END);
                l2 = Long.parseLong(string5);
            }
            accountLockoutInfo.setLastFailTime(l);
            accountLockoutInfo.setFailCount(n);
            accountLockoutInfo.setLockoutAt(l2);
            if (l2 > 0L) {
                accountLockoutInfo.setLockout(true);
            }
            this.setWarningCount(n, this.failureLockoutCount);
            accountLockoutInfo.setWarningCount(this.userWarningCount);
        } else {
            accountLockoutInfo = (AccountLockoutInfo)loginFailHash.get(string);
        }
        return accountLockoutInfo;
    }

    private void setLockoutObjectClass(AMIdentity aMIdentity) {
        try {
            Set set = aMIdentity.getAttribute("objectClass");
            if (set != null && !set.contains(INVALID_ATTEMPTS_XML_OBJECT_CLASS)) {
                set.add(INVALID_ATTEMPTS_XML_OBJECT_CLASS);
                HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
                hashMap.put("ObjectClass", set);
                aMIdentity.setAttributes(hashMap);
            }
        }
        catch (IdRepoException idRepoException) {
            debug.message("ISAccountLockout.setLockoutObjectClass", idRepoException);
        }
        catch (SSOException sSOException) {
            debug.message("ISAccountLockout.setLockoutObjectClass", sSOException);
        }
    }

    public AccountLockoutInfo invalidPasswd(AMUser aMUser, AccountLockoutInfo accountLockoutInfo) {
        String string = aMUser.getDN();
        if (debug.messageEnabled()) {
            debug.message("ISAccountLockout::invalidPasswd with AMUser");
            debug.message("userDN : " + string);
            debug.message("acinfo : " + accountLockoutInfo);
        }
        long l = System.currentTimeMillis();
        if (accountLockoutInfo == null) {
            debug.message("First failure... :");
            accountLockoutInfo = new AccountLockoutInfo();
            accountLockoutInfo.setLastFailTime(l);
        }
        int n = 0;
        if (accountLockoutInfo != null) {
            long l2 = accountLockoutInfo.getLastFailTime();
            n = accountLockoutInfo.getFailCount();
            long l3 = this.failureLockoutTime;
            if (l2 + l3 > l) {
                if (n >= this.failureLockoutCount - 1) {
                    accountLockoutInfo.setFailCount(++n);
                    accountLockoutInfo.setLockoutAt(l);
                    if (this.failureLockoutDuration > 0L) {
                        accountLockoutInfo.setLockout(true);
                    } else {
                        accountLockoutInfo.setLockout(false);
                    }
                    try {
                        if (debug.messageEnabled()) {
                            debug.message("lock outuser: userDN=" + string);
                            debug.message("failCount =" + n);
                            debug.message("failureLockoutCount=" + this.failureLockoutCount);
                        }
                        if (aMUser != null && n == this.failureLockoutCount) {
                            String string2 = null;
                            if (!this.memoryLocking) {
                                this.inactivateUserAccount(aMUser);
                            }
                            if (string2 == null) {
                                string2 = string;
                            }
                            this.sendLockOutNotice(string2);
                        }
                    }
                    catch (Exception exception) {
                        debug.message("Error activating account/sendingnotification ", exception);
                    }
                } else {
                    accountLockoutInfo.setFailCount(++n);
                }
            } else {
                debug.message("restart time and count");
                accountLockoutInfo.setFailCount(1);
                accountLockoutInfo.setLastFailTime(l);
                n = 1;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("InvalidPasswd: user: userDN =" + string + "\n\tfailCount = " + n + "\n\tloginFailureLockoutCount = " + this.failureLockoutCount + "\n\tloginLockoutUserWarning = " + this.lockoutUserWarning);
        }
        this.setWarningCount(n, this.failureLockoutCount);
        accountLockoutInfo.setWarningCount(this.userWarningCount);
        return accountLockoutInfo;
    }

    public void sendLockOutNotice(String string) {
        if (debug.messageEnabled()) {
            debug.message("sendLockOutNotice to : " + string);
        }
        if (this.lockoutNotification != null) {
            AMSendMail aMSendMail = new AMSendMail();
            StringTokenizer stringTokenizer = new StringTokenizer(this.lockoutNotification, SPACE_DELIM);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), PIPE_DELIM);
                String[] stringArray = new String[]{stringTokenizer2.nextToken()};
                String string2 = null;
                String string3 = null;
                if (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        string3 = stringTokenizer2.nextToken();
                    }
                }
                ResourceBundle resourceBundle = Locale.getResourceBundle(this.bundleName, string2);
                String string4 = resourceBundle.getString(FROM_ADDRESS);
                String string5 = resourceBundle.getString(EMAIL_SUBJECT);
                Object[] objectArray = new String[]{string};
                String string6 = MessageFormat.format(resourceBundle.getString(EMAIL_MESSAGE), objectArray);
                if (debug.messageEnabled()) {
                    debug.message("sendLockOutNotice:lockoutNotification=" + this.lockoutNotification + " toAddress=" + stringArray);
                }
                try {
                    aMSendMail.postMail(stringArray, string5, string6, string4, string3);
                }
                catch (MessagingException messagingException) {
                    debug.error("cannot email lockout notification:token ", messagingException);
                }
            }
        }
    }

    public boolean isLockedOut(AccountLockoutInfo accountLockoutInfo) {
        boolean bl = accountLockoutInfo.isLockout();
        if (debug.messageEnabled()) {
            debug.message("isLockedOut : " + bl);
        }
        if (accountLockoutInfo != null && bl) {
            long l = System.currentTimeMillis();
            long l2 = accountLockoutInfo.getLockoutAt();
            if (l2 + this.failureLockoutDuration < l) {
                if (debug.messageEnabled()) {
                    debug.message("isLockedOut returns false. loginFailureLockoutDuration=" + this.failureLockoutDuration + " lockOutTime=" + l2 + " now=" + l);
                }
                bl = false;
            }
        }
        return bl;
    }

    private void inactivateUserAccount(AMIdentity aMIdentity) {
        debug.message("inactivateUseraccount: amIdentity");
        try {
            HashMap hashMap = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            if (this.lockoutAttrName != null && this.lockoutAttrValue != null) {
                hashSet.add(this.lockoutAttrValue);
                hashMap.put(this.lockoutAttrName, hashSet);
            }
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet2.add(USER_INACTIVE);
            hashMap.put(USER_STATUS_ATTR, hashSet2);
            aMIdentity.setAttributes(hashMap);
            aMIdentity.store();
        }
        catch (Exception exception) {
            debug.error("Error inactivating user account", exception);
        }
    }

    private void inactivateUserAccount(AMUser aMUser) {
        debug.message("inactivateUseraccount");
        try {
            if (this.lockoutAttrName != null && this.lockoutAttrValue != null) {
                aMUser.setStringAttribute(this.lockoutAttrName, this.lockoutAttrValue);
            }
            aMUser.setStringAttribute(USER_STATUS_ATTR, USER_INACTIVE);
            aMUser.store();
        }
        catch (Exception exception) {
            debug.error("Error inactivating user account");
        }
    }

    private void setWarningCount(int n, int n2) {
        int n3;
        this.userWarningCount = 0;
        if (n >= n2) {
            this.userWarningCount = -1;
        } else if (this.lockoutUserWarning > 0 && this.lockoutUserWarning < n2 && n >= (n3 = this.lockoutUserWarning)) {
            this.userWarningCount = n2 - n;
        }
    }

    public boolean isAccountLocked(AMIdentity aMIdentity) {
        boolean bl = false;
        if (!this.memoryLocking) {
            try {
                Iterator iterator;
                String string;
                Set set;
                if (this.lockoutAttrName != null && this.lockoutAttrValue != null && (set = aMIdentity.getAttribute(this.lockoutAttrName)) != null && !set.isEmpty() && (string = (String)(iterator = set.iterator()).next()).equals(this.lockoutAttrValue)) {
                    bl = true;
                }
                if (!bl && (set = aMIdentity.getAttribute(USER_STATUS_ATTR)) != null && !set.isEmpty() && (string = (String)(iterator = set.iterator()).next()).equals(USER_INACTIVE)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                debug.error("Error inactivating user account", exception);
            }
        }
        if (debug.messageEnabled()) {
            if (bl) {
                debug.message("Account is locked");
            } else {
                debug.message("Account is unlocked");
            }
        }
        return bl;
    }

    public boolean isAccountLocked(AMUser aMUser) {
        boolean bl = false;
        if (!this.memoryLocking) {
            try {
                String string;
                if (this.lockoutAttrName != null && this.lockoutAttrValue != null && (string = aMUser.getStringAttribute(this.lockoutAttrName)) != null && string.length() != 0 && string.equals(this.lockoutAttrValue)) {
                    bl = true;
                }
                if (!bl && (string = aMUser.getStringAttribute(USER_STATUS_ATTR)) != null && string.length() != 0 && string.equals(USER_INACTIVE)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                debug.error("Error inactivating user account");
            }
        }
        if (debug.messageEnabled()) {
            if (bl) {
                debug.message("Account is locked");
            } else {
                debug.message("Account is unlocked");
            }
        }
        return bl;
    }

    public void resetLockoutAttempts(String string, AMIdentity aMIdentity, AccountLockoutInfo accountLockoutInfo) {
        if (debug.messageEnabled()) {
            debug.message("ISAccountLockout::resetLockoutAttempts ");
        }
        if (this.storeInvalidAttemptsInDS) {
            try {
                int n = 0;
                long l = 0L;
                long l2 = 0L;
                if (accountLockoutInfo != null) {
                    n = accountLockoutInfo.getFailCount();
                    l = accountLockoutInfo.getLastFailTime();
                    l2 = accountLockoutInfo.getLockoutAt();
                }
                if (n != 0 || l != 0L || l2 != 0L) {
                    HashMap hashMap = new HashMap();
                    HashSet<String> hashSet = new HashSet<String>();
                    String string2 = ISAccountLockout.createInvalidAttemptsXML(0, 0L, 0L);
                    hashSet.add(string2);
                    hashMap.put(INVALID_ATTEMPTS_XML_ATTR, hashSet);
                    this.setLockoutObjectClass(aMIdentity);
                    aMIdentity.setAttributes(hashMap);
                    aMIdentity.store();
                }
                debug.message("ISAccountLockout::resetLockoutAttempts done");
            }
            catch (Exception exception) {
                debug.message("error reseting Lockout Attempts");
            }
        } else {
            loginFailHash.remove(string);
        }
    }

    private static String createInvalidAttemptsXML(int n, long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append(BEGIN_XML).append(INVALID_PASS_COUNT_BEGIN).append(String.valueOf(n)).append(INVALID_PASS_COUNT_END).append(LAST_FAILED_BEGIN).append(String.valueOf(l)).append(LAST_FAILED_END).append(LOCKEDOUT_AT_BEGIN).append(String.valueOf(l2)).append(LOCKEDOUT_AT_END).append(END_XML);
        return stringBuffer.toString();
    }

    private static String getElement(String string, String string2, String string3) {
        String string4 = null;
        if (string != null) {
            int n = string.indexOf(string2);
            int n2 = string.indexOf(string3);
            if (n != -1 && n2 != -1 && n + string2.length() < n2) {
                string4 = string.substring(n + string2.length(), n2);
            }
        }
        return string4;
    }
}

