/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class CaseInsensitiveTreeSet
extends TreeSet {
    public CaseInsensitiveTreeSet() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    public CaseInsensitiveTreeSet(boolean bl) {
        super(bl ? String.CASE_INSENSITIVE_ORDER : new DescendingComparator());
    }

    public CaseInsensitiveTreeSet(Collection collection) {
        this(true, collection);
    }

    public CaseInsensitiveTreeSet(boolean bl, Collection collection) {
        this(bl);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    public CaseInsensitiveTreeSet(SortedSet sortedSet) {
        this(true, sortedSet);
    }

    public CaseInsensitiveTreeSet(boolean bl, SortedSet sortedSet) {
        this(bl);
        if (sortedSet != null) {
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    private static class DescendingComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return String.CASE_INSENSITIVE_ORDER.compare(object2, object);
        }

        public boolean equals(Object object) {
            return String.CASE_INSENSITIVE_ORDER.equals(object);
        }
    }
}

