/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.I18n;
import com.iplanet.services.util.XMLException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    protected static I18n i18n = I18n.getInstance("amSDK");
    private static DocumentBuilderFactory dbFactory = null;
    private static String ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
    private static String VALUE_NODE = "Value";
    static /* synthetic */ Class class$com$iplanet$services$util$XMLUtils;

    public static Document toDOMDocument(String string, Debug debug) {
        try {
            Object object;
            if (dbFactory == null) {
                object = class$com$iplanet$services$util$XMLUtils == null ? (class$com$iplanet$services$util$XMLUtils = XMLUtils.class$("com.iplanet.services.util.XMLUtils")) : class$com$iplanet$services$util$XMLUtils;
                synchronized (object) {
                    block16: {
                        if (dbFactory == null) {
                            try {
                                dbFactory = DocumentBuilderFactory.newInstance();
                                dbFactory.setValidating(false);
                                dbFactory.setNamespaceAware(true);
                            }
                            catch (Exception exception) {
                                if (debug == null) break block16;
                                debug.error("XMLUtils.DocumentBuilder init failed", exception);
                            }
                        }
                    }
                }
            }
            if (string == null) {
                return null;
            }
            object = null;
            DocumentBuilderFactory documentBuilderFactory = dbFactory;
            synchronized (documentBuilderFactory) {
                object = dbFactory.newDocumentBuilder();
            }
            if (object == null) {
                if (debug != null) {
                    debug.error("XMLUtils.toDOM : null builder instance");
                }
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            return ((DocumentBuilder)object).parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document:\n" + string, exception);
            }
            return null;
        }
    }

    public static Document getXMLDocument(String string) throws XMLException, UnsupportedEncodingException {
        int n = string.indexOf("encoding=");
        String string2 = "UTF-8";
        if (n != -1) {
            int n2;
            int n3 = string.indexOf(34, n);
            int n4 = n2 = n3 == -1 ? n3 : string.indexOf(34, n3 + 1);
            if (n3 != -1 && n2 != -1) {
                string2 = string.substring(n3 + 1, n2);
            }
        }
        byte[] byArray = string.getBytes(string2);
        return XMLUtils.getXMLDocument(new ByteArrayInputStream(byArray));
    }

    public static Document getXMLDocument(InputStream inputStream) throws XMLException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (SAXParseException sAXParseException) {
            String string = "\n" + sAXParseException.getMessage() + "\n";
            Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
            throw new XMLException(string + i18n.getString("XMLUtils.parser_error", objectArray));
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{new String(sAXException.getMessage())};
            throw new XMLException(i18n.getString("XMLUtils.exception_message", objectArray));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{new String(parserConfigurationException.getMessage())};
            throw new XMLException(i18n.getString("XMLUtils.invalid_xml_document", objectArray));
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{new String(iOException.getMessage())};
            throw new XMLException(i18n.getString("XMLUtils.invalid_input_stream", objectArray));
        }
    }

    public static Node getRootNode(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(string)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static Node getNamedChildNode(Node node, String string, String string2, String string3) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (string.equalsIgnoreCase(node2.getNodeName()) && XMLUtils.getNodeAttributeValue(node2, string2).equalsIgnoreCase(string3)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static Set getChildNodes(Node node, String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(string)) {
                hashSet.add(node2);
            }
            ++n;
        }
        return hashSet;
    }

    public static String getNodeAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static Set getAttributeValuePair(Node node) {
        if (!node.getNodeName().equals(ATTR_VALUE_PAIR_NODE)) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(VALUE_NODE)) {
                hashSet.add(XMLUtils.getValueOfValueNode(node2));
            }
            ++n;
        }
        return hashSet;
    }

    public static String getValueOfValueNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            stringBuffer.append(node2.getNodeValue());
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public static String escapeSpecialCharacters(String string) {
        char c;
        String string2 = string;
        StringBuffer stringBuffer = null;
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '&' || c == '<' || c == '>' || c == '\'' || c == '\"' || c == '\n') {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n2));
            while (n2 < n) {
                c = string.charAt(n2);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("&#xD;");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

