/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class JCEEncryption
implements AMEncryption,
ConfigurableKey {
    private static final byte VERSION = 1;
    private static final String CRYPTO_DESCRIPTOR;
    private static final String CRYPTO_DESCRIPTOR_PROPERTY_NAME = "amCryptoDescriptor";
    private static final String CRYPTO_DESCRIPTOR_DEFAULT_VALUE = "PBEWithMD5AndDES";
    private static final String CRYPTO_DESCRIPTOR_PROVIDER;
    private static final String CRYPTO_DESCRIPTOR_PROVIDER_PROPERTY_NAME = "amCryptoDescriptor.provider";
    private static final String CRYPTO_DESCRIPTOR_PROVIDER_DEFAULT_VALUE = "SunJCE";
    private static final String KEYGEN_ALGORITHM;
    private static final String KEYGEN_ALGORITHM_PROPERTY_NAME = "amKeyGenDescriptor";
    private static final String KEYGEN_ALGORITHM_DEFAULT_VALUE = "PBEWithMD5AndDES";
    private static final String KEYGEN_ALGORITHM_PROVIDER;
    private static final String KEYGEN_ALGORITHM_PROVIDER_PROPERTY_NAME = "amKeyGenDescriptor.provider";
    private static final String KEYGEN_ALGORITHM_PROVIDER_DEFAULT_VALUE = "SunJCE";
    private static final int DEFAULT_KEYGEN_ALG_INDEX = 2;
    private static final int DEFAULT_ENC_ALG_INDEX = 2;
    private static final int ITERATION_COUNT = 5;
    private static Debug debug;
    private static final byte[] ___y;
    private SecretKey pbeKey;
    private boolean _initialized = false;
    private static PBEParameterSpec pbeParameterSpec;

    public byte[] encrypt(byte[] byArray) {
        return this.pbeEncrypt(byArray);
    }

    public byte[] decrypt(byte[] byArray) {
        return this.pbeDecrypt(byArray);
    }

    private static void registerSunJCEProvider() {
        block10: {
            String string = "com.sun.crypto.provider.SunJCE";
            Provider[] providerArray = Security.getProviders();
            boolean bl = false;
            if (providerArray != null && providerArray.length > 0) {
                int n = 0;
                while (n < providerArray.length) {
                    if (providerArray[n].getClass().getName().equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                if (debug != null && debug.warningEnabled()) {
                    debug.warning("JCEEncryption: SunJCE provider not registered. Attempting to register...");
                }
                Provider provider = null;
                try {
                    Class<?> clazz = Class.forName(string);
                    provider = (Provider)clazz.newInstance();
                    Security.addProvider(provider);
                    if (debug != null && debug.messageEnabled()) {
                        debug.message("JCEEncryption: registered SunJCE provider");
                    }
                    break block10;
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.error("JCEEncryption: exception while registering provider", exception);
                    }
                    break block10;
                }
            }
            if (debug != null && debug.messageEnabled()) {
                debug.message("JCEEncryption: SunJCE provider is already registered.");
            }
        }
    }

    private byte[] pbeEncrypt(byte[] byArray) {
        byte[] byArray2;
        block13: {
            byArray2 = null;
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            if (this._initialized) {
                try {
                    byte[] byArray3 = new byte[2];
                    byArray3[1] = 2;
                    byArray3[0] = 2;
                    Cipher cipher = null;
                    try {
                        cipher = Cipher.getInstance(CRYPTO_DESCRIPTOR, CRYPTO_DESCRIPTOR_PROVIDER);
                    }
                    catch (Exception exception) {
                        if (exception instanceof NoSuchAlgorithmException || exception instanceof NoSuchPaddingException) {
                            if (debug != null) {
                                debug.error("JCEEncryption: Exception caught: ", exception);
                            }
                            JCEEncryption.registerSunJCEProvider();
                            cipher = Cipher.getInstance(CRYPTO_DESCRIPTOR);
                        }
                        throw exception;
                    }
                    if (cipher != null) {
                        cipher.init(1, (Key)this.pbeKey, pbeParameterSpec);
                        byArray2 = cipher.doFinal(byArray);
                        byte[] byArray4 = cipher.getIV();
                        byArray2 = JCEEncryption.addPrefix(byArray3, byArray4, byArray2);
                    } else if (debug != null) {
                        debug.error("JCEEncryption: Failed to obtain Cipher");
                    }
                    break block13;
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.error("JCEEncryption:: failed to encrypt data", exception);
                    }
                    break block13;
                }
            }
            if (debug != null) {
                debug.error("JCEEncryption:: not yet initialized");
            }
        }
        return byArray2;
    }

    private static byte[] addPrefix(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray3.length + 11];
        byArray4[0] = 1;
        byArray4[1] = byArray[0];
        byArray4[2] = byArray[1];
        int n = 0;
        while (n < 8) {
            byArray4[3 + n] = byArray2[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < byArray3.length) {
            byArray4[11 + n2] = byArray3[n2];
            ++n2;
        }
        return byArray4;
    }

    private byte[] pbeDecrypt(byte[] byArray) {
        byte[] byArray2;
        block14: {
            byArray2 = null;
            if (this._initialized) {
                try {
                    byte[] byArray3 = byArray;
                    if (byArray3[0] != 1) {
                        if (debug != null) {
                            debug.error("JCEEncryption:: Unsported version: " + byArray3[0]);
                        }
                        return null;
                    }
                    byte[] byArray4 = JCEEncryption.getRaw(byArray3);
                    Cipher cipher = null;
                    try {
                        cipher = Cipher.getInstance(CRYPTO_DESCRIPTOR, CRYPTO_DESCRIPTOR_PROVIDER);
                    }
                    catch (Exception exception) {
                        if (exception instanceof NoSuchAlgorithmException || exception instanceof NoSuchPaddingException) {
                            if (debug != null) {
                                debug.error("JCEEncryption: Exception caught: ", exception);
                            }
                            JCEEncryption.registerSunJCEProvider();
                            cipher = Cipher.getInstance(CRYPTO_DESCRIPTOR);
                        }
                        throw exception;
                    }
                    if (cipher != null) {
                        cipher.init(2, (Key)this.pbeKey, pbeParameterSpec);
                        byArray2 = cipher.doFinal(byArray4);
                    } else if (debug != null) {
                        debug.error("JCEEncryption: Failed to obtain Cipher");
                    }
                    break block14;
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.error("JCEEncryption:: failed to decrypt data", exception);
                    }
                    break block14;
                }
            }
            if (debug != null) {
                debug.error("JCEEncryption:: not yet initialized");
            }
        }
        return byArray2;
    }

    private static byte[] getRaw(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - 11];
        int n = 11;
        while (n < byArray.length) {
            byArray2[n - 11] = byArray[n];
            ++n;
        }
        return byArray2;
    }

    private static byte[] getIV(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray2[n] = byArray[n + 3];
            ++n;
        }
        return byArray2;
    }

    private static byte[] getType(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[2]};
        return byArray2;
    }

    public void setPassword(String string) throws Exception {
        this.pbeKey = SecretKeyFactory.getInstance(KEYGEN_ALGORITHM, KEYGEN_ALGORITHM_PROVIDER).generateSecret(new PBEKeySpec(string.toCharArray()));
        this._initialized = true;
    }

    static {
        debug = Debug.getInstance("amSDK");
        CRYPTO_DESCRIPTOR = System.getProperty(CRYPTO_DESCRIPTOR_PROPERTY_NAME, "PBEWithMD5AndDES");
        KEYGEN_ALGORITHM = System.getProperty(KEYGEN_ALGORITHM_PROPERTY_NAME, "PBEWithMD5AndDES");
        CRYPTO_DESCRIPTOR_PROVIDER = System.getProperty(CRYPTO_DESCRIPTOR_PROVIDER_PROPERTY_NAME, "SunJCE");
        KEYGEN_ALGORITHM_PROVIDER = System.getProperty(KEYGEN_ALGORITHM_PROVIDER_PROPERTY_NAME, "SunJCE");
        ___y = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        pbeParameterSpec = new PBEParameterSpec(___y, 5);
    }
}

